package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintJobStatus;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.PrintDocumentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "status", 
    "createdBy"})
@JsonInclude(Include.NON_NULL)
public class PrintJob extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printJob";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("status")
    protected PrintJobStatus status;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    protected PrintJob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintJob() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private PrintJobStatus status;
        private UserIdentity createdBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder status(PrintJobStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public PrintJob build() {
            PrintJob _x = new PrintJob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printJob";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.status = status;
            _x.createdBy = createdBy;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PrintJob withCreatedDateTime(OffsetDateTime createdDateTime) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<PrintJobStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public PrintJob withStatus(PrintJobStatus status) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.status = status;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public PrintJob withCreatedBy(UserIdentity createdBy) {
        PrintJob _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJob");
        _x.createdBy = createdBy;
        return _x;
    }

    @NavigationProperty(name="documents")
    @JsonIgnore
    public PrintDocumentCollectionRequest getDocuments() {
        return new PrintDocumentCollectionRequest(
                        contextPath.addSegment("documents"));
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public PrintTaskCollectionRequest getTasks() {
        return new PrintTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintJob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintJob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintJob _copy() {
        PrintJob _x = new PrintJob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.status = status;
        _x.createdBy = createdBy;
        return _x;
    }

    @Action(name = "cancelPrintJob")
    @JsonIgnore
    public ActionRequestNoReturn cancelPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelPrintJob"), _parameters);
    }

    @Action(name = "startPrintJob")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus> startPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startPrintJob"), PrintJobStatus.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "redirect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJob> redirect(String destinationPrinterId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("destinationPrinterId", "Edm.String", Checks.checkIsAscii(destinationPrinterId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJob>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.redirect"), PrintJob.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintJob[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
