package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintSettings;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintServiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterShareCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ReportRootCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class Print extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.print";
    }

    @JsonProperty("settings")
    protected PrintSettings settings;

    protected Print() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrint() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PrintSettings settings;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder settings(PrintSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Print build() {
            Print _x = new Print();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.print";
            _x.id = id;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<PrintSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public Print withSettings(PrintSettings settings) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.settings = settings;
        return _x;
    }

    @NavigationProperty(name="services")
    @JsonIgnore
    public PrintServiceCollectionRequest getServices() {
        return new PrintServiceCollectionRequest(
                        contextPath.addSegment("services"));
    }

    @NavigationProperty(name="printers")
    @JsonIgnore
    public PrinterCollectionRequest getPrinters() {
        return new PrinterCollectionRequest(
                        contextPath.addSegment("printers"));
    }

    @NavigationProperty(name="connectors")
    @JsonIgnore
    public PrintConnectorCollectionRequest getConnectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"));
    }

    @NavigationProperty(name="shares")
    @JsonIgnore
    public PrinterShareCollectionRequest getShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("shares"));
    }

    @NavigationProperty(name="printerShares")
    @JsonIgnore
    public PrinterShareCollectionRequest getPrinterShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("printerShares"));
    }

    @NavigationProperty(name="reports")
    @JsonIgnore
    public ReportRootCollectionRequest getReports() {
        return new ReportRootCollectionRequest(
                        contextPath.addSegment("reports"));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public PrintOperationCollectionRequest getOperations() {
        return new PrintOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    @NavigationProperty(name="taskDefinitions")
    @JsonIgnore
    public PrintTaskDefinitionCollectionRequest getTaskDefinitions() {
        return new PrintTaskDefinitionCollectionRequest(
                        contextPath.addSegment("taskDefinitions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Print patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Print _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Print put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Print _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Print _copy() {
        Print _x = new Print();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.settings = settings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Print[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
