package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "availability", 
    "activity"})
@JsonInclude(Include.NON_NULL)
public class Presence extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.presence";
    }

    @JsonProperty("availability")
    protected String availability;

    @JsonProperty("activity")
    protected String activity;

    protected Presence() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPresence() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String availability;
        private String activity;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder availability(String availability) {
            this.availability = availability;
            this.changedFields = changedFields.add("availability");
            return this;
        }

        public Builder activity(String activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Presence build() {
            Presence _x = new Presence();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.presence";
            _x.id = id;
            _x.availability = availability;
            _x.activity = activity;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="availability")
    @JsonIgnore
    public Optional<String> getAvailability() {
        return Optional.ofNullable(availability);
    }

    public Presence withAvailability(String availability) {
        Presence _x = _copy();
        _x.changedFields = changedFields.add("availability");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.presence");
        _x.availability = availability;
        return _x;
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<String> getActivity() {
        return Optional.ofNullable(activity);
    }

    public Presence withActivity(String activity) {
        Presence _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.presence");
        _x.activity = activity;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Presence patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Presence _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Presence put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Presence _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Presence _copy() {
        Presence _x = new Presence();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.availability = availability;
        _x.activity = activity;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Presence[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("availability=");
        b.append(this.availability);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
