package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.entity.collection.request.ActivityBasedTimeoutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.request.AdminConsentRequestPolicyRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationFlowsPolicyRequest;
import odata.msgraph.client.beta.entity.request.DeviceRegistrationPolicyRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleAccessReviewPolicyRequest;
import odata.msgraph.client.beta.entity.request.IdentitySecurityDefaultsEnforcementPolicyRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class PolicyRoot extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.policyRoot";
    }

    protected PolicyRoot() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPolicyRoot() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public PolicyRoot build() {
            PolicyRoot _x = new PolicyRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.policyRoot";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="authenticationFlowsPolicy")
    @JsonIgnore
    public AuthenticationFlowsPolicyRequest getAuthenticationFlowsPolicy() {
        return new AuthenticationFlowsPolicyRequest(contextPath.addSegment("authenticationFlowsPolicy"));
    }

    @NavigationProperty(name="deviceRegistrationPolicy")
    @JsonIgnore
    public DeviceRegistrationPolicyRequest getDeviceRegistrationPolicy() {
        return new DeviceRegistrationPolicyRequest(contextPath.addSegment("deviceRegistrationPolicy"));
    }

    @NavigationProperty(name="activityBasedTimeoutPolicies")
    @JsonIgnore
    public ActivityBasedTimeoutPolicyCollectionRequest getActivityBasedTimeoutPolicies() {
        return new ActivityBasedTimeoutPolicyCollectionRequest(
                        contextPath.addSegment("activityBasedTimeoutPolicies"));
    }

    @NavigationProperty(name="claimsMappingPolicies")
    @JsonIgnore
    public ClaimsMappingPolicyCollectionRequest getClaimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"));
    }

    @NavigationProperty(name="homeRealmDiscoveryPolicies")
    @JsonIgnore
    public HomeRealmDiscoveryPolicyCollectionRequest getHomeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    @NavigationProperty(name="tokenIssuancePolicies")
    @JsonIgnore
    public TokenIssuancePolicyCollectionRequest getTokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"));
    }

    @NavigationProperty(name="tokenLifetimePolicies")
    @JsonIgnore
    public TokenLifetimePolicyCollectionRequest getTokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"));
    }

    @NavigationProperty(name="adminConsentRequestPolicy")
    @JsonIgnore
    public AdminConsentRequestPolicyRequest getAdminConsentRequestPolicy() {
        return new AdminConsentRequestPolicyRequest(contextPath.addSegment("adminConsentRequestPolicy"));
    }

    @NavigationProperty(name="directoryRoleAccessReviewPolicy")
    @JsonIgnore
    public DirectoryRoleAccessReviewPolicyRequest getDirectoryRoleAccessReviewPolicy() {
        return new DirectoryRoleAccessReviewPolicyRequest(contextPath.addSegment("directoryRoleAccessReviewPolicy"));
    }

    @NavigationProperty(name="identitySecurityDefaultsEnforcementPolicy")
    @JsonIgnore
    public IdentitySecurityDefaultsEnforcementPolicyRequest getIdentitySecurityDefaultsEnforcementPolicy() {
        return new IdentitySecurityDefaultsEnforcementPolicyRequest(contextPath.addSegment("identitySecurityDefaultsEnforcementPolicy"));
    }

    @NavigationProperty(name="conditionalAccessPolicies")
    @JsonIgnore
    public ConditionalAccessPolicyCollectionRequest getConditionalAccessPolicies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("conditionalAccessPolicies"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicyRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PolicyRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicyRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PolicyRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PolicyRoot _copy() {
        PolicyRoot _x = new PolicyRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PolicyRoot[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
