package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.PlannerAppliedCategories;
import odata.msgraph.client.beta.complex.PlannerAssignments;
import odata.msgraph.client.beta.entity.request.PlannerAssignedToTaskBoardTaskFormatRequest;
import odata.msgraph.client.beta.entity.request.PlannerBucketTaskBoardTaskFormatRequest;
import odata.msgraph.client.beta.entity.request.PlannerProgressTaskBoardTaskFormatRequest;
import odata.msgraph.client.beta.entity.request.PlannerTaskDetailsRequest;
import odata.msgraph.client.beta.enums.PlannerPreviewType;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "planId", 
    "bucketId", 
    "title", 
    "orderHint", 
    "assigneePriority", 
    "percentComplete", 
    "priority", 
    "startDateTime", 
    "createdDateTime", 
    "dueDateTime", 
    "hasDescription", 
    "previewType", 
    "completedDateTime", 
    "completedBy", 
    "referenceCount", 
    "checklistItemCount", 
    "activeChecklistItemCount", 
    "appliedCategories", 
    "assignments", 
    "conversationThreadId"})
@JsonInclude(Include.NON_NULL)
public class PlannerTask extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerTask";
    }

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("planId")
    protected String planId;

    @JsonProperty("bucketId")
    protected String bucketId;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("orderHint")
    protected String orderHint;

    @JsonProperty("assigneePriority")
    protected String assigneePriority;

    @JsonProperty("percentComplete")
    protected Integer percentComplete;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("dueDateTime")
    protected OffsetDateTime dueDateTime;

    @JsonProperty("hasDescription")
    protected Boolean hasDescription;

    @JsonProperty("previewType")
    protected PlannerPreviewType previewType;

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("completedBy")
    protected IdentitySet completedBy;

    @JsonProperty("referenceCount")
    protected Integer referenceCount;

    @JsonProperty("checklistItemCount")
    protected Integer checklistItemCount;

    @JsonProperty("activeChecklistItemCount")
    protected Integer activeChecklistItemCount;

    @JsonProperty("appliedCategories")
    protected PlannerAppliedCategories appliedCategories;

    @JsonProperty("assignments")
    protected PlannerAssignments assignments;

    @JsonProperty("conversationThreadId")
    protected String conversationThreadId;

    protected PlannerTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private String planId;
        private String bucketId;
        private String title;
        private String orderHint;
        private String assigneePriority;
        private Integer percentComplete;
        private Integer priority;
        private OffsetDateTime startDateTime;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime dueDateTime;
        private Boolean hasDescription;
        private PlannerPreviewType previewType;
        private OffsetDateTime completedDateTime;
        private IdentitySet completedBy;
        private Integer referenceCount;
        private Integer checklistItemCount;
        private Integer activeChecklistItemCount;
        private PlannerAppliedCategories appliedCategories;
        private PlannerAssignments assignments;
        private String conversationThreadId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder planId(String planId) {
            this.planId = planId;
            this.changedFields = changedFields.add("planId");
            return this;
        }

        public Builder bucketId(String bucketId) {
            this.bucketId = bucketId;
            this.changedFields = changedFields.add("bucketId");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder orderHint(String orderHint) {
            this.orderHint = orderHint;
            this.changedFields = changedFields.add("orderHint");
            return this;
        }

        public Builder assigneePriority(String assigneePriority) {
            this.assigneePriority = assigneePriority;
            this.changedFields = changedFields.add("assigneePriority");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.changedFields = changedFields.add("percentComplete");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder hasDescription(Boolean hasDescription) {
            this.hasDescription = hasDescription;
            this.changedFields = changedFields.add("hasDescription");
            return this;
        }

        public Builder previewType(PlannerPreviewType previewType) {
            this.previewType = previewType;
            this.changedFields = changedFields.add("previewType");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder completedBy(IdentitySet completedBy) {
            this.completedBy = completedBy;
            this.changedFields = changedFields.add("completedBy");
            return this;
        }

        public Builder referenceCount(Integer referenceCount) {
            this.referenceCount = referenceCount;
            this.changedFields = changedFields.add("referenceCount");
            return this;
        }

        public Builder checklistItemCount(Integer checklistItemCount) {
            this.checklistItemCount = checklistItemCount;
            this.changedFields = changedFields.add("checklistItemCount");
            return this;
        }

        public Builder activeChecklistItemCount(Integer activeChecklistItemCount) {
            this.activeChecklistItemCount = activeChecklistItemCount;
            this.changedFields = changedFields.add("activeChecklistItemCount");
            return this;
        }

        public Builder appliedCategories(PlannerAppliedCategories appliedCategories) {
            this.appliedCategories = appliedCategories;
            this.changedFields = changedFields.add("appliedCategories");
            return this;
        }

        public Builder assignments(PlannerAssignments assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder conversationThreadId(String conversationThreadId) {
            this.conversationThreadId = conversationThreadId;
            this.changedFields = changedFields.add("conversationThreadId");
            return this;
        }

        public PlannerTask build() {
            PlannerTask _x = new PlannerTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerTask";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.planId = planId;
            _x.bucketId = bucketId;
            _x.title = title;
            _x.orderHint = orderHint;
            _x.assigneePriority = assigneePriority;
            _x.percentComplete = percentComplete;
            _x.priority = priority;
            _x.startDateTime = startDateTime;
            _x.createdDateTime = createdDateTime;
            _x.dueDateTime = dueDateTime;
            _x.hasDescription = hasDescription;
            _x.previewType = previewType;
            _x.completedDateTime = completedDateTime;
            _x.completedBy = completedBy;
            _x.referenceCount = referenceCount;
            _x.checklistItemCount = checklistItemCount;
            _x.activeChecklistItemCount = activeChecklistItemCount;
            _x.appliedCategories = appliedCategories;
            _x.assignments = assignments;
            _x.conversationThreadId = conversationThreadId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public PlannerTask withCreatedBy(IdentitySet createdBy) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="planId")
    @JsonIgnore
    public Optional<String> getPlanId() {
        return Optional.ofNullable(planId);
    }

    public PlannerTask withPlanId(String planId) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("planId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.planId = planId;
        return _x;
    }

    @Property(name="bucketId")
    @JsonIgnore
    public Optional<String> getBucketId() {
        return Optional.ofNullable(bucketId);
    }

    public PlannerTask withBucketId(String bucketId) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("bucketId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.bucketId = bucketId;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public PlannerTask withTitle(String title) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.title = title;
        return _x;
    }

    @Property(name="orderHint")
    @JsonIgnore
    public Optional<String> getOrderHint() {
        return Optional.ofNullable(orderHint);
    }

    public PlannerTask withOrderHint(String orderHint) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("orderHint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.orderHint = orderHint;
        return _x;
    }

    @Property(name="assigneePriority")
    @JsonIgnore
    public Optional<String> getAssigneePriority() {
        return Optional.ofNullable(assigneePriority);
    }

    public PlannerTask withAssigneePriority(String assigneePriority) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("assigneePriority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.assigneePriority = assigneePriority;
        return _x;
    }

    @Property(name="percentComplete")
    @JsonIgnore
    public Optional<Integer> getPercentComplete() {
        return Optional.ofNullable(percentComplete);
    }

    public PlannerTask withPercentComplete(Integer percentComplete) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("percentComplete");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.percentComplete = percentComplete;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public PlannerTask withPriority(Integer priority) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.priority = priority;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public PlannerTask withStartDateTime(OffsetDateTime startDateTime) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PlannerTask withCreatedDateTime(OffsetDateTime createdDateTime) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public PlannerTask withDueDateTime(OffsetDateTime dueDateTime) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="hasDescription")
    @JsonIgnore
    public Optional<Boolean> getHasDescription() {
        return Optional.ofNullable(hasDescription);
    }

    public PlannerTask withHasDescription(Boolean hasDescription) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("hasDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.hasDescription = hasDescription;
        return _x;
    }

    @Property(name="previewType")
    @JsonIgnore
    public Optional<PlannerPreviewType> getPreviewType() {
        return Optional.ofNullable(previewType);
    }

    public PlannerTask withPreviewType(PlannerPreviewType previewType) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("previewType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.previewType = previewType;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public PlannerTask withCompletedDateTime(OffsetDateTime completedDateTime) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="completedBy")
    @JsonIgnore
    public Optional<IdentitySet> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    public PlannerTask withCompletedBy(IdentitySet completedBy) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("completedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.completedBy = completedBy;
        return _x;
    }

    @Property(name="referenceCount")
    @JsonIgnore
    public Optional<Integer> getReferenceCount() {
        return Optional.ofNullable(referenceCount);
    }

    public PlannerTask withReferenceCount(Integer referenceCount) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("referenceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.referenceCount = referenceCount;
        return _x;
    }

    @Property(name="checklistItemCount")
    @JsonIgnore
    public Optional<Integer> getChecklistItemCount() {
        return Optional.ofNullable(checklistItemCount);
    }

    public PlannerTask withChecklistItemCount(Integer checklistItemCount) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("checklistItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.checklistItemCount = checklistItemCount;
        return _x;
    }

    @Property(name="activeChecklistItemCount")
    @JsonIgnore
    public Optional<Integer> getActiveChecklistItemCount() {
        return Optional.ofNullable(activeChecklistItemCount);
    }

    public PlannerTask withActiveChecklistItemCount(Integer activeChecklistItemCount) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("activeChecklistItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.activeChecklistItemCount = activeChecklistItemCount;
        return _x;
    }

    @Property(name="appliedCategories")
    @JsonIgnore
    public Optional<PlannerAppliedCategories> getAppliedCategories() {
        return Optional.ofNullable(appliedCategories);
    }

    public PlannerTask withAppliedCategories(PlannerAppliedCategories appliedCategories) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("appliedCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.appliedCategories = appliedCategories;
        return _x;
    }

    @Property(name="assignments")
    @JsonIgnore
    public Optional<PlannerAssignments> getAssignments() {
        return Optional.ofNullable(assignments);
    }

    public PlannerTask withAssignments(PlannerAssignments assignments) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.assignments = assignments;
        return _x;
    }

    @Property(name="conversationThreadId")
    @JsonIgnore
    public Optional<String> getConversationThreadId() {
        return Optional.ofNullable(conversationThreadId);
    }

    public PlannerTask withConversationThreadId(String conversationThreadId) {
        PlannerTask _x = _copy();
        _x.changedFields = changedFields.add("conversationThreadId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTask");
        _x.conversationThreadId = conversationThreadId;
        return _x;
    }

    @NavigationProperty(name="details")
    @JsonIgnore
    public PlannerTaskDetailsRequest getDetails() {
        return new PlannerTaskDetailsRequest(contextPath.addSegment("details"));
    }

    @NavigationProperty(name="assignedToTaskBoardFormat")
    @JsonIgnore
    public PlannerAssignedToTaskBoardTaskFormatRequest getAssignedToTaskBoardFormat() {
        return new PlannerAssignedToTaskBoardTaskFormatRequest(contextPath.addSegment("assignedToTaskBoardFormat"));
    }

    @NavigationProperty(name="progressTaskBoardFormat")
    @JsonIgnore
    public PlannerProgressTaskBoardTaskFormatRequest getProgressTaskBoardFormat() {
        return new PlannerProgressTaskBoardTaskFormatRequest(contextPath.addSegment("progressTaskBoardFormat"));
    }

    @NavigationProperty(name="bucketTaskBoardFormat")
    @JsonIgnore
    public PlannerBucketTaskBoardTaskFormatRequest getBucketTaskBoardFormat() {
        return new PlannerBucketTaskBoardTaskFormatRequest(contextPath.addSegment("bucketTaskBoardFormat"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerTask _copy() {
        PlannerTask _x = new PlannerTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.planId = planId;
        _x.bucketId = bucketId;
        _x.title = title;
        _x.orderHint = orderHint;
        _x.assigneePriority = assigneePriority;
        _x.percentComplete = percentComplete;
        _x.priority = priority;
        _x.startDateTime = startDateTime;
        _x.createdDateTime = createdDateTime;
        _x.dueDateTime = dueDateTime;
        _x.hasDescription = hasDescription;
        _x.previewType = previewType;
        _x.completedDateTime = completedDateTime;
        _x.completedBy = completedBy;
        _x.referenceCount = referenceCount;
        _x.checklistItemCount = checklistItemCount;
        _x.activeChecklistItemCount = activeChecklistItemCount;
        _x.appliedCategories = appliedCategories;
        _x.assignments = assignments;
        _x.conversationThreadId = conversationThreadId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("planId=");
        b.append(this.planId);
        b.append(", ");
        b.append("bucketId=");
        b.append(this.bucketId);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("orderHint=");
        b.append(this.orderHint);
        b.append(", ");
        b.append("assigneePriority=");
        b.append(this.assigneePriority);
        b.append(", ");
        b.append("percentComplete=");
        b.append(this.percentComplete);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("hasDescription=");
        b.append(this.hasDescription);
        b.append(", ");
        b.append("previewType=");
        b.append(this.previewType);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("completedBy=");
        b.append(this.completedBy);
        b.append(", ");
        b.append("referenceCount=");
        b.append(this.referenceCount);
        b.append(", ");
        b.append("checklistItemCount=");
        b.append(this.checklistItemCount);
        b.append(", ");
        b.append("activeChecklistItemCount=");
        b.append(this.activeChecklistItemCount);
        b.append(", ");
        b.append("appliedCategories=");
        b.append(this.appliedCategories);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("conversationThreadId=");
        b.append(this.conversationThreadId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
