package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.PlannerCategoryDescriptions;
import odata.msgraph.client.beta.complex.PlannerPlanContextDetailsCollection;
import odata.msgraph.client.beta.complex.PlannerUserIds;

@JsonPropertyOrder({
    "@odata.type", 
    "sharedWith", 
    "categoryDescriptions", 
    "contextDetails"})
@JsonInclude(Include.NON_NULL)
public class PlannerPlanDetails extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerPlanDetails";
    }

    @JsonProperty("sharedWith")
    protected PlannerUserIds sharedWith;

    @JsonProperty("categoryDescriptions")
    protected PlannerCategoryDescriptions categoryDescriptions;

    @JsonProperty("contextDetails")
    protected PlannerPlanContextDetailsCollection contextDetails;

    protected PlannerPlanDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerPlanDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PlannerUserIds sharedWith;
        private PlannerCategoryDescriptions categoryDescriptions;
        private PlannerPlanContextDetailsCollection contextDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder sharedWith(PlannerUserIds sharedWith) {
            this.sharedWith = sharedWith;
            this.changedFields = changedFields.add("sharedWith");
            return this;
        }

        public Builder categoryDescriptions(PlannerCategoryDescriptions categoryDescriptions) {
            this.categoryDescriptions = categoryDescriptions;
            this.changedFields = changedFields.add("categoryDescriptions");
            return this;
        }

        public Builder contextDetails(PlannerPlanContextDetailsCollection contextDetails) {
            this.contextDetails = contextDetails;
            this.changedFields = changedFields.add("contextDetails");
            return this;
        }

        public PlannerPlanDetails build() {
            PlannerPlanDetails _x = new PlannerPlanDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerPlanDetails";
            _x.id = id;
            _x.sharedWith = sharedWith;
            _x.categoryDescriptions = categoryDescriptions;
            _x.contextDetails = contextDetails;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="sharedWith")
    @JsonIgnore
    public Optional<PlannerUserIds> getSharedWith() {
        return Optional.ofNullable(sharedWith);
    }

    public PlannerPlanDetails withSharedWith(PlannerUserIds sharedWith) {
        PlannerPlanDetails _x = _copy();
        _x.changedFields = changedFields.add("sharedWith");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanDetails");
        _x.sharedWith = sharedWith;
        return _x;
    }

    @Property(name="categoryDescriptions")
    @JsonIgnore
    public Optional<PlannerCategoryDescriptions> getCategoryDescriptions() {
        return Optional.ofNullable(categoryDescriptions);
    }

    public PlannerPlanDetails withCategoryDescriptions(PlannerCategoryDescriptions categoryDescriptions) {
        PlannerPlanDetails _x = _copy();
        _x.changedFields = changedFields.add("categoryDescriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanDetails");
        _x.categoryDescriptions = categoryDescriptions;
        return _x;
    }

    @Property(name="contextDetails")
    @JsonIgnore
    public Optional<PlannerPlanContextDetailsCollection> getContextDetails() {
        return Optional.ofNullable(contextDetails);
    }

    public PlannerPlanDetails withContextDetails(PlannerPlanContextDetailsCollection contextDetails) {
        PlannerPlanDetails _x = _copy();
        _x.changedFields = changedFields.add("contextDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanDetails");
        _x.contextDetails = contextDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerPlanDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerPlanDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerPlanDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerPlanDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerPlanDetails _copy() {
        PlannerPlanDetails _x = new PlannerPlanDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.sharedWith = sharedWith;
        _x.categoryDescriptions = categoryDescriptions;
        _x.contextDetails = contextDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerPlanDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("sharedWith=");
        b.append(this.sharedWith);
        b.append(", ");
        b.append("categoryDescriptions=");
        b.append(this.categoryDescriptions);
        b.append(", ");
        b.append("contextDetails=");
        b.append(this.contextDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
