package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "planId", 
    "orderHint"})
@JsonInclude(Include.NON_NULL)
public class PlannerBucket extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerBucket";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("planId")
    protected String planId;

    @JsonProperty("orderHint")
    protected String orderHint;

    protected PlannerBucket() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerBucket() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String planId;
        private String orderHint;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder planId(String planId) {
            this.planId = planId;
            this.changedFields = changedFields.add("planId");
            return this;
        }

        public Builder orderHint(String orderHint) {
            this.orderHint = orderHint;
            this.changedFields = changedFields.add("orderHint");
            return this;
        }

        public PlannerBucket build() {
            PlannerBucket _x = new PlannerBucket();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerBucket";
            _x.id = id;
            _x.name = name;
            _x.planId = planId;
            _x.orderHint = orderHint;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public PlannerBucket withName(String name) {
        PlannerBucket _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerBucket");
        _x.name = name;
        return _x;
    }

    @Property(name="planId")
    @JsonIgnore
    public Optional<String> getPlanId() {
        return Optional.ofNullable(planId);
    }

    public PlannerBucket withPlanId(String planId) {
        PlannerBucket _x = _copy();
        _x.changedFields = changedFields.add("planId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerBucket");
        _x.planId = planId;
        return _x;
    }

    @Property(name="orderHint")
    @JsonIgnore
    public Optional<String> getOrderHint() {
        return Optional.ofNullable(orderHint);
    }

    public PlannerBucket withOrderHint(String orderHint) {
        PlannerBucket _x = _copy();
        _x.changedFields = changedFields.add("orderHint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerBucket");
        _x.orderHint = orderHint;
        return _x;
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public PlannerTaskCollectionRequest getTasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerBucket patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerBucket _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerBucket put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerBucket _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerBucket _copy() {
        PlannerBucket _x = new PlannerBucket();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.planId = planId;
        _x.orderHint = orderHint;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerBucket[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("planId=");
        b.append(this.planId);
        b.append(", ");
        b.append("orderHint=");
        b.append(this.orderHint);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
