package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.PlannerOrderHintsByAssignee;

@JsonPropertyOrder({
    "@odata.type", 
    "unassignedOrderHint", 
    "orderHintsByAssignee"})
@JsonInclude(Include.NON_NULL)
public class PlannerAssignedToTaskBoardTaskFormat extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerAssignedToTaskBoardTaskFormat";
    }

    @JsonProperty("unassignedOrderHint")
    protected String unassignedOrderHint;

    @JsonProperty("orderHintsByAssignee")
    protected PlannerOrderHintsByAssignee orderHintsByAssignee;

    protected PlannerAssignedToTaskBoardTaskFormat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerAssignedToTaskBoardTaskFormat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String unassignedOrderHint;
        private PlannerOrderHintsByAssignee orderHintsByAssignee;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder unassignedOrderHint(String unassignedOrderHint) {
            this.unassignedOrderHint = unassignedOrderHint;
            this.changedFields = changedFields.add("unassignedOrderHint");
            return this;
        }

        public Builder orderHintsByAssignee(PlannerOrderHintsByAssignee orderHintsByAssignee) {
            this.orderHintsByAssignee = orderHintsByAssignee;
            this.changedFields = changedFields.add("orderHintsByAssignee");
            return this;
        }

        public PlannerAssignedToTaskBoardTaskFormat build() {
            PlannerAssignedToTaskBoardTaskFormat _x = new PlannerAssignedToTaskBoardTaskFormat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerAssignedToTaskBoardTaskFormat";
            _x.id = id;
            _x.unassignedOrderHint = unassignedOrderHint;
            _x.orderHintsByAssignee = orderHintsByAssignee;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="unassignedOrderHint")
    @JsonIgnore
    public Optional<String> getUnassignedOrderHint() {
        return Optional.ofNullable(unassignedOrderHint);
    }

    public PlannerAssignedToTaskBoardTaskFormat withUnassignedOrderHint(String unassignedOrderHint) {
        PlannerAssignedToTaskBoardTaskFormat _x = _copy();
        _x.changedFields = changedFields.add("unassignedOrderHint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerAssignedToTaskBoardTaskFormat");
        _x.unassignedOrderHint = unassignedOrderHint;
        return _x;
    }

    @Property(name="orderHintsByAssignee")
    @JsonIgnore
    public Optional<PlannerOrderHintsByAssignee> getOrderHintsByAssignee() {
        return Optional.ofNullable(orderHintsByAssignee);
    }

    public PlannerAssignedToTaskBoardTaskFormat withOrderHintsByAssignee(PlannerOrderHintsByAssignee orderHintsByAssignee) {
        PlannerAssignedToTaskBoardTaskFormat _x = _copy();
        _x.changedFields = changedFields.add("orderHintsByAssignee");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerAssignedToTaskBoardTaskFormat");
        _x.orderHintsByAssignee = orderHintsByAssignee;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerAssignedToTaskBoardTaskFormat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerAssignedToTaskBoardTaskFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerAssignedToTaskBoardTaskFormat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerAssignedToTaskBoardTaskFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerAssignedToTaskBoardTaskFormat _copy() {
        PlannerAssignedToTaskBoardTaskFormat _x = new PlannerAssignedToTaskBoardTaskFormat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.unassignedOrderHint = unassignedOrderHint;
        _x.orderHintsByAssignee = orderHintsByAssignee;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerAssignedToTaskBoardTaskFormat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("unassignedOrderHint=");
        b.append(this.unassignedOrderHint);
        b.append(", ");
        b.append("orderHintsByAssignee=");
        b.append(this.orderHintsByAssignee);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
