package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.OutlookGeoCoordinates;
import odata.msgraph.client.beta.complex.PhysicalAddress;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "geoCoordinates", 
    "phone", 
    "address"})
@JsonInclude(Include.NON_NULL)
public class Place extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.place";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("geoCoordinates")
    protected OutlookGeoCoordinates geoCoordinates;

    @JsonProperty("phone")
    protected String phone;

    @JsonProperty("address")
    protected PhysicalAddress address;

    protected Place() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Place withDisplayName(String displayName) {
        Place _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.place");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="geoCoordinates")
    @JsonIgnore
    public Optional<OutlookGeoCoordinates> getGeoCoordinates() {
        return Optional.ofNullable(geoCoordinates);
    }

    public Place withGeoCoordinates(OutlookGeoCoordinates geoCoordinates) {
        Place _x = _copy();
        _x.changedFields = changedFields.add("geoCoordinates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.place");
        _x.geoCoordinates = geoCoordinates;
        return _x;
    }

    @Property(name="phone")
    @JsonIgnore
    public Optional<String> getPhone() {
        return Optional.ofNullable(phone);
    }

    public Place withPhone(String phone) {
        Place _x = _copy();
        _x.changedFields = changedFields.add("phone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.place");
        _x.phone = phone;
        return _x;
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PhysicalAddress> getAddress() {
        return Optional.ofNullable(address);
    }

    public Place withAddress(PhysicalAddress address) {
        Place _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.place");
        _x.address = address;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Place patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Place _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Place put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Place _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Place _copy() {
        Place _x = new Place();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.geoCoordinates = geoCoordinates;
        _x.phone = phone;
        _x.address = address;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Place[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("geoCoordinates=");
        b.append(this.geoCoordinates);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
