package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSource;
import odata.msgraph.client.beta.complex.YomiPersonName;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "first", 
    "initials", 
    "last", 
    "languageTag", 
    "maiden", 
    "middle", 
    "nickname", 
    "suffix", 
    "title", 
    "pronunciation"})
@JsonInclude(Include.NON_NULL)
public class PersonName extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personName";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("first")
    protected String first;

    @JsonProperty("initials")
    protected String initials;

    @JsonProperty("last")
    protected String last;

    @JsonProperty("languageTag")
    protected String languageTag;

    @JsonProperty("maiden")
    protected String maiden;

    @JsonProperty("middle")
    protected String middle;

    @JsonProperty("nickname")
    protected String nickname;

    @JsonProperty("suffix")
    protected String suffix;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("pronunciation")
    protected YomiPersonName pronunciation;

    protected PersonName() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPersonName() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private InferenceData inference;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private PersonDataSource source;
        private String displayName;
        private String first;
        private String initials;
        private String last;
        private String languageTag;
        private String maiden;
        private String middle;
        private String nickname;
        private String suffix;
        private String title;
        private YomiPersonName pronunciation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder source(PersonDataSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder first(String first) {
            this.first = first;
            this.changedFields = changedFields.add("first");
            return this;
        }

        public Builder initials(String initials) {
            this.initials = initials;
            this.changedFields = changedFields.add("initials");
            return this;
        }

        public Builder last(String last) {
            this.last = last;
            this.changedFields = changedFields.add("last");
            return this;
        }

        public Builder languageTag(String languageTag) {
            this.languageTag = languageTag;
            this.changedFields = changedFields.add("languageTag");
            return this;
        }

        public Builder maiden(String maiden) {
            this.maiden = maiden;
            this.changedFields = changedFields.add("maiden");
            return this;
        }

        public Builder middle(String middle) {
            this.middle = middle;
            this.changedFields = changedFields.add("middle");
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = nickname;
            this.changedFields = changedFields.add("nickname");
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            this.changedFields = changedFields.add("suffix");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder pronunciation(YomiPersonName pronunciation) {
            this.pronunciation = pronunciation;
            this.changedFields = changedFields.add("pronunciation");
            return this;
        }

        public PersonName build() {
            PersonName _x = new PersonName();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.personName";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.inference = inference;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.source = source;
            _x.displayName = displayName;
            _x.first = first;
            _x.initials = initials;
            _x.last = last;
            _x.languageTag = languageTag;
            _x.maiden = maiden;
            _x.middle = middle;
            _x.nickname = nickname;
            _x.suffix = suffix;
            _x.title = title;
            _x.pronunciation = pronunciation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PersonName withDisplayName(String displayName) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="first")
    @JsonIgnore
    public Optional<String> getFirst() {
        return Optional.ofNullable(first);
    }

    public PersonName withFirst(String first) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("first");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.first = first;
        return _x;
    }

    @Property(name="initials")
    @JsonIgnore
    public Optional<String> getInitials() {
        return Optional.ofNullable(initials);
    }

    public PersonName withInitials(String initials) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("initials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.initials = initials;
        return _x;
    }

    @Property(name="last")
    @JsonIgnore
    public Optional<String> getLast() {
        return Optional.ofNullable(last);
    }

    public PersonName withLast(String last) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("last");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.last = last;
        return _x;
    }

    @Property(name="languageTag")
    @JsonIgnore
    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(languageTag);
    }

    public PersonName withLanguageTag(String languageTag) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("languageTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.languageTag = languageTag;
        return _x;
    }

    @Property(name="maiden")
    @JsonIgnore
    public Optional<String> getMaiden() {
        return Optional.ofNullable(maiden);
    }

    public PersonName withMaiden(String maiden) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("maiden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.maiden = maiden;
        return _x;
    }

    @Property(name="middle")
    @JsonIgnore
    public Optional<String> getMiddle() {
        return Optional.ofNullable(middle);
    }

    public PersonName withMiddle(String middle) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("middle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.middle = middle;
        return _x;
    }

    @Property(name="nickname")
    @JsonIgnore
    public Optional<String> getNickname() {
        return Optional.ofNullable(nickname);
    }

    public PersonName withNickname(String nickname) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("nickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.nickname = nickname;
        return _x;
    }

    @Property(name="suffix")
    @JsonIgnore
    public Optional<String> getSuffix() {
        return Optional.ofNullable(suffix);
    }

    public PersonName withSuffix(String suffix) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("suffix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.suffix = suffix;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public PersonName withTitle(String title) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.title = title;
        return _x;
    }

    @Property(name="pronunciation")
    @JsonIgnore
    public Optional<YomiPersonName> getPronunciation() {
        return Optional.ofNullable(pronunciation);
    }

    public PersonName withPronunciation(YomiPersonName pronunciation) {
        PersonName _x = _copy();
        _x.changedFields = changedFields.add("pronunciation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personName");
        _x.pronunciation = pronunciation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonName patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PersonName _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonName put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PersonName _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PersonName _copy() {
        PersonName _x = new PersonName();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.inference = inference;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.source = source;
        _x.displayName = displayName;
        _x.first = first;
        _x.initials = initials;
        _x.last = last;
        _x.languageTag = languageTag;
        _x.maiden = maiden;
        _x.middle = middle;
        _x.nickname = nickname;
        _x.suffix = suffix;
        _x.title = title;
        _x.pronunciation = pronunciation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonName[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("first=");
        b.append(this.first);
        b.append(", ");
        b.append("initials=");
        b.append(this.initials);
        b.append(", ");
        b.append("last=");
        b.append(this.last);
        b.append(", ");
        b.append("languageTag=");
        b.append(this.languageTag);
        b.append(", ");
        b.append("maiden=");
        b.append(this.maiden);
        b.append(", ");
        b.append("middle=");
        b.append(this.middle);
        b.append(", ");
        b.append("nickname=");
        b.append(this.nickname);
        b.append(", ");
        b.append("suffix=");
        b.append(this.suffix);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("pronunciation=");
        b.append(this.pronunciation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
