package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PermissionType;

@JsonPropertyOrder({
    "@odata.type", 
    "permissionClassification", 
    "permissionType", 
    "resourceApplication", 
    "permissions", 
    "clientApplicationIds", 
    "clientApplicationTenantIds", 
    "clientApplicationPublisherIds", 
    "clientApplicationsFromVerifiedPublisherOnly"})
@JsonInclude(Include.NON_NULL)
public class PermissionGrantConditionSet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.permissionGrantConditionSet";
    }

    @JsonProperty("permissionClassification")
    protected String permissionClassification;

    @JsonProperty("permissionType")
    protected PermissionType permissionType;

    @JsonProperty("resourceApplication")
    protected String resourceApplication;

    @JsonProperty("permissions")
    protected List<String> permissions;

    @JsonProperty("permissions@nextLink")
    protected String permissionsNextLink;

    @JsonProperty("clientApplicationIds")
    protected List<String> clientApplicationIds;

    @JsonProperty("clientApplicationIds@nextLink")
    protected String clientApplicationIdsNextLink;

    @JsonProperty("clientApplicationTenantIds")
    protected List<String> clientApplicationTenantIds;

    @JsonProperty("clientApplicationTenantIds@nextLink")
    protected String clientApplicationTenantIdsNextLink;

    @JsonProperty("clientApplicationPublisherIds")
    protected List<String> clientApplicationPublisherIds;

    @JsonProperty("clientApplicationPublisherIds@nextLink")
    protected String clientApplicationPublisherIdsNextLink;

    @JsonProperty("clientApplicationsFromVerifiedPublisherOnly")
    protected Boolean clientApplicationsFromVerifiedPublisherOnly;

    protected PermissionGrantConditionSet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPermissionGrantConditionSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String permissionClassification;
        private PermissionType permissionType;
        private String resourceApplication;
        private List<String> permissions;
        private String permissionsNextLink;
        private List<String> clientApplicationIds;
        private String clientApplicationIdsNextLink;
        private List<String> clientApplicationTenantIds;
        private String clientApplicationTenantIdsNextLink;
        private List<String> clientApplicationPublisherIds;
        private String clientApplicationPublisherIdsNextLink;
        private Boolean clientApplicationsFromVerifiedPublisherOnly;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder permissionClassification(String permissionClassification) {
            this.permissionClassification = permissionClassification;
            this.changedFields = changedFields.add("permissionClassification");
            return this;
        }

        public Builder permissionType(PermissionType permissionType) {
            this.permissionType = permissionType;
            this.changedFields = changedFields.add("permissionType");
            return this;
        }

        public Builder resourceApplication(String resourceApplication) {
            this.resourceApplication = resourceApplication;
            this.changedFields = changedFields.add("resourceApplication");
            return this;
        }

        public Builder permissions(List<String> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder permissions(String... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        public Builder permissionsNextLink(String permissionsNextLink) {
            this.permissionsNextLink = permissionsNextLink;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder clientApplicationIds(List<String> clientApplicationIds) {
            this.clientApplicationIds = clientApplicationIds;
            this.changedFields = changedFields.add("clientApplicationIds");
            return this;
        }

        public Builder clientApplicationIds(String... clientApplicationIds) {
            return clientApplicationIds(Arrays.asList(clientApplicationIds));
        }

        public Builder clientApplicationIdsNextLink(String clientApplicationIdsNextLink) {
            this.clientApplicationIdsNextLink = clientApplicationIdsNextLink;
            this.changedFields = changedFields.add("clientApplicationIds");
            return this;
        }

        public Builder clientApplicationTenantIds(List<String> clientApplicationTenantIds) {
            this.clientApplicationTenantIds = clientApplicationTenantIds;
            this.changedFields = changedFields.add("clientApplicationTenantIds");
            return this;
        }

        public Builder clientApplicationTenantIds(String... clientApplicationTenantIds) {
            return clientApplicationTenantIds(Arrays.asList(clientApplicationTenantIds));
        }

        public Builder clientApplicationTenantIdsNextLink(String clientApplicationTenantIdsNextLink) {
            this.clientApplicationTenantIdsNextLink = clientApplicationTenantIdsNextLink;
            this.changedFields = changedFields.add("clientApplicationTenantIds");
            return this;
        }

        public Builder clientApplicationPublisherIds(List<String> clientApplicationPublisherIds) {
            this.clientApplicationPublisherIds = clientApplicationPublisherIds;
            this.changedFields = changedFields.add("clientApplicationPublisherIds");
            return this;
        }

        public Builder clientApplicationPublisherIds(String... clientApplicationPublisherIds) {
            return clientApplicationPublisherIds(Arrays.asList(clientApplicationPublisherIds));
        }

        public Builder clientApplicationPublisherIdsNextLink(String clientApplicationPublisherIdsNextLink) {
            this.clientApplicationPublisherIdsNextLink = clientApplicationPublisherIdsNextLink;
            this.changedFields = changedFields.add("clientApplicationPublisherIds");
            return this;
        }

        public Builder clientApplicationsFromVerifiedPublisherOnly(Boolean clientApplicationsFromVerifiedPublisherOnly) {
            this.clientApplicationsFromVerifiedPublisherOnly = clientApplicationsFromVerifiedPublisherOnly;
            this.changedFields = changedFields.add("clientApplicationsFromVerifiedPublisherOnly");
            return this;
        }

        public PermissionGrantConditionSet build() {
            PermissionGrantConditionSet _x = new PermissionGrantConditionSet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.permissionGrantConditionSet";
            _x.id = id;
            _x.permissionClassification = permissionClassification;
            _x.permissionType = permissionType;
            _x.resourceApplication = resourceApplication;
            _x.permissions = permissions;
            _x.permissionsNextLink = permissionsNextLink;
            _x.clientApplicationIds = clientApplicationIds;
            _x.clientApplicationIdsNextLink = clientApplicationIdsNextLink;
            _x.clientApplicationTenantIds = clientApplicationTenantIds;
            _x.clientApplicationTenantIdsNextLink = clientApplicationTenantIdsNextLink;
            _x.clientApplicationPublisherIds = clientApplicationPublisherIds;
            _x.clientApplicationPublisherIdsNextLink = clientApplicationPublisherIdsNextLink;
            _x.clientApplicationsFromVerifiedPublisherOnly = clientApplicationsFromVerifiedPublisherOnly;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="permissionClassification")
    @JsonIgnore
    public Optional<String> getPermissionClassification() {
        return Optional.ofNullable(permissionClassification);
    }

    public PermissionGrantConditionSet withPermissionClassification(String permissionClassification) {
        PermissionGrantConditionSet _x = _copy();
        _x.changedFields = changedFields.add("permissionClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionGrantConditionSet");
        _x.permissionClassification = permissionClassification;
        return _x;
    }

    @Property(name="permissionType")
    @JsonIgnore
    public Optional<PermissionType> getPermissionType() {
        return Optional.ofNullable(permissionType);
    }

    public PermissionGrantConditionSet withPermissionType(PermissionType permissionType) {
        PermissionGrantConditionSet _x = _copy();
        _x.changedFields = changedFields.add("permissionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionGrantConditionSet");
        _x.permissionType = permissionType;
        return _x;
    }

    @Property(name="resourceApplication")
    @JsonIgnore
    public Optional<String> getResourceApplication() {
        return Optional.ofNullable(resourceApplication);
    }

    public PermissionGrantConditionSet withResourceApplication(String resourceApplication) {
        PermissionGrantConditionSet _x = _copy();
        _x.changedFields = changedFields.add("resourceApplication");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionGrantConditionSet");
        _x.resourceApplication = resourceApplication;
        return _x;
    }

    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<String> getPermissions() {
        return new CollectionPage<String>(contextPath, String.class, permissions, Optional.ofNullable(permissionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<String> getPermissions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, permissions, Optional.ofNullable(permissionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="clientApplicationIds")
    @JsonIgnore
    public CollectionPage<String> getClientApplicationIds() {
        return new CollectionPage<String>(contextPath, String.class, clientApplicationIds, Optional.ofNullable(clientApplicationIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="clientApplicationIds")
    @JsonIgnore
    public CollectionPage<String> getClientApplicationIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, clientApplicationIds, Optional.ofNullable(clientApplicationIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="clientApplicationTenantIds")
    @JsonIgnore
    public CollectionPage<String> getClientApplicationTenantIds() {
        return new CollectionPage<String>(contextPath, String.class, clientApplicationTenantIds, Optional.ofNullable(clientApplicationTenantIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="clientApplicationTenantIds")
    @JsonIgnore
    public CollectionPage<String> getClientApplicationTenantIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, clientApplicationTenantIds, Optional.ofNullable(clientApplicationTenantIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="clientApplicationPublisherIds")
    @JsonIgnore
    public CollectionPage<String> getClientApplicationPublisherIds() {
        return new CollectionPage<String>(contextPath, String.class, clientApplicationPublisherIds, Optional.ofNullable(clientApplicationPublisherIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="clientApplicationPublisherIds")
    @JsonIgnore
    public CollectionPage<String> getClientApplicationPublisherIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, clientApplicationPublisherIds, Optional.ofNullable(clientApplicationPublisherIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="clientApplicationsFromVerifiedPublisherOnly")
    @JsonIgnore
    public Optional<Boolean> getClientApplicationsFromVerifiedPublisherOnly() {
        return Optional.ofNullable(clientApplicationsFromVerifiedPublisherOnly);
    }

    public PermissionGrantConditionSet withClientApplicationsFromVerifiedPublisherOnly(Boolean clientApplicationsFromVerifiedPublisherOnly) {
        PermissionGrantConditionSet _x = _copy();
        _x.changedFields = changedFields.add("clientApplicationsFromVerifiedPublisherOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionGrantConditionSet");
        _x.clientApplicationsFromVerifiedPublisherOnly = clientApplicationsFromVerifiedPublisherOnly;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PermissionGrantConditionSet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PermissionGrantConditionSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PermissionGrantConditionSet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PermissionGrantConditionSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PermissionGrantConditionSet _copy() {
        PermissionGrantConditionSet _x = new PermissionGrantConditionSet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.permissionClassification = permissionClassification;
        _x.permissionType = permissionType;
        _x.resourceApplication = resourceApplication;
        _x.permissions = permissions;
        _x.clientApplicationIds = clientApplicationIds;
        _x.clientApplicationTenantIds = clientApplicationTenantIds;
        _x.clientApplicationPublisherIds = clientApplicationPublisherIds;
        _x.clientApplicationsFromVerifiedPublisherOnly = clientApplicationsFromVerifiedPublisherOnly;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PermissionGrantConditionSet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("permissionClassification=");
        b.append(this.permissionClassification);
        b.append(", ");
        b.append("permissionType=");
        b.append(this.permissionType);
        b.append(", ");
        b.append("resourceApplication=");
        b.append(this.resourceApplication);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append(", ");
        b.append("clientApplicationIds=");
        b.append(this.clientApplicationIds);
        b.append(", ");
        b.append("clientApplicationTenantIds=");
        b.append(this.clientApplicationTenantIds);
        b.append(", ");
        b.append("clientApplicationPublisherIds=");
        b.append(this.clientApplicationPublisherIds);
        b.append(", ");
        b.append("clientApplicationsFromVerifiedPublisherOnly=");
        b.append(this.clientApplicationsFromVerifiedPublisherOnly);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
