package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DriveRecipient;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.SharingInvitation;
import odata.msgraph.client.beta.complex.SharingLink;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "expirationDateTime", 
    "grantedTo", 
    "grantedToIdentities", 
    "hasPassword", 
    "inheritedFrom", 
    "invitation", 
    "link", 
    "roles", 
    "shareId"})
@JsonInclude(Include.NON_NULL)
public class Permission extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.permission";
    }

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("grantedTo")
    protected IdentitySet grantedTo;

    @JsonProperty("grantedToIdentities")
    protected List<IdentitySet> grantedToIdentities;

    @JsonProperty("grantedToIdentities@nextLink")
    protected String grantedToIdentitiesNextLink;

    @JsonProperty("hasPassword")
    protected Boolean hasPassword;

    @JsonProperty("inheritedFrom")
    protected ItemReference inheritedFrom;

    @JsonProperty("invitation")
    protected SharingInvitation invitation;

    @JsonProperty("link")
    protected SharingLink link;

    @JsonProperty("roles")
    protected List<String> roles;

    @JsonProperty("roles@nextLink")
    protected String rolesNextLink;

    @JsonProperty("shareId")
    protected String shareId;

    protected Permission() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPermission() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime expirationDateTime;
        private IdentitySet grantedTo;
        private List<IdentitySet> grantedToIdentities;
        private String grantedToIdentitiesNextLink;
        private Boolean hasPassword;
        private ItemReference inheritedFrom;
        private SharingInvitation invitation;
        private SharingLink link;
        private List<String> roles;
        private String rolesNextLink;
        private String shareId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder grantedTo(IdentitySet grantedTo) {
            this.grantedTo = grantedTo;
            this.changedFields = changedFields.add("grantedTo");
            return this;
        }

        public Builder grantedToIdentities(List<IdentitySet> grantedToIdentities) {
            this.grantedToIdentities = grantedToIdentities;
            this.changedFields = changedFields.add("grantedToIdentities");
            return this;
        }

        public Builder grantedToIdentities(IdentitySet... grantedToIdentities) {
            return grantedToIdentities(Arrays.asList(grantedToIdentities));
        }

        public Builder grantedToIdentitiesNextLink(String grantedToIdentitiesNextLink) {
            this.grantedToIdentitiesNextLink = grantedToIdentitiesNextLink;
            this.changedFields = changedFields.add("grantedToIdentities");
            return this;
        }

        public Builder hasPassword(Boolean hasPassword) {
            this.hasPassword = hasPassword;
            this.changedFields = changedFields.add("hasPassword");
            return this;
        }

        public Builder inheritedFrom(ItemReference inheritedFrom) {
            this.inheritedFrom = inheritedFrom;
            this.changedFields = changedFields.add("inheritedFrom");
            return this;
        }

        public Builder invitation(SharingInvitation invitation) {
            this.invitation = invitation;
            this.changedFields = changedFields.add("invitation");
            return this;
        }

        public Builder link(SharingLink link) {
            this.link = link;
            this.changedFields = changedFields.add("link");
            return this;
        }

        public Builder roles(List<String> roles) {
            this.roles = roles;
            this.changedFields = changedFields.add("roles");
            return this;
        }

        public Builder roles(String... roles) {
            return roles(Arrays.asList(roles));
        }

        public Builder rolesNextLink(String rolesNextLink) {
            this.rolesNextLink = rolesNextLink;
            this.changedFields = changedFields.add("roles");
            return this;
        }

        public Builder shareId(String shareId) {
            this.shareId = shareId;
            this.changedFields = changedFields.add("shareId");
            return this;
        }

        public Permission build() {
            Permission _x = new Permission();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.permission";
            _x.id = id;
            _x.expirationDateTime = expirationDateTime;
            _x.grantedTo = grantedTo;
            _x.grantedToIdentities = grantedToIdentities;
            _x.grantedToIdentitiesNextLink = grantedToIdentitiesNextLink;
            _x.hasPassword = hasPassword;
            _x.inheritedFrom = inheritedFrom;
            _x.invitation = invitation;
            _x.link = link;
            _x.roles = roles;
            _x.rolesNextLink = rolesNextLink;
            _x.shareId = shareId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public Permission withExpirationDateTime(OffsetDateTime expirationDateTime) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="grantedTo")
    @JsonIgnore
    public Optional<IdentitySet> getGrantedTo() {
        return Optional.ofNullable(grantedTo);
    }

    public Permission withGrantedTo(IdentitySet grantedTo) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("grantedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.grantedTo = grantedTo;
        return _x;
    }

    @Property(name="grantedToIdentities")
    @JsonIgnore
    public CollectionPage<IdentitySet> getGrantedToIdentities() {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, grantedToIdentities, Optional.ofNullable(grantedToIdentitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="grantedToIdentities")
    @JsonIgnore
    public CollectionPage<IdentitySet> getGrantedToIdentities(HttpRequestOptions options) {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, grantedToIdentities, Optional.ofNullable(grantedToIdentitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="hasPassword")
    @JsonIgnore
    public Optional<Boolean> getHasPassword() {
        return Optional.ofNullable(hasPassword);
    }

    public Permission withHasPassword(Boolean hasPassword) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("hasPassword");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.hasPassword = hasPassword;
        return _x;
    }

    @Property(name="inheritedFrom")
    @JsonIgnore
    public Optional<ItemReference> getInheritedFrom() {
        return Optional.ofNullable(inheritedFrom);
    }

    public Permission withInheritedFrom(ItemReference inheritedFrom) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("inheritedFrom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.inheritedFrom = inheritedFrom;
        return _x;
    }

    @Property(name="invitation")
    @JsonIgnore
    public Optional<SharingInvitation> getInvitation() {
        return Optional.ofNullable(invitation);
    }

    public Permission withInvitation(SharingInvitation invitation) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("invitation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.invitation = invitation;
        return _x;
    }

    @Property(name="link")
    @JsonIgnore
    public Optional<SharingLink> getLink() {
        return Optional.ofNullable(link);
    }

    public Permission withLink(SharingLink link) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("link");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.link = link;
        return _x;
    }

    @Property(name="roles")
    @JsonIgnore
    public CollectionPage<String> getRoles() {
        return new CollectionPage<String>(contextPath, String.class, roles, Optional.ofNullable(rolesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="roles")
    @JsonIgnore
    public CollectionPage<String> getRoles(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roles, Optional.ofNullable(rolesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="shareId")
    @JsonIgnore
    public Optional<String> getShareId() {
        return Optional.ofNullable(shareId);
    }

    public Permission withShareId(String shareId) {
        Permission _x = _copy();
        _x.changedFields = changedFields.add("shareId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permission");
        _x.shareId = shareId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Permission patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Permission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Permission put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Permission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Permission _copy() {
        Permission _x = new Permission();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.expirationDateTime = expirationDateTime;
        _x.grantedTo = grantedTo;
        _x.grantedToIdentities = grantedToIdentities;
        _x.hasPassword = hasPassword;
        _x.inheritedFrom = inheritedFrom;
        _x.invitation = invitation;
        _x.link = link;
        _x.roles = roles;
        _x.shareId = shareId;
        return _x;
    }

    @Action(name = "grant")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Permission> grant(List<String> roles, List<DriveRecipient> recipients) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("roles", "Collection(Edm.String)", Checks.checkIsAscii(roles))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.grant"), Permission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Permission[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("grantedTo=");
        b.append(this.grantedTo);
        b.append(", ");
        b.append("grantedToIdentities=");
        b.append(this.grantedToIdentities);
        b.append(", ");
        b.append("hasPassword=");
        b.append(this.hasPassword);
        b.append(", ");
        b.append("inheritedFrom=");
        b.append(this.inheritedFrom);
        b.append(", ");
        b.append("invitation=");
        b.append(this.invitation);
        b.append(", ");
        b.append("link=");
        b.append(this.link);
        b.append(", ");
        b.append("roles=");
        b.append(this.roles);
        b.append(", ");
        b.append("shareId=");
        b.append(this.shareId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
