package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "displayName", 
    "dueDateCalculation", 
    "discountDateCalculation", 
    "discountPercent", 
    "calculateDiscountOnCreditMemos", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class PaymentTerm extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.paymentTerm";
    }

    @JsonProperty("code")
    protected String code;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("dueDateCalculation")
    protected String dueDateCalculation;

    @JsonProperty("discountDateCalculation")
    protected String discountDateCalculation;

    @JsonProperty("discountPercent")
    protected BigDecimal discountPercent;

    @JsonProperty("calculateDiscountOnCreditMemos")
    protected Boolean calculateDiscountOnCreditMemos;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected PaymentTerm() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPaymentTerm() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String code;
        private String displayName;
        private String dueDateCalculation;
        private String discountDateCalculation;
        private BigDecimal discountPercent;
        private Boolean calculateDiscountOnCreditMemos;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder dueDateCalculation(String dueDateCalculation) {
            this.dueDateCalculation = dueDateCalculation;
            this.changedFields = changedFields.add("dueDateCalculation");
            return this;
        }

        public Builder discountDateCalculation(String discountDateCalculation) {
            this.discountDateCalculation = discountDateCalculation;
            this.changedFields = changedFields.add("discountDateCalculation");
            return this;
        }

        public Builder discountPercent(BigDecimal discountPercent) {
            this.discountPercent = discountPercent;
            this.changedFields = changedFields.add("discountPercent");
            return this;
        }

        public Builder calculateDiscountOnCreditMemos(Boolean calculateDiscountOnCreditMemos) {
            this.calculateDiscountOnCreditMemos = calculateDiscountOnCreditMemos;
            this.changedFields = changedFields.add("calculateDiscountOnCreditMemos");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public PaymentTerm build() {
            PaymentTerm _x = new PaymentTerm();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.paymentTerm";
            _x.id = id;
            _x.code = code;
            _x.displayName = displayName;
            _x.dueDateCalculation = dueDateCalculation;
            _x.discountDateCalculation = discountDateCalculation;
            _x.discountPercent = discountPercent;
            _x.calculateDiscountOnCreditMemos = calculateDiscountOnCreditMemos;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public PaymentTerm withCode(String code) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("code");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.code = code;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PaymentTerm withDisplayName(String displayName) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="dueDateCalculation")
    @JsonIgnore
    public Optional<String> getDueDateCalculation() {
        return Optional.ofNullable(dueDateCalculation);
    }

    public PaymentTerm withDueDateCalculation(String dueDateCalculation) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("dueDateCalculation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.dueDateCalculation = dueDateCalculation;
        return _x;
    }

    @Property(name="discountDateCalculation")
    @JsonIgnore
    public Optional<String> getDiscountDateCalculation() {
        return Optional.ofNullable(discountDateCalculation);
    }

    public PaymentTerm withDiscountDateCalculation(String discountDateCalculation) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("discountDateCalculation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.discountDateCalculation = discountDateCalculation;
        return _x;
    }

    @Property(name="discountPercent")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountPercent() {
        return Optional.ofNullable(discountPercent);
    }

    public PaymentTerm withDiscountPercent(BigDecimal discountPercent) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("discountPercent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.discountPercent = discountPercent;
        return _x;
    }

    @Property(name="calculateDiscountOnCreditMemos")
    @JsonIgnore
    public Optional<Boolean> getCalculateDiscountOnCreditMemos() {
        return Optional.ofNullable(calculateDiscountOnCreditMemos);
    }

    public PaymentTerm withCalculateDiscountOnCreditMemos(Boolean calculateDiscountOnCreditMemos) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("calculateDiscountOnCreditMemos");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.calculateDiscountOnCreditMemos = calculateDiscountOnCreditMemos;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public PaymentTerm withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PaymentTerm _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.paymentTerm");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PaymentTerm patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PaymentTerm _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PaymentTerm put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PaymentTerm _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PaymentTerm _copy() {
        PaymentTerm _x = new PaymentTerm();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.code = code;
        _x.displayName = displayName;
        _x.dueDateCalculation = dueDateCalculation;
        _x.discountDateCalculation = discountDateCalculation;
        _x.discountPercent = discountPercent;
        _x.calculateDiscountOnCreditMemos = calculateDiscountOnCreditMemos;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PaymentTerm[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateCalculation=");
        b.append(this.dueDateCalculation);
        b.append(", ");
        b.append("discountDateCalculation=");
        b.append(this.discountDateCalculation);
        b.append(", ");
        b.append("discountPercent=");
        b.append(this.discountPercent);
        b.append(", ");
        b.append("calculateDiscountOnCreditMemos=");
        b.append(this.calculateDiscountOnCreditMemos);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
