package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MediaStream;
import odata.msgraph.client.beta.complex.ParticipantInfo;
import odata.msgraph.client.beta.complex.RecordingInfo;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "info", 
    "recordingInfo", 
    "mediaStreams", 
    "metadata", 
    "isMuted", 
    "isInLobby"})
@JsonInclude(Include.NON_NULL)
public class Participant extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.participant";
    }

    @JsonProperty("info")
    protected ParticipantInfo info;

    @JsonProperty("recordingInfo")
    protected RecordingInfo recordingInfo;

    @JsonProperty("mediaStreams")
    protected List<MediaStream> mediaStreams;

    @JsonProperty("mediaStreams@nextLink")
    protected String mediaStreamsNextLink;

    @JsonProperty("metadata")
    protected String metadata;

    @JsonProperty("isMuted")
    protected Boolean isMuted;

    @JsonProperty("isInLobby")
    protected Boolean isInLobby;

    protected Participant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderParticipant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ParticipantInfo info;
        private RecordingInfo recordingInfo;
        private List<MediaStream> mediaStreams;
        private String mediaStreamsNextLink;
        private String metadata;
        private Boolean isMuted;
        private Boolean isInLobby;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder info(ParticipantInfo info) {
            this.info = info;
            this.changedFields = changedFields.add("info");
            return this;
        }

        public Builder recordingInfo(RecordingInfo recordingInfo) {
            this.recordingInfo = recordingInfo;
            this.changedFields = changedFields.add("recordingInfo");
            return this;
        }

        public Builder mediaStreams(List<MediaStream> mediaStreams) {
            this.mediaStreams = mediaStreams;
            this.changedFields = changedFields.add("mediaStreams");
            return this;
        }

        public Builder mediaStreams(MediaStream... mediaStreams) {
            return mediaStreams(Arrays.asList(mediaStreams));
        }

        public Builder mediaStreamsNextLink(String mediaStreamsNextLink) {
            this.mediaStreamsNextLink = mediaStreamsNextLink;
            this.changedFields = changedFields.add("mediaStreams");
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder isMuted(Boolean isMuted) {
            this.isMuted = isMuted;
            this.changedFields = changedFields.add("isMuted");
            return this;
        }

        public Builder isInLobby(Boolean isInLobby) {
            this.isInLobby = isInLobby;
            this.changedFields = changedFields.add("isInLobby");
            return this;
        }

        public Participant build() {
            Participant _x = new Participant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.participant";
            _x.id = id;
            _x.info = info;
            _x.recordingInfo = recordingInfo;
            _x.mediaStreams = mediaStreams;
            _x.mediaStreamsNextLink = mediaStreamsNextLink;
            _x.metadata = metadata;
            _x.isMuted = isMuted;
            _x.isInLobby = isInLobby;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="info")
    @JsonIgnore
    public Optional<ParticipantInfo> getInfo() {
        return Optional.ofNullable(info);
    }

    public Participant withInfo(ParticipantInfo info) {
        Participant _x = _copy();
        _x.changedFields = changedFields.add("info");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participant");
        _x.info = info;
        return _x;
    }

    @Property(name="recordingInfo")
    @JsonIgnore
    public Optional<RecordingInfo> getRecordingInfo() {
        return Optional.ofNullable(recordingInfo);
    }

    public Participant withRecordingInfo(RecordingInfo recordingInfo) {
        Participant _x = _copy();
        _x.changedFields = changedFields.add("recordingInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participant");
        _x.recordingInfo = recordingInfo;
        return _x;
    }

    @Property(name="mediaStreams")
    @JsonIgnore
    public CollectionPage<MediaStream> getMediaStreams() {
        return new CollectionPage<MediaStream>(contextPath, MediaStream.class, mediaStreams, Optional.ofNullable(mediaStreamsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mediaStreams")
    @JsonIgnore
    public CollectionPage<MediaStream> getMediaStreams(HttpRequestOptions options) {
        return new CollectionPage<MediaStream>(contextPath, MediaStream.class, mediaStreams, Optional.ofNullable(mediaStreamsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="metadata")
    @JsonIgnore
    public Optional<String> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    public Participant withMetadata(String metadata) {
        Participant _x = _copy();
        _x.changedFields = changedFields.add("metadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participant");
        _x.metadata = metadata;
        return _x;
    }

    @Property(name="isMuted")
    @JsonIgnore
    public Optional<Boolean> getIsMuted() {
        return Optional.ofNullable(isMuted);
    }

    public Participant withIsMuted(Boolean isMuted) {
        Participant _x = _copy();
        _x.changedFields = changedFields.add("isMuted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participant");
        _x.isMuted = isMuted;
        return _x;
    }

    @Property(name="isInLobby")
    @JsonIgnore
    public Optional<Boolean> getIsInLobby() {
        return Optional.ofNullable(isInLobby);
    }

    public Participant withIsInLobby(Boolean isInLobby) {
        Participant _x = _copy();
        _x.changedFields = changedFields.add("isInLobby");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participant");
        _x.isInLobby = isInLobby;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Participant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Participant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Participant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Participant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Participant _copy() {
        Participant _x = new Participant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.info = info;
        _x.recordingInfo = recordingInfo;
        _x.mediaStreams = mediaStreams;
        _x.metadata = metadata;
        _x.isMuted = isMuted;
        _x.isInLobby = isInLobby;
        return _x;
    }

    @Action(name = "mute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation> mute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mute"), MuteParticipantOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Participant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("info=");
        b.append(this.info);
        b.append(", ");
        b.append("recordingInfo=");
        b.append(this.recordingInfo);
        b.append(", ");
        b.append("mediaStreams=");
        b.append(this.mediaStreams);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("isMuted=");
        b.append(this.isMuted);
        b.append(", ");
        b.append("isInLobby=");
        b.append(this.isInLobby);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
