package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "changeKey", 
    "name", 
    "isDefaultFolder", 
    "parentGroupKey"})
@JsonInclude(Include.NON_NULL)
public class OutlookTaskFolder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outlookTaskFolder";
    }

    @JsonProperty("changeKey")
    protected String changeKey;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("isDefaultFolder")
    protected Boolean isDefaultFolder;

    @JsonProperty("parentGroupKey")
    protected String parentGroupKey;

    protected OutlookTaskFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOutlookTaskFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String changeKey;
        private String name;
        private Boolean isDefaultFolder;
        private String parentGroupKey;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder isDefaultFolder(Boolean isDefaultFolder) {
            this.isDefaultFolder = isDefaultFolder;
            this.changedFields = changedFields.add("isDefaultFolder");
            return this;
        }

        public Builder parentGroupKey(String parentGroupKey) {
            this.parentGroupKey = parentGroupKey;
            this.changedFields = changedFields.add("parentGroupKey");
            return this;
        }

        public OutlookTaskFolder build() {
            OutlookTaskFolder _x = new OutlookTaskFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.outlookTaskFolder";
            _x.id = id;
            _x.changeKey = changeKey;
            _x.name = name;
            _x.isDefaultFolder = isDefaultFolder;
            _x.parentGroupKey = parentGroupKey;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public OutlookTaskFolder withChangeKey(String changeKey) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("changeKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.changeKey = changeKey;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public OutlookTaskFolder withName(String name) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.name = name;
        return _x;
    }

    @Property(name="isDefaultFolder")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultFolder() {
        return Optional.ofNullable(isDefaultFolder);
    }

    public OutlookTaskFolder withIsDefaultFolder(Boolean isDefaultFolder) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("isDefaultFolder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.isDefaultFolder = isDefaultFolder;
        return _x;
    }

    @Property(name="parentGroupKey")
    @JsonIgnore
    public Optional<String> getParentGroupKey() {
        return Optional.ofNullable(parentGroupKey);
    }

    public OutlookTaskFolder withParentGroupKey(String parentGroupKey) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("parentGroupKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.parentGroupKey = parentGroupKey;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * 
     * @return navigational property tasks
     */
    @NavigationProperty(name="tasks")
    @JsonIgnore
    public OutlookTaskCollectionRequest getTasks() {
        return new OutlookTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTaskFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OutlookTaskFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTaskFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OutlookTaskFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OutlookTaskFolder _copy() {
        OutlookTaskFolder _x = new OutlookTaskFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.changeKey = changeKey;
        _x.name = name;
        _x.isDefaultFolder = isDefaultFolder;
        _x.parentGroupKey = parentGroupKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutlookTaskFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("isDefaultFolder=");
        b.append(this.isDefaultFolder);
        b.append(", ");
        b.append("parentGroupKey=");
        b.append(this.parentGroupKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
