package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "backgroundColor", 
    "backgroundImage", 
    "bannerLogo", 
    "locale", 
    "signInPageText", 
    "squareLogo", 
    "usernameHintText"})
@JsonInclude(Include.NON_NULL)
public class OrganizationalBranding extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.organizationalBranding";
    }

    @JsonProperty("backgroundColor")
    protected String backgroundColor;

    @JsonProperty("backgroundImage")
    protected String backgroundImage;

    @JsonProperty("bannerLogo")
    protected String bannerLogo;

    @JsonProperty("locale")
    protected String locale;

    @JsonProperty("signInPageText")
    protected String signInPageText;

    @JsonProperty("squareLogo")
    protected String squareLogo;

    @JsonProperty("usernameHintText")
    protected String usernameHintText;

    protected OrganizationalBranding() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOrganizationalBranding() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String backgroundColor;
        private String backgroundImage;
        private String bannerLogo;
        private String locale;
        private String signInPageText;
        private String squareLogo;
        private String usernameHintText;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.changedFields = changedFields.add("backgroundColor");
            return this;
        }

        public Builder backgroundImage(String backgroundImage) {
            this.backgroundImage = backgroundImage;
            this.changedFields = changedFields.add("backgroundImage");
            return this;
        }

        public Builder bannerLogo(String bannerLogo) {
            this.bannerLogo = bannerLogo;
            this.changedFields = changedFields.add("bannerLogo");
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            this.changedFields = changedFields.add("locale");
            return this;
        }

        public Builder signInPageText(String signInPageText) {
            this.signInPageText = signInPageText;
            this.changedFields = changedFields.add("signInPageText");
            return this;
        }

        public Builder squareLogo(String squareLogo) {
            this.squareLogo = squareLogo;
            this.changedFields = changedFields.add("squareLogo");
            return this;
        }

        public Builder usernameHintText(String usernameHintText) {
            this.usernameHintText = usernameHintText;
            this.changedFields = changedFields.add("usernameHintText");
            return this;
        }

        public OrganizationalBranding build() {
            OrganizationalBranding _x = new OrganizationalBranding();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.organizationalBranding";
            _x.id = id;
            _x.backgroundColor = backgroundColor;
            _x.backgroundImage = backgroundImage;
            _x.bannerLogo = bannerLogo;
            _x.locale = locale;
            _x.signInPageText = signInPageText;
            _x.squareLogo = squareLogo;
            _x.usernameHintText = usernameHintText;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="backgroundColor")
    @JsonIgnore
    public Optional<String> getBackgroundColor() {
        return Optional.ofNullable(backgroundColor);
    }

    public OrganizationalBranding withBackgroundColor(String backgroundColor) {
        OrganizationalBranding _x = _copy();
        _x.changedFields = changedFields.add("backgroundColor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBranding");
        _x.backgroundColor = backgroundColor;
        return _x;
    }

    @Property(name="backgroundImage")
    @JsonIgnore
    public Optional<StreamProvider> getBackgroundImage() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "backgroundImage", backgroundImage);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code backgroundImage} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderSingleCall> putBackgroundImage() {
        return putBackgroundImage(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code backgroundImage} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="backgroundImage")
    public Optional<StreamUploaderChunked> putChunkedBackgroundImage() {
        return putBackgroundImage(UploadStrategy.chunked());
    }

    @Property(name="backgroundImage")
    public <T extends StreamUploader<T>> Optional<T> putBackgroundImage(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("backgroundImage"), this, "backgroundImage");
    }

    @Property(name="bannerLogo")
    @JsonIgnore
    public Optional<StreamProvider> getBannerLogo() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "bannerLogo", bannerLogo);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code bannerLogo} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderSingleCall> putBannerLogo() {
        return putBannerLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code bannerLogo} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="bannerLogo")
    public Optional<StreamUploaderChunked> putChunkedBannerLogo() {
        return putBannerLogo(UploadStrategy.chunked());
    }

    @Property(name="bannerLogo")
    public <T extends StreamUploader<T>> Optional<T> putBannerLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("bannerLogo"), this, "bannerLogo");
    }

    @Property(name="locale")
    @JsonIgnore
    public Optional<String> getLocale() {
        return Optional.ofNullable(locale);
    }

    public OrganizationalBranding withLocale(String locale) {
        OrganizationalBranding _x = _copy();
        _x.changedFields = changedFields.add("locale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBranding");
        _x.locale = locale;
        return _x;
    }

    @Property(name="signInPageText")
    @JsonIgnore
    public Optional<String> getSignInPageText() {
        return Optional.ofNullable(signInPageText);
    }

    public OrganizationalBranding withSignInPageText(String signInPageText) {
        OrganizationalBranding _x = _copy();
        _x.changedFields = changedFields.add("signInPageText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBranding");
        _x.signInPageText = signInPageText;
        return _x;
    }

    @Property(name="squareLogo")
    @JsonIgnore
    public Optional<StreamProvider> getSquareLogo() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "squareLogo", squareLogo);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code squareLogo} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderSingleCall> putSquareLogo() {
        return putSquareLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code squareLogo} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="squareLogo")
    public Optional<StreamUploaderChunked> putChunkedSquareLogo() {
        return putSquareLogo(UploadStrategy.chunked());
    }

    @Property(name="squareLogo")
    public <T extends StreamUploader<T>> Optional<T> putSquareLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("squareLogo"), this, "squareLogo");
    }

    @Property(name="usernameHintText")
    @JsonIgnore
    public Optional<String> getUsernameHintText() {
        return Optional.ofNullable(usernameHintText);
    }

    public OrganizationalBranding withUsernameHintText(String usernameHintText) {
        OrganizationalBranding _x = _copy();
        _x.changedFields = changedFields.add("usernameHintText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationalBranding");
        _x.usernameHintText = usernameHintText;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationalBranding patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OrganizationalBranding _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationalBranding put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OrganizationalBranding _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OrganizationalBranding _copy() {
        OrganizationalBranding _x = new OrganizationalBranding();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.backgroundColor = backgroundColor;
        _x.backgroundImage = backgroundImage;
        _x.bannerLogo = bannerLogo;
        _x.locale = locale;
        _x.signInPageText = signInPageText;
        _x.squareLogo = squareLogo;
        _x.usernameHintText = usernameHintText;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationalBranding[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("backgroundColor=");
        b.append(this.backgroundColor);
        b.append(", ");
        b.append("backgroundImage=");
        b.append(this.backgroundImage);
        b.append(", ");
        b.append("bannerLogo=");
        b.append(this.bannerLogo);
        b.append(", ");
        b.append("locale=");
        b.append(this.locale);
        b.append(", ");
        b.append("signInPageText=");
        b.append(this.signInPageText);
        b.append(", ");
        b.append("squareLogo=");
        b.append(this.squareLogo);
        b.append(", ");
        b.append("usernameHintText=");
        b.append(this.usernameHintText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
