package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignedPlan;
import odata.msgraph.client.beta.complex.CertificateConnectorSetting;
import odata.msgraph.client.beta.complex.DirectorySizeQuota;
import odata.msgraph.client.beta.complex.PrivacyProfile;
import odata.msgraph.client.beta.complex.ProvisionedPlan;
import odata.msgraph.client.beta.complex.VerifiedDomain;
import odata.msgraph.client.beta.entity.collection.request.CertificateBasedAuthConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OrganizationalBrandingCollectionRequest;
import odata.msgraph.client.beta.entity.request.OrganizationSettingsRequest;
import odata.msgraph.client.beta.enums.MdmAuthority;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The organization resource represents an instance of global settings and
 * resources which operate and are provisioned at the tenant-level.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "assignedPlans", 
    "businessPhones", 
    "city", 
    "country", 
    "countryLetterCode", 
    "createdDateTime", 
    "directorySizeQuota", 
    "displayName", 
    "isMultipleDataLocationsForServicesEnabled", 
    "marketingNotificationEmails", 
    "onPremisesLastSyncDateTime", 
    "onPremisesSyncEnabled", 
    "postalCode", 
    "preferredLanguage", 
    "privacyProfile", 
    "provisionedPlans", 
    "securityComplianceNotificationMails", 
    "securityComplianceNotificationPhones", 
    "state", 
    "street", 
    "technicalNotificationMails", 
    "verifiedDomains", 
    "mobileDeviceManagementAuthority", 
    "certificateConnectorSetting"})
@JsonInclude(Include.NON_NULL)
public class Organization extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.organization";
    }

    @JsonProperty("assignedPlans")
    protected List<AssignedPlan> assignedPlans;

    @JsonProperty("assignedPlans@nextLink")
    protected String assignedPlansNextLink;

    @JsonProperty("businessPhones")
    protected List<String> businessPhones;

    @JsonProperty("businessPhones@nextLink")
    protected String businessPhonesNextLink;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("country")
    protected String country;

    @JsonProperty("countryLetterCode")
    protected String countryLetterCode;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("directorySizeQuota")
    protected DirectorySizeQuota directorySizeQuota;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isMultipleDataLocationsForServicesEnabled")
    protected Boolean isMultipleDataLocationsForServicesEnabled;

    @JsonProperty("marketingNotificationEmails")
    protected List<String> marketingNotificationEmails;

    @JsonProperty("marketingNotificationEmails@nextLink")
    protected String marketingNotificationEmailsNextLink;

    @JsonProperty("onPremisesLastSyncDateTime")
    protected OffsetDateTime onPremisesLastSyncDateTime;

    @JsonProperty("onPremisesSyncEnabled")
    protected Boolean onPremisesSyncEnabled;

    @JsonProperty("postalCode")
    protected String postalCode;

    @JsonProperty("preferredLanguage")
    protected String preferredLanguage;

    @JsonProperty("privacyProfile")
    protected PrivacyProfile privacyProfile;

    @JsonProperty("provisionedPlans")
    protected List<ProvisionedPlan> provisionedPlans;

    @JsonProperty("provisionedPlans@nextLink")
    protected String provisionedPlansNextLink;

    @JsonProperty("securityComplianceNotificationMails")
    protected List<String> securityComplianceNotificationMails;

    @JsonProperty("securityComplianceNotificationMails@nextLink")
    protected String securityComplianceNotificationMailsNextLink;

    @JsonProperty("securityComplianceNotificationPhones")
    protected List<String> securityComplianceNotificationPhones;

    @JsonProperty("securityComplianceNotificationPhones@nextLink")
    protected String securityComplianceNotificationPhonesNextLink;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("street")
    protected String street;

    @JsonProperty("technicalNotificationMails")
    protected List<String> technicalNotificationMails;

    @JsonProperty("technicalNotificationMails@nextLink")
    protected String technicalNotificationMailsNextLink;

    @JsonProperty("verifiedDomains")
    protected List<VerifiedDomain> verifiedDomains;

    @JsonProperty("verifiedDomains@nextLink")
    protected String verifiedDomainsNextLink;

    @JsonProperty("mobileDeviceManagementAuthority")
    protected MdmAuthority mobileDeviceManagementAuthority;

    @JsonProperty("certificateConnectorSetting")
    protected CertificateConnectorSetting certificateConnectorSetting;

    protected Organization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOrganization() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private List<AssignedPlan> assignedPlans;
        private String assignedPlansNextLink;
        private List<String> businessPhones;
        private String businessPhonesNextLink;
        private String city;
        private String country;
        private String countryLetterCode;
        private OffsetDateTime createdDateTime;
        private DirectorySizeQuota directorySizeQuota;
        private String displayName;
        private Boolean isMultipleDataLocationsForServicesEnabled;
        private List<String> marketingNotificationEmails;
        private String marketingNotificationEmailsNextLink;
        private OffsetDateTime onPremisesLastSyncDateTime;
        private Boolean onPremisesSyncEnabled;
        private String postalCode;
        private String preferredLanguage;
        private PrivacyProfile privacyProfile;
        private List<ProvisionedPlan> provisionedPlans;
        private String provisionedPlansNextLink;
        private List<String> securityComplianceNotificationMails;
        private String securityComplianceNotificationMailsNextLink;
        private List<String> securityComplianceNotificationPhones;
        private String securityComplianceNotificationPhonesNextLink;
        private String state;
        private String street;
        private List<String> technicalNotificationMails;
        private String technicalNotificationMailsNextLink;
        private List<VerifiedDomain> verifiedDomains;
        private String verifiedDomainsNextLink;
        private MdmAuthority mobileDeviceManagementAuthority;
        private CertificateConnectorSetting certificateConnectorSetting;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder assignedPlans(List<AssignedPlan> assignedPlans) {
            this.assignedPlans = assignedPlans;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder assignedPlans(AssignedPlan... assignedPlans) {
            return assignedPlans(Arrays.asList(assignedPlans));
        }

        public Builder assignedPlansNextLink(String assignedPlansNextLink) {
            this.assignedPlansNextLink = assignedPlansNextLink;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder businessPhones(List<String> businessPhones) {
            this.businessPhones = businessPhones;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder businessPhones(String... businessPhones) {
            return businessPhones(Arrays.asList(businessPhones));
        }

        public Builder businessPhonesNextLink(String businessPhonesNextLink) {
            this.businessPhonesNextLink = businessPhonesNextLink;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.changedFields = changedFields.add("country");
            return this;
        }

        public Builder countryLetterCode(String countryLetterCode) {
            this.countryLetterCode = countryLetterCode;
            this.changedFields = changedFields.add("countryLetterCode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder directorySizeQuota(DirectorySizeQuota directorySizeQuota) {
            this.directorySizeQuota = directorySizeQuota;
            this.changedFields = changedFields.add("directorySizeQuota");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isMultipleDataLocationsForServicesEnabled(Boolean isMultipleDataLocationsForServicesEnabled) {
            this.isMultipleDataLocationsForServicesEnabled = isMultipleDataLocationsForServicesEnabled;
            this.changedFields = changedFields.add("isMultipleDataLocationsForServicesEnabled");
            return this;
        }

        public Builder marketingNotificationEmails(List<String> marketingNotificationEmails) {
            this.marketingNotificationEmails = marketingNotificationEmails;
            this.changedFields = changedFields.add("marketingNotificationEmails");
            return this;
        }

        public Builder marketingNotificationEmails(String... marketingNotificationEmails) {
            return marketingNotificationEmails(Arrays.asList(marketingNotificationEmails));
        }

        public Builder marketingNotificationEmailsNextLink(String marketingNotificationEmailsNextLink) {
            this.marketingNotificationEmailsNextLink = marketingNotificationEmailsNextLink;
            this.changedFields = changedFields.add("marketingNotificationEmails");
            return this;
        }

        public Builder onPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
            this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            this.changedFields = changedFields.add("onPremisesLastSyncDateTime");
            return this;
        }

        public Builder onPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
            this.onPremisesSyncEnabled = onPremisesSyncEnabled;
            this.changedFields = changedFields.add("onPremisesSyncEnabled");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            this.changedFields = changedFields.add("preferredLanguage");
            return this;
        }

        public Builder privacyProfile(PrivacyProfile privacyProfile) {
            this.privacyProfile = privacyProfile;
            this.changedFields = changedFields.add("privacyProfile");
            return this;
        }

        public Builder provisionedPlans(List<ProvisionedPlan> provisionedPlans) {
            this.provisionedPlans = provisionedPlans;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder provisionedPlans(ProvisionedPlan... provisionedPlans) {
            return provisionedPlans(Arrays.asList(provisionedPlans));
        }

        public Builder provisionedPlansNextLink(String provisionedPlansNextLink) {
            this.provisionedPlansNextLink = provisionedPlansNextLink;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder securityComplianceNotificationMails(List<String> securityComplianceNotificationMails) {
            this.securityComplianceNotificationMails = securityComplianceNotificationMails;
            this.changedFields = changedFields.add("securityComplianceNotificationMails");
            return this;
        }

        public Builder securityComplianceNotificationMails(String... securityComplianceNotificationMails) {
            return securityComplianceNotificationMails(Arrays.asList(securityComplianceNotificationMails));
        }

        public Builder securityComplianceNotificationMailsNextLink(String securityComplianceNotificationMailsNextLink) {
            this.securityComplianceNotificationMailsNextLink = securityComplianceNotificationMailsNextLink;
            this.changedFields = changedFields.add("securityComplianceNotificationMails");
            return this;
        }

        public Builder securityComplianceNotificationPhones(List<String> securityComplianceNotificationPhones) {
            this.securityComplianceNotificationPhones = securityComplianceNotificationPhones;
            this.changedFields = changedFields.add("securityComplianceNotificationPhones");
            return this;
        }

        public Builder securityComplianceNotificationPhones(String... securityComplianceNotificationPhones) {
            return securityComplianceNotificationPhones(Arrays.asList(securityComplianceNotificationPhones));
        }

        public Builder securityComplianceNotificationPhonesNextLink(String securityComplianceNotificationPhonesNextLink) {
            this.securityComplianceNotificationPhonesNextLink = securityComplianceNotificationPhonesNextLink;
            this.changedFields = changedFields.add("securityComplianceNotificationPhones");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            this.changedFields = changedFields.add("street");
            return this;
        }

        public Builder technicalNotificationMails(List<String> technicalNotificationMails) {
            this.technicalNotificationMails = technicalNotificationMails;
            this.changedFields = changedFields.add("technicalNotificationMails");
            return this;
        }

        public Builder technicalNotificationMails(String... technicalNotificationMails) {
            return technicalNotificationMails(Arrays.asList(technicalNotificationMails));
        }

        public Builder technicalNotificationMailsNextLink(String technicalNotificationMailsNextLink) {
            this.technicalNotificationMailsNextLink = technicalNotificationMailsNextLink;
            this.changedFields = changedFields.add("technicalNotificationMails");
            return this;
        }

        public Builder verifiedDomains(List<VerifiedDomain> verifiedDomains) {
            this.verifiedDomains = verifiedDomains;
            this.changedFields = changedFields.add("verifiedDomains");
            return this;
        }

        public Builder verifiedDomains(VerifiedDomain... verifiedDomains) {
            return verifiedDomains(Arrays.asList(verifiedDomains));
        }

        public Builder verifiedDomainsNextLink(String verifiedDomainsNextLink) {
            this.verifiedDomainsNextLink = verifiedDomainsNextLink;
            this.changedFields = changedFields.add("verifiedDomains");
            return this;
        }

        /**
         * <i>“Mobile device management authority.”</i>
         * 
         * @param mobileDeviceManagementAuthority
         *            value of {@code mobileDeviceManagementAuthority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileDeviceManagementAuthority(MdmAuthority mobileDeviceManagementAuthority) {
            this.mobileDeviceManagementAuthority = mobileDeviceManagementAuthority;
            this.changedFields = changedFields.add("mobileDeviceManagementAuthority");
            return this;
        }

        /**
         * <i>“Certificate connector setting.”</i>
         * 
         * @param certificateConnectorSetting
         *            value of {@code certificateConnectorSetting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateConnectorSetting(CertificateConnectorSetting certificateConnectorSetting) {
            this.certificateConnectorSetting = certificateConnectorSetting;
            this.changedFields = changedFields.add("certificateConnectorSetting");
            return this;
        }

        public Organization build() {
            Organization _x = new Organization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.organization";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.assignedPlans = assignedPlans;
            _x.assignedPlansNextLink = assignedPlansNextLink;
            _x.businessPhones = businessPhones;
            _x.businessPhonesNextLink = businessPhonesNextLink;
            _x.city = city;
            _x.country = country;
            _x.countryLetterCode = countryLetterCode;
            _x.createdDateTime = createdDateTime;
            _x.directorySizeQuota = directorySizeQuota;
            _x.displayName = displayName;
            _x.isMultipleDataLocationsForServicesEnabled = isMultipleDataLocationsForServicesEnabled;
            _x.marketingNotificationEmails = marketingNotificationEmails;
            _x.marketingNotificationEmailsNextLink = marketingNotificationEmailsNextLink;
            _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
            _x.postalCode = postalCode;
            _x.preferredLanguage = preferredLanguage;
            _x.privacyProfile = privacyProfile;
            _x.provisionedPlans = provisionedPlans;
            _x.provisionedPlansNextLink = provisionedPlansNextLink;
            _x.securityComplianceNotificationMails = securityComplianceNotificationMails;
            _x.securityComplianceNotificationMailsNextLink = securityComplianceNotificationMailsNextLink;
            _x.securityComplianceNotificationPhones = securityComplianceNotificationPhones;
            _x.securityComplianceNotificationPhonesNextLink = securityComplianceNotificationPhonesNextLink;
            _x.state = state;
            _x.street = street;
            _x.technicalNotificationMails = technicalNotificationMails;
            _x.technicalNotificationMailsNextLink = technicalNotificationMailsNextLink;
            _x.verifiedDomains = verifiedDomains;
            _x.verifiedDomainsNextLink = verifiedDomainsNextLink;
            _x.mobileDeviceManagementAuthority = mobileDeviceManagementAuthority;
            _x.certificateConnectorSetting = certificateConnectorSetting;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans() {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, assignedPlans, Optional.ofNullable(assignedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans(HttpRequestOptions options) {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, assignedPlans, Optional.ofNullable(assignedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones() {
        return new CollectionPage<String>(contextPath, String.class, businessPhones, Optional.ofNullable(businessPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, businessPhones, Optional.ofNullable(businessPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public Organization withCity(String city) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("city");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.city = city;
        return _x;
    }

    @Property(name="country")
    @JsonIgnore
    public Optional<String> getCountry() {
        return Optional.ofNullable(country);
    }

    public Organization withCountry(String country) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("country");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.country = country;
        return _x;
    }

    @Property(name="countryLetterCode")
    @JsonIgnore
    public Optional<String> getCountryLetterCode() {
        return Optional.ofNullable(countryLetterCode);
    }

    public Organization withCountryLetterCode(String countryLetterCode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("countryLetterCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.countryLetterCode = countryLetterCode;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Organization withCreatedDateTime(OffsetDateTime createdDateTime) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="directorySizeQuota")
    @JsonIgnore
    public Optional<DirectorySizeQuota> getDirectorySizeQuota() {
        return Optional.ofNullable(directorySizeQuota);
    }

    public Organization withDirectorySizeQuota(DirectorySizeQuota directorySizeQuota) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("directorySizeQuota");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.directorySizeQuota = directorySizeQuota;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Organization withDisplayName(String displayName) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isMultipleDataLocationsForServicesEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsMultipleDataLocationsForServicesEnabled() {
        return Optional.ofNullable(isMultipleDataLocationsForServicesEnabled);
    }

    public Organization withIsMultipleDataLocationsForServicesEnabled(Boolean isMultipleDataLocationsForServicesEnabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isMultipleDataLocationsForServicesEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.isMultipleDataLocationsForServicesEnabled = isMultipleDataLocationsForServicesEnabled;
        return _x;
    }

    @Property(name="marketingNotificationEmails")
    @JsonIgnore
    public CollectionPage<String> getMarketingNotificationEmails() {
        return new CollectionPage<String>(contextPath, String.class, marketingNotificationEmails, Optional.ofNullable(marketingNotificationEmailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="marketingNotificationEmails")
    @JsonIgnore
    public CollectionPage<String> getMarketingNotificationEmails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, marketingNotificationEmails, Optional.ofNullable(marketingNotificationEmailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="onPremisesLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnPremisesLastSyncDateTime() {
        return Optional.ofNullable(onPremisesLastSyncDateTime);
    }

    public Organization withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("onPremisesLastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return _x;
    }

    @Property(name="onPremisesSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getOnPremisesSyncEnabled() {
        return Optional.ofNullable(onPremisesSyncEnabled);
    }

    public Organization withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSyncEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return _x;
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public Organization withPostalCode(String postalCode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("postalCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.postalCode = postalCode;
        return _x;
    }

    @Property(name="preferredLanguage")
    @JsonIgnore
    public Optional<String> getPreferredLanguage() {
        return Optional.ofNullable(preferredLanguage);
    }

    public Organization withPreferredLanguage(String preferredLanguage) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.preferredLanguage = preferredLanguage;
        return _x;
    }

    @Property(name="privacyProfile")
    @JsonIgnore
    public Optional<PrivacyProfile> getPrivacyProfile() {
        return Optional.ofNullable(privacyProfile);
    }

    public Organization withPrivacyProfile(PrivacyProfile privacyProfile) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("privacyProfile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.privacyProfile = privacyProfile;
        return _x;
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans() {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans(HttpRequestOptions options) {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="securityComplianceNotificationMails")
    @JsonIgnore
    public CollectionPage<String> getSecurityComplianceNotificationMails() {
        return new CollectionPage<String>(contextPath, String.class, securityComplianceNotificationMails, Optional.ofNullable(securityComplianceNotificationMailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="securityComplianceNotificationMails")
    @JsonIgnore
    public CollectionPage<String> getSecurityComplianceNotificationMails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, securityComplianceNotificationMails, Optional.ofNullable(securityComplianceNotificationMailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="securityComplianceNotificationPhones")
    @JsonIgnore
    public CollectionPage<String> getSecurityComplianceNotificationPhones() {
        return new CollectionPage<String>(contextPath, String.class, securityComplianceNotificationPhones, Optional.ofNullable(securityComplianceNotificationPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="securityComplianceNotificationPhones")
    @JsonIgnore
    public CollectionPage<String> getSecurityComplianceNotificationPhones(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, securityComplianceNotificationPhones, Optional.ofNullable(securityComplianceNotificationPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public Organization withState(String state) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.state = state;
        return _x;
    }

    @Property(name="street")
    @JsonIgnore
    public Optional<String> getStreet() {
        return Optional.ofNullable(street);
    }

    public Organization withStreet(String street) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("street");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.street = street;
        return _x;
    }

    @Property(name="technicalNotificationMails")
    @JsonIgnore
    public CollectionPage<String> getTechnicalNotificationMails() {
        return new CollectionPage<String>(contextPath, String.class, technicalNotificationMails, Optional.ofNullable(technicalNotificationMailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="technicalNotificationMails")
    @JsonIgnore
    public CollectionPage<String> getTechnicalNotificationMails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, technicalNotificationMails, Optional.ofNullable(technicalNotificationMailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="verifiedDomains")
    @JsonIgnore
    public CollectionPage<VerifiedDomain> getVerifiedDomains() {
        return new CollectionPage<VerifiedDomain>(contextPath, VerifiedDomain.class, verifiedDomains, Optional.ofNullable(verifiedDomainsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="verifiedDomains")
    @JsonIgnore
    public CollectionPage<VerifiedDomain> getVerifiedDomains(HttpRequestOptions options) {
        return new CollectionPage<VerifiedDomain>(contextPath, VerifiedDomain.class, verifiedDomains, Optional.ofNullable(verifiedDomainsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Mobile device management authority.”</i>
     * 
     * @return property mobileDeviceManagementAuthority
     */
    @Property(name="mobileDeviceManagementAuthority")
    @JsonIgnore
    public Optional<MdmAuthority> getMobileDeviceManagementAuthority() {
        return Optional.ofNullable(mobileDeviceManagementAuthority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileDeviceManagementAuthority} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Mobile device management authority.”</i>
     * 
     * @param mobileDeviceManagementAuthority
     *            new value of {@code mobileDeviceManagementAuthority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileDeviceManagementAuthority} field changed
     */
    public Organization withMobileDeviceManagementAuthority(MdmAuthority mobileDeviceManagementAuthority) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("mobileDeviceManagementAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.mobileDeviceManagementAuthority = mobileDeviceManagementAuthority;
        return _x;
    }

    /**
     * <i>“Certificate connector setting.”</i>
     * 
     * @return property certificateConnectorSetting
     */
    @Property(name="certificateConnectorSetting")
    @JsonIgnore
    public Optional<CertificateConnectorSetting> getCertificateConnectorSetting() {
        return Optional.ofNullable(certificateConnectorSetting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateConnectorSetting} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate connector setting.”</i>
     * 
     * @param certificateConnectorSetting
     *            new value of {@code certificateConnectorSetting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateConnectorSetting} field changed
     */
    public Organization withCertificateConnectorSetting(CertificateConnectorSetting certificateConnectorSetting) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("certificateConnectorSetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organization");
        _x.certificateConnectorSetting = certificateConnectorSetting;
        return _x;
    }

    @NavigationProperty(name="brandings")
    @JsonIgnore
    public OrganizationalBrandingCollectionRequest getBrandings() {
        return new OrganizationalBrandingCollectionRequest(
                        contextPath.addSegment("brandings"));
    }

    @NavigationProperty(name="certificateBasedAuthConfiguration")
    @JsonIgnore
    public CertificateBasedAuthConfigurationCollectionRequest getCertificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfigurationCollectionRequest(
                        contextPath.addSegment("certificateBasedAuthConfiguration"));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public OrganizationSettingsRequest getSettings() {
        return new OrganizationSettingsRequest(contextPath.addSegment("settings"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Organization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Organization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Organization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Organization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Organization _copy() {
        Organization _x = new Organization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.assignedPlans = assignedPlans;
        _x.businessPhones = businessPhones;
        _x.city = city;
        _x.country = country;
        _x.countryLetterCode = countryLetterCode;
        _x.createdDateTime = createdDateTime;
        _x.directorySizeQuota = directorySizeQuota;
        _x.displayName = displayName;
        _x.isMultipleDataLocationsForServicesEnabled = isMultipleDataLocationsForServicesEnabled;
        _x.marketingNotificationEmails = marketingNotificationEmails;
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        _x.postalCode = postalCode;
        _x.preferredLanguage = preferredLanguage;
        _x.privacyProfile = privacyProfile;
        _x.provisionedPlans = provisionedPlans;
        _x.securityComplianceNotificationMails = securityComplianceNotificationMails;
        _x.securityComplianceNotificationPhones = securityComplianceNotificationPhones;
        _x.state = state;
        _x.street = street;
        _x.technicalNotificationMails = technicalNotificationMails;
        _x.verifiedDomains = verifiedDomains;
        _x.mobileDeviceManagementAuthority = mobileDeviceManagementAuthority;
        _x.certificateConnectorSetting = certificateConnectorSetting;
        return _x;
    }

    @Action(name = "setMobileDeviceManagementAuthority")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Integer> setMobileDeviceManagementAuthority() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setMobileDeviceManagementAuthority"), Integer.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Organization[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("assignedPlans=");
        b.append(this.assignedPlans);
        b.append(", ");
        b.append("businessPhones=");
        b.append(this.businessPhones);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("country=");
        b.append(this.country);
        b.append(", ");
        b.append("countryLetterCode=");
        b.append(this.countryLetterCode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("directorySizeQuota=");
        b.append(this.directorySizeQuota);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isMultipleDataLocationsForServicesEnabled=");
        b.append(this.isMultipleDataLocationsForServicesEnabled);
        b.append(", ");
        b.append("marketingNotificationEmails=");
        b.append(this.marketingNotificationEmails);
        b.append(", ");
        b.append("onPremisesLastSyncDateTime=");
        b.append(this.onPremisesLastSyncDateTime);
        b.append(", ");
        b.append("onPremisesSyncEnabled=");
        b.append(this.onPremisesSyncEnabled);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append(", ");
        b.append("preferredLanguage=");
        b.append(this.preferredLanguage);
        b.append(", ");
        b.append("privacyProfile=");
        b.append(this.privacyProfile);
        b.append(", ");
        b.append("provisionedPlans=");
        b.append(this.provisionedPlans);
        b.append(", ");
        b.append("securityComplianceNotificationMails=");
        b.append(this.securityComplianceNotificationMails);
        b.append(", ");
        b.append("securityComplianceNotificationPhones=");
        b.append(this.securityComplianceNotificationPhones);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("street=");
        b.append(this.street);
        b.append(", ");
        b.append("technicalNotificationMails=");
        b.append(this.technicalNotificationMails);
        b.append(", ");
        b.append("verifiedDomains=");
        b.append(this.verifiedDomains);
        b.append(", ");
        b.append("mobileDeviceManagementAuthority=");
        b.append(this.mobileDeviceManagementAuthority);
        b.append(", ");
        b.append("certificateConnectorSetting=");
        b.append(this.certificateConnectorSetting);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
