package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "openShiftId"})
@JsonInclude(Include.NON_NULL)
public class OpenShiftChangeRequest extends ScheduleChangeRequest implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.openShiftChangeRequest";
    }

    @JsonProperty("openShiftId")
    protected String openShiftId;

    protected OpenShiftChangeRequest() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="openShiftId")
    @JsonIgnore
    public Optional<String> getOpenShiftId() {
        return Optional.ofNullable(openShiftId);
    }

    public OpenShiftChangeRequest withOpenShiftId(String openShiftId) {
        OpenShiftChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("openShiftId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openShiftChangeRequest");
        _x.openShiftId = openShiftId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OpenShiftChangeRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OpenShiftChangeRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OpenShiftChangeRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OpenShiftChangeRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OpenShiftChangeRequest _copy() {
        OpenShiftChangeRequest _x = new OpenShiftChangeRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.assignedTo = assignedTo;
        _x.state = state;
        _x.senderMessage = senderMessage;
        _x.senderDateTime = senderDateTime;
        _x.managerActionMessage = managerActionMessage;
        _x.managerActionDateTime = managerActionDateTime;
        _x.senderUserId = senderUserId;
        _x.managerUserId = managerUserId;
        _x.openShiftId = openShiftId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OpenShiftChangeRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("senderMessage=");
        b.append(this.senderMessage);
        b.append(", ");
        b.append("senderDateTime=");
        b.append(this.senderDateTime);
        b.append(", ");
        b.append("managerActionMessage=");
        b.append(this.managerActionMessage);
        b.append(", ");
        b.append("managerActionDateTime=");
        b.append(this.managerActionDateTime);
        b.append(", ");
        b.append("senderUserId=");
        b.append(this.senderUserId);
        b.append(", ");
        b.append("managerUserId=");
        b.append(this.managerUserId);
        b.append(", ");
        b.append("openShiftId=");
        b.append(this.openShiftId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
