package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.ClaimsMapping;
import odata.msgraph.client.beta.enums.OpenIdConnectResponseMode;
import odata.msgraph.client.beta.enums.OpenIdConnectResponseTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "scope", 
    "metadataUrl", 
    "domainHint", 
    "responseType", 
    "responseMode", 
    "claimsMapping"})
@JsonInclude(Include.NON_NULL)
public class OpenIdConnectProvider extends IdentityProvider implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.openIdConnectProvider";
    }

    @JsonProperty("scope")
    protected String scope;

    @JsonProperty("metadataUrl")
    protected String metadataUrl;

    @JsonProperty("domainHint")
    protected String domainHint;

    @JsonProperty("responseType")
    protected OpenIdConnectResponseTypes responseType;

    @JsonProperty("responseMode")
    protected OpenIdConnectResponseMode responseMode;

    @JsonProperty("claimsMapping")
    protected ClaimsMapping claimsMapping;

    protected OpenIdConnectProvider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOpenIdConnectProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String type;
        private String name;
        private String clientId;
        private String clientSecret;
        private String scope;
        private String metadataUrl;
        private String domainHint;
        private OpenIdConnectResponseTypes responseType;
        private OpenIdConnectResponseMode responseMode;
        private ClaimsMapping claimsMapping;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder metadataUrl(String metadataUrl) {
            this.metadataUrl = metadataUrl;
            this.changedFields = changedFields.add("metadataUrl");
            return this;
        }

        public Builder domainHint(String domainHint) {
            this.domainHint = domainHint;
            this.changedFields = changedFields.add("domainHint");
            return this;
        }

        public Builder responseType(OpenIdConnectResponseTypes responseType) {
            this.responseType = responseType;
            this.changedFields = changedFields.add("responseType");
            return this;
        }

        public Builder responseMode(OpenIdConnectResponseMode responseMode) {
            this.responseMode = responseMode;
            this.changedFields = changedFields.add("responseMode");
            return this;
        }

        public Builder claimsMapping(ClaimsMapping claimsMapping) {
            this.claimsMapping = claimsMapping;
            this.changedFields = changedFields.add("claimsMapping");
            return this;
        }

        public OpenIdConnectProvider build() {
            OpenIdConnectProvider _x = new OpenIdConnectProvider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.openIdConnectProvider";
            _x.id = id;
            _x.type = type;
            _x.name = name;
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            _x.scope = scope;
            _x.metadataUrl = metadataUrl;
            _x.domainHint = domainHint;
            _x.responseType = responseType;
            _x.responseMode = responseMode;
            _x.claimsMapping = claimsMapping;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<String> getScope() {
        return Optional.ofNullable(scope);
    }

    public OpenIdConnectProvider withScope(String scope) {
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openIdConnectProvider");
        _x.scope = scope;
        return _x;
    }

    @Property(name="metadataUrl")
    @JsonIgnore
    public Optional<String> getMetadataUrl() {
        return Optional.ofNullable(metadataUrl);
    }

    public OpenIdConnectProvider withMetadataUrl(String metadataUrl) {
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = changedFields.add("metadataUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openIdConnectProvider");
        _x.metadataUrl = metadataUrl;
        return _x;
    }

    @Property(name="domainHint")
    @JsonIgnore
    public Optional<String> getDomainHint() {
        return Optional.ofNullable(domainHint);
    }

    public OpenIdConnectProvider withDomainHint(String domainHint) {
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = changedFields.add("domainHint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openIdConnectProvider");
        _x.domainHint = domainHint;
        return _x;
    }

    @Property(name="responseType")
    @JsonIgnore
    public Optional<OpenIdConnectResponseTypes> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    public OpenIdConnectProvider withResponseType(OpenIdConnectResponseTypes responseType) {
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = changedFields.add("responseType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openIdConnectProvider");
        _x.responseType = responseType;
        return _x;
    }

    @Property(name="responseMode")
    @JsonIgnore
    public Optional<OpenIdConnectResponseMode> getResponseMode() {
        return Optional.ofNullable(responseMode);
    }

    public OpenIdConnectProvider withResponseMode(OpenIdConnectResponseMode responseMode) {
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = changedFields.add("responseMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openIdConnectProvider");
        _x.responseMode = responseMode;
        return _x;
    }

    @Property(name="claimsMapping")
    @JsonIgnore
    public Optional<ClaimsMapping> getClaimsMapping() {
        return Optional.ofNullable(claimsMapping);
    }

    public OpenIdConnectProvider withClaimsMapping(ClaimsMapping claimsMapping) {
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = changedFields.add("claimsMapping");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.openIdConnectProvider");
        _x.claimsMapping = claimsMapping;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OpenIdConnectProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OpenIdConnectProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OpenIdConnectProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OpenIdConnectProvider _copy() {
        OpenIdConnectProvider _x = new OpenIdConnectProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.type = type;
        _x.name = name;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        _x.scope = scope;
        _x.metadataUrl = metadataUrl;
        _x.domainHint = domainHint;
        _x.responseType = responseType;
        _x.responseMode = responseMode;
        _x.claimsMapping = claimsMapping;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OpenIdConnectProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("metadataUrl=");
        b.append(this.metadataUrl);
        b.append(", ");
        b.append("domainHint=");
        b.append(this.domainHint);
        b.append(", ");
        b.append("responseType=");
        b.append(this.responseType);
        b.append(", ");
        b.append("responseMode=");
        b.append(this.responseMode);
        b.append(", ");
        b.append("claimsMapping=");
        b.append(this.claimsMapping);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
