package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AudioConferencing;
import odata.msgraph.client.beta.complex.ChatInfo;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.MeetingParticipants;
import odata.msgraph.client.beta.enums.AccessLevel;
import odata.msgraph.client.beta.enums.MeetingCapabilities;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "creationDateTime", 
    "startDateTime", 
    "endDateTime", 
    "canceledDateTime", 
    "expirationDateTime", 
    "entryExitAnnouncement", 
    "joinUrl", 
    "subject", 
    "isCancelled", 
    "participants", 
    "isBroadcast", 
    "accessLevel", 
    "capabilities", 
    "audioConferencing", 
    "chatInfo", 
    "videoTeleconferenceId", 
    "externalId", 
    "joinInformation"})
@JsonInclude(Include.NON_NULL)
public class OnlineMeeting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onlineMeeting";
    }

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("canceledDateTime")
    protected OffsetDateTime canceledDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("entryExitAnnouncement")
    protected Boolean entryExitAnnouncement;

    @JsonProperty("joinUrl")
    protected String joinUrl;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("isCancelled")
    protected Boolean isCancelled;

    @JsonProperty("participants")
    protected MeetingParticipants participants;

    @JsonProperty("isBroadcast")
    protected Boolean isBroadcast;

    @JsonProperty("accessLevel")
    protected AccessLevel accessLevel;

    @JsonProperty("capabilities")
    protected List<MeetingCapabilities> capabilities;

    @JsonProperty("capabilities@nextLink")
    protected String capabilitiesNextLink;

    @JsonProperty("audioConferencing")
    protected AudioConferencing audioConferencing;

    @JsonProperty("chatInfo")
    protected ChatInfo chatInfo;

    @JsonProperty("videoTeleconferenceId")
    protected String videoTeleconferenceId;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("joinInformation")
    protected ItemBody joinInformation;

    protected OnlineMeeting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnlineMeeting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime creationDateTime;
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private OffsetDateTime canceledDateTime;
        private OffsetDateTime expirationDateTime;
        private Boolean entryExitAnnouncement;
        private String joinUrl;
        private String subject;
        private Boolean isCancelled;
        private MeetingParticipants participants;
        private Boolean isBroadcast;
        private AccessLevel accessLevel;
        private List<MeetingCapabilities> capabilities;
        private String capabilitiesNextLink;
        private AudioConferencing audioConferencing;
        private ChatInfo chatInfo;
        private String videoTeleconferenceId;
        private String externalId;
        private ItemBody joinInformation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder canceledDateTime(OffsetDateTime canceledDateTime) {
            this.canceledDateTime = canceledDateTime;
            this.changedFields = changedFields.add("canceledDateTime");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder entryExitAnnouncement(Boolean entryExitAnnouncement) {
            this.entryExitAnnouncement = entryExitAnnouncement;
            this.changedFields = changedFields.add("entryExitAnnouncement");
            return this;
        }

        public Builder joinUrl(String joinUrl) {
            this.joinUrl = joinUrl;
            this.changedFields = changedFields.add("joinUrl");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder isCancelled(Boolean isCancelled) {
            this.isCancelled = isCancelled;
            this.changedFields = changedFields.add("isCancelled");
            return this;
        }

        public Builder participants(MeetingParticipants participants) {
            this.participants = participants;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public Builder isBroadcast(Boolean isBroadcast) {
            this.isBroadcast = isBroadcast;
            this.changedFields = changedFields.add("isBroadcast");
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            this.changedFields = changedFields.add("accessLevel");
            return this;
        }

        public Builder capabilities(List<MeetingCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder capabilities(MeetingCapabilities... capabilities) {
            return capabilities(Arrays.asList(capabilities));
        }

        public Builder capabilitiesNextLink(String capabilitiesNextLink) {
            this.capabilitiesNextLink = capabilitiesNextLink;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder audioConferencing(AudioConferencing audioConferencing) {
            this.audioConferencing = audioConferencing;
            this.changedFields = changedFields.add("audioConferencing");
            return this;
        }

        public Builder chatInfo(ChatInfo chatInfo) {
            this.chatInfo = chatInfo;
            this.changedFields = changedFields.add("chatInfo");
            return this;
        }

        public Builder videoTeleconferenceId(String videoTeleconferenceId) {
            this.videoTeleconferenceId = videoTeleconferenceId;
            this.changedFields = changedFields.add("videoTeleconferenceId");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder joinInformation(ItemBody joinInformation) {
            this.joinInformation = joinInformation;
            this.changedFields = changedFields.add("joinInformation");
            return this;
        }

        public OnlineMeeting build() {
            OnlineMeeting _x = new OnlineMeeting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onlineMeeting";
            _x.id = id;
            _x.creationDateTime = creationDateTime;
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.canceledDateTime = canceledDateTime;
            _x.expirationDateTime = expirationDateTime;
            _x.entryExitAnnouncement = entryExitAnnouncement;
            _x.joinUrl = joinUrl;
            _x.subject = subject;
            _x.isCancelled = isCancelled;
            _x.participants = participants;
            _x.isBroadcast = isBroadcast;
            _x.accessLevel = accessLevel;
            _x.capabilities = capabilities;
            _x.capabilitiesNextLink = capabilitiesNextLink;
            _x.audioConferencing = audioConferencing;
            _x.chatInfo = chatInfo;
            _x.videoTeleconferenceId = videoTeleconferenceId;
            _x.externalId = externalId;
            _x.joinInformation = joinInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    public OnlineMeeting withCreationDateTime(OffsetDateTime creationDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("creationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public OnlineMeeting withStartDateTime(OffsetDateTime startDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public OnlineMeeting withEndDateTime(OffsetDateTime endDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="canceledDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCanceledDateTime() {
        return Optional.ofNullable(canceledDateTime);
    }

    public OnlineMeeting withCanceledDateTime(OffsetDateTime canceledDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("canceledDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.canceledDateTime = canceledDateTime;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public OnlineMeeting withExpirationDateTime(OffsetDateTime expirationDateTime) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="entryExitAnnouncement")
    @JsonIgnore
    public Optional<Boolean> getEntryExitAnnouncement() {
        return Optional.ofNullable(entryExitAnnouncement);
    }

    public OnlineMeeting withEntryExitAnnouncement(Boolean entryExitAnnouncement) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("entryExitAnnouncement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.entryExitAnnouncement = entryExitAnnouncement;
        return _x;
    }

    @Property(name="joinUrl")
    @JsonIgnore
    public Optional<String> getJoinUrl() {
        return Optional.ofNullable(joinUrl);
    }

    public OnlineMeeting withJoinUrl(String joinUrl) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("joinUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.joinUrl = joinUrl;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public OnlineMeeting withSubject(String subject) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.subject = subject;
        return _x;
    }

    @Property(name="isCancelled")
    @JsonIgnore
    public Optional<Boolean> getIsCancelled() {
        return Optional.ofNullable(isCancelled);
    }

    public OnlineMeeting withIsCancelled(Boolean isCancelled) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("isCancelled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.isCancelled = isCancelled;
        return _x;
    }

    @Property(name="participants")
    @JsonIgnore
    public Optional<MeetingParticipants> getParticipants() {
        return Optional.ofNullable(participants);
    }

    public OnlineMeeting withParticipants(MeetingParticipants participants) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("participants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.participants = participants;
        return _x;
    }

    @Property(name="isBroadcast")
    @JsonIgnore
    public Optional<Boolean> getIsBroadcast() {
        return Optional.ofNullable(isBroadcast);
    }

    public OnlineMeeting withIsBroadcast(Boolean isBroadcast) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("isBroadcast");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.isBroadcast = isBroadcast;
        return _x;
    }

    @Property(name="accessLevel")
    @JsonIgnore
    public Optional<AccessLevel> getAccessLevel() {
        return Optional.ofNullable(accessLevel);
    }

    public OnlineMeeting withAccessLevel(AccessLevel accessLevel) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("accessLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.accessLevel = accessLevel;
        return _x;
    }

    @Property(name="capabilities")
    @JsonIgnore
    public CollectionPage<MeetingCapabilities> getCapabilities() {
        return new CollectionPage<MeetingCapabilities>(contextPath, MeetingCapabilities.class, capabilities, Optional.ofNullable(capabilitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="capabilities")
    @JsonIgnore
    public CollectionPage<MeetingCapabilities> getCapabilities(HttpRequestOptions options) {
        return new CollectionPage<MeetingCapabilities>(contextPath, MeetingCapabilities.class, capabilities, Optional.ofNullable(capabilitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="audioConferencing")
    @JsonIgnore
    public Optional<AudioConferencing> getAudioConferencing() {
        return Optional.ofNullable(audioConferencing);
    }

    public OnlineMeeting withAudioConferencing(AudioConferencing audioConferencing) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("audioConferencing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.audioConferencing = audioConferencing;
        return _x;
    }

    @Property(name="chatInfo")
    @JsonIgnore
    public Optional<ChatInfo> getChatInfo() {
        return Optional.ofNullable(chatInfo);
    }

    public OnlineMeeting withChatInfo(ChatInfo chatInfo) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("chatInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.chatInfo = chatInfo;
        return _x;
    }

    @Property(name="videoTeleconferenceId")
    @JsonIgnore
    public Optional<String> getVideoTeleconferenceId() {
        return Optional.ofNullable(videoTeleconferenceId);
    }

    public OnlineMeeting withVideoTeleconferenceId(String videoTeleconferenceId) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("videoTeleconferenceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.videoTeleconferenceId = videoTeleconferenceId;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public OnlineMeeting withExternalId(String externalId) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="joinInformation")
    @JsonIgnore
    public Optional<ItemBody> getJoinInformation() {
        return Optional.ofNullable(joinInformation);
    }

    public OnlineMeeting withJoinInformation(ItemBody joinInformation) {
        OnlineMeeting _x = _copy();
        _x.changedFields = changedFields.add("joinInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeeting");
        _x.joinInformation = joinInformation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnlineMeeting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnlineMeeting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnlineMeeting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnlineMeeting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnlineMeeting _copy() {
        OnlineMeeting _x = new OnlineMeeting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.canceledDateTime = canceledDateTime;
        _x.expirationDateTime = expirationDateTime;
        _x.entryExitAnnouncement = entryExitAnnouncement;
        _x.joinUrl = joinUrl;
        _x.subject = subject;
        _x.isCancelled = isCancelled;
        _x.participants = participants;
        _x.isBroadcast = isBroadcast;
        _x.accessLevel = accessLevel;
        _x.capabilities = capabilities;
        _x.audioConferencing = audioConferencing;
        _x.chatInfo = chatInfo;
        _x.videoTeleconferenceId = videoTeleconferenceId;
        _x.externalId = externalId;
        _x.joinInformation = joinInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnlineMeeting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("canceledDateTime=");
        b.append(this.canceledDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("entryExitAnnouncement=");
        b.append(this.entryExitAnnouncement);
        b.append(", ");
        b.append("joinUrl=");
        b.append(this.joinUrl);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("isCancelled=");
        b.append(this.isCancelled);
        b.append(", ");
        b.append("participants=");
        b.append(this.participants);
        b.append(", ");
        b.append("isBroadcast=");
        b.append(this.isBroadcast);
        b.append(", ");
        b.append("accessLevel=");
        b.append(this.accessLevel);
        b.append(", ");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("audioConferencing=");
        b.append(this.audioConferencing);
        b.append(", ");
        b.append("chatInfo=");
        b.append(this.chatInfo);
        b.append(", ");
        b.append("videoTeleconferenceId=");
        b.append(this.videoTeleconferenceId);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("joinInformation=");
        b.append(this.joinInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
