package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "contentUrl"})
@JsonInclude(Include.NON_NULL)
public class OnenoteResource extends OnenoteEntityBaseModel implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenoteResource";
    }

    @JsonProperty("content")
    protected String content;

    @JsonProperty("contentUrl")
    protected String contentUrl;

    protected OnenoteResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnenoteResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String self;
        private String content;
        private String contentUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.changedFields = changedFields.add("self");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.changedFields = changedFields.add("contentUrl");
            return this;
        }

        public OnenoteResource build() {
            OnenoteResource _x = new OnenoteResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onenoteResource";
            _x.id = id;
            _x.self = self;
            _x.content = content;
            _x.contentUrl = contentUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<StreamProvider> getContent() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "content", content);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> putContent() {
        return putContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> putChunkedContent() {
        return putContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> putContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content");
    }

    @Property(name="contentUrl")
    @JsonIgnore
    public Optional<String> getContentUrl() {
        return Optional.ofNullable(contentUrl);
    }

    public OnenoteResource withContentUrl(String contentUrl) {
        OnenoteResource _x = _copy();
        _x.changedFields = changedFields.add("contentUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteResource");
        _x.contentUrl = contentUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnenoteResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnenoteResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnenoteResource _copy() {
        OnenoteResource _x = new OnenoteResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.self = self;
        _x.content = content;
        _x.contentUrl = contentUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenoteResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("self=");
        b.append(this.self);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("contentUrl=");
        b.append(this.contentUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
