package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime"})
@JsonInclude(Include.NON_NULL)
public class OnenoteEntitySchemaObjectModel extends OnenoteEntityBaseModel implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenoteEntitySchemaObjectModel";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    protected OnenoteEntitySchemaObjectModel() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public OnenoteEntitySchemaObjectModel withCreatedDateTime(OffsetDateTime createdDateTime) {
        OnenoteEntitySchemaObjectModel _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenoteEntitySchemaObjectModel");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteEntitySchemaObjectModel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnenoteEntitySchemaObjectModel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnenoteEntitySchemaObjectModel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnenoteEntitySchemaObjectModel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnenoteEntitySchemaObjectModel _copy() {
        OnenoteEntitySchemaObjectModel _x = new OnenoteEntitySchemaObjectModel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.self = self;
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenoteEntitySchemaObjectModel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("self=");
        b.append(this.self);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
