package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "siteUrl", 
    "ownerDisplayName", 
    "ownerPrincipalName", 
    "isDeleted", 
    "lastActivityDate", 
    "fileCount", 
    "activeFileCount", 
    "storageUsedInBytes", 
    "storageAllocatedInBytes", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class OneDriveUsageAccountDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.oneDriveUsageAccountDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("siteUrl")
    protected String siteUrl;

    @JsonProperty("ownerDisplayName")
    protected String ownerDisplayName;

    @JsonProperty("ownerPrincipalName")
    protected String ownerPrincipalName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("fileCount")
    protected Long fileCount;

    @JsonProperty("activeFileCount")
    protected Long activeFileCount;

    @JsonProperty("storageUsedInBytes")
    protected Long storageUsedInBytes;

    @JsonProperty("storageAllocatedInBytes")
    protected Long storageAllocatedInBytes;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected OneDriveUsageAccountDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOneDriveUsageAccountDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String siteUrl;
        private String ownerDisplayName;
        private String ownerPrincipalName;
        private Boolean isDeleted;
        private LocalDate lastActivityDate;
        private Long fileCount;
        private Long activeFileCount;
        private Long storageUsedInBytes;
        private Long storageAllocatedInBytes;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
            this.changedFields = changedFields.add("siteUrl");
            return this;
        }

        public Builder ownerDisplayName(String ownerDisplayName) {
            this.ownerDisplayName = ownerDisplayName;
            this.changedFields = changedFields.add("ownerDisplayName");
            return this;
        }

        public Builder ownerPrincipalName(String ownerPrincipalName) {
            this.ownerPrincipalName = ownerPrincipalName;
            this.changedFields = changedFields.add("ownerPrincipalName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder fileCount(Long fileCount) {
            this.fileCount = fileCount;
            this.changedFields = changedFields.add("fileCount");
            return this;
        }

        public Builder activeFileCount(Long activeFileCount) {
            this.activeFileCount = activeFileCount;
            this.changedFields = changedFields.add("activeFileCount");
            return this;
        }

        public Builder storageUsedInBytes(Long storageUsedInBytes) {
            this.storageUsedInBytes = storageUsedInBytes;
            this.changedFields = changedFields.add("storageUsedInBytes");
            return this;
        }

        public Builder storageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
            this.changedFields = changedFields.add("storageAllocatedInBytes");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public OneDriveUsageAccountDetail build() {
            OneDriveUsageAccountDetail _x = new OneDriveUsageAccountDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.oneDriveUsageAccountDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.siteUrl = siteUrl;
            _x.ownerDisplayName = ownerDisplayName;
            _x.ownerPrincipalName = ownerPrincipalName;
            _x.isDeleted = isDeleted;
            _x.lastActivityDate = lastActivityDate;
            _x.fileCount = fileCount;
            _x.activeFileCount = activeFileCount;
            _x.storageUsedInBytes = storageUsedInBytes;
            _x.storageAllocatedInBytes = storageAllocatedInBytes;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public OneDriveUsageAccountDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="siteUrl")
    @JsonIgnore
    public Optional<String> getSiteUrl() {
        return Optional.ofNullable(siteUrl);
    }

    public OneDriveUsageAccountDetail withSiteUrl(String siteUrl) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("siteUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.siteUrl = siteUrl;
        return _x;
    }

    @Property(name="ownerDisplayName")
    @JsonIgnore
    public Optional<String> getOwnerDisplayName() {
        return Optional.ofNullable(ownerDisplayName);
    }

    public OneDriveUsageAccountDetail withOwnerDisplayName(String ownerDisplayName) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("ownerDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.ownerDisplayName = ownerDisplayName;
        return _x;
    }

    @Property(name="ownerPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerPrincipalName() {
        return Optional.ofNullable(ownerPrincipalName);
    }

    public OneDriveUsageAccountDetail withOwnerPrincipalName(String ownerPrincipalName) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("ownerPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.ownerPrincipalName = ownerPrincipalName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public OneDriveUsageAccountDetail withIsDeleted(Boolean isDeleted) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public OneDriveUsageAccountDetail withLastActivityDate(LocalDate lastActivityDate) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="fileCount")
    @JsonIgnore
    public Optional<Long> getFileCount() {
        return Optional.ofNullable(fileCount);
    }

    public OneDriveUsageAccountDetail withFileCount(Long fileCount) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("fileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.fileCount = fileCount;
        return _x;
    }

    @Property(name="activeFileCount")
    @JsonIgnore
    public Optional<Long> getActiveFileCount() {
        return Optional.ofNullable(activeFileCount);
    }

    public OneDriveUsageAccountDetail withActiveFileCount(Long activeFileCount) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("activeFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.activeFileCount = activeFileCount;
        return _x;
    }

    @Property(name="storageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getStorageUsedInBytes() {
        return Optional.ofNullable(storageUsedInBytes);
    }

    public OneDriveUsageAccountDetail withStorageUsedInBytes(Long storageUsedInBytes) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("storageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.storageUsedInBytes = storageUsedInBytes;
        return _x;
    }

    @Property(name="storageAllocatedInBytes")
    @JsonIgnore
    public Optional<Long> getStorageAllocatedInBytes() {
        return Optional.ofNullable(storageAllocatedInBytes);
    }

    public OneDriveUsageAccountDetail withStorageAllocatedInBytes(Long storageAllocatedInBytes) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("storageAllocatedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.storageAllocatedInBytes = storageAllocatedInBytes;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public OneDriveUsageAccountDetail withReportPeriod(String reportPeriod) {
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oneDriveUsageAccountDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OneDriveUsageAccountDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OneDriveUsageAccountDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OneDriveUsageAccountDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OneDriveUsageAccountDetail _copy() {
        OneDriveUsageAccountDetail _x = new OneDriveUsageAccountDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.siteUrl = siteUrl;
        _x.ownerDisplayName = ownerDisplayName;
        _x.ownerPrincipalName = ownerPrincipalName;
        _x.isDeleted = isDeleted;
        _x.lastActivityDate = lastActivityDate;
        _x.fileCount = fileCount;
        _x.activeFileCount = activeFileCount;
        _x.storageUsedInBytes = storageUsedInBytes;
        _x.storageAllocatedInBytes = storageAllocatedInBytes;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OneDriveUsageAccountDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("siteUrl=");
        b.append(this.siteUrl);
        b.append(", ");
        b.append("ownerDisplayName=");
        b.append(this.ownerDisplayName);
        b.append(", ");
        b.append("ownerPrincipalName=");
        b.append(this.ownerPrincipalName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("fileCount=");
        b.append(this.fileCount);
        b.append(", ");
        b.append("activeFileCount=");
        b.append(this.activeFileCount);
        b.append(", ");
        b.append("storageUsedInBytes=");
        b.append(this.storageUsedInBytes);
        b.append(", ");
        b.append("storageAllocatedInBytes=");
        b.append(this.storageAllocatedInBytes);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
