package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.HybridAgentUpdaterConfiguration;
import odata.msgraph.client.beta.entity.collection.request.ConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectorGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PublishedResourceCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "isEnabled", 
    "hybridAgentUpdaterConfiguration"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesPublishingProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesPublishingProfile";
    }

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("hybridAgentUpdaterConfiguration")
    protected HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration;

    protected OnPremisesPublishingProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnPremisesPublishingProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isEnabled;
        private HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder hybridAgentUpdaterConfiguration(HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration) {
            this.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
            this.changedFields = changedFields.add("hybridAgentUpdaterConfiguration");
            return this;
        }

        public OnPremisesPublishingProfile build() {
            OnPremisesPublishingProfile _x = new OnPremisesPublishingProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onPremisesPublishingProfile";
            _x.id = id;
            _x.isEnabled = isEnabled;
            _x.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public OnPremisesPublishingProfile withIsEnabled(Boolean isEnabled) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="hybridAgentUpdaterConfiguration")
    @JsonIgnore
    public Optional<HybridAgentUpdaterConfiguration> getHybridAgentUpdaterConfiguration() {
        return Optional.ofNullable(hybridAgentUpdaterConfiguration);
    }

    public OnPremisesPublishingProfile withHybridAgentUpdaterConfiguration(HybridAgentUpdaterConfiguration hybridAgentUpdaterConfiguration) {
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = changedFields.add("hybridAgentUpdaterConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingProfile");
        _x.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
        return _x;
    }

    @NavigationProperty(name="agents")
    @JsonIgnore
    public OnPremisesAgentCollectionRequest getAgents() {
        return new OnPremisesAgentCollectionRequest(
                        contextPath.addSegment("agents"));
    }

    @NavigationProperty(name="agentGroups")
    @JsonIgnore
    public OnPremisesAgentGroupCollectionRequest getAgentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"));
    }

    @NavigationProperty(name="publishedResources")
    @JsonIgnore
    public PublishedResourceCollectionRequest getPublishedResources() {
        return new PublishedResourceCollectionRequest(
                        contextPath.addSegment("publishedResources"));
    }

    @NavigationProperty(name="connectors")
    @JsonIgnore
    public ConnectorCollectionRequest getConnectors() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("connectors"));
    }

    @NavigationProperty(name="connectorGroups")
    @JsonIgnore
    public ConnectorGroupCollectionRequest getConnectorGroups() {
        return new ConnectorGroupCollectionRequest(
                        contextPath.addSegment("connectorGroups"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesPublishingProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesPublishingProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnPremisesPublishingProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnPremisesPublishingProfile _copy() {
        OnPremisesPublishingProfile _x = new OnPremisesPublishingProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.isEnabled = isEnabled;
        _x.hybridAgentUpdaterConfiguration = hybridAgentUpdaterConfiguration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesPublishingProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("hybridAgentUpdaterConfiguration=");
        b.append(this.hybridAgentUpdaterConfiguration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
