package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Singleton entity which represents the Exchange OnPremises Conditional Access
 * Settings for a tenant.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enabled", 
    "includedGroups", 
    "excludedGroups", 
    "overrideDefaultRule"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesConditionalAccessSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesConditionalAccessSettings";
    }

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("includedGroups")
    protected List<String> includedGroups;

    @JsonProperty("includedGroups@nextLink")
    protected String includedGroupsNextLink;

    @JsonProperty("excludedGroups")
    protected List<String> excludedGroups;

    @JsonProperty("excludedGroups@nextLink")
    protected String excludedGroupsNextLink;

    @JsonProperty("overrideDefaultRule")
    protected Boolean overrideDefaultRule;

    protected OnPremisesConditionalAccessSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnPremisesConditionalAccessSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean enabled;
        private List<String> includedGroups;
        private String includedGroupsNextLink;
        private List<String> excludedGroups;
        private String excludedGroupsNextLink;
        private Boolean overrideDefaultRule;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Indicates if on premises conditional access is enabled for this organization”</i>
         * 
         * @param enabled
         *            value of {@code enabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        /**
         * <i>“User groups that will be targeted by on premises conditional access. All users
         * in these groups will be required to have mobile device managed and compliant for
         * mail access.”</i>
         * 
         * @param includedGroups
         *            value of {@code includedGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder includedGroups(List<String> includedGroups) {
            this.includedGroups = includedGroups;
            this.changedFields = changedFields.add("includedGroups");
            return this;
        }

        /**
         * <i>“User groups that will be targeted by on premises conditional access. All users
         * in these groups will be required to have mobile device managed and compliant for
         * mail access.”</i>
         * 
         * @param includedGroups
         *            value of {@code includedGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder includedGroups(String... includedGroups) {
            return includedGroups(Arrays.asList(includedGroups));
        }

        /**
         * <i>“User groups that will be targeted by on premises conditional access. All users
         * in these groups will be required to have mobile device managed and compliant for
         * mail access.”</i>
         * 
         * @param includedGroupsNextLink
         *            value of {@code includedGroups@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder includedGroupsNextLink(String includedGroupsNextLink) {
            this.includedGroupsNextLink = includedGroupsNextLink;
            this.changedFields = changedFields.add("includedGroups");
            return this;
        }

        /**
         * <i>“User groups that will be exempt by on premises conditional access. All users in
         * these groups will be exempt from the conditional access policy.”</i>
         * 
         * @param excludedGroups
         *            value of {@code excludedGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedGroups(List<String> excludedGroups) {
            this.excludedGroups = excludedGroups;
            this.changedFields = changedFields.add("excludedGroups");
            return this;
        }

        /**
         * <i>“User groups that will be exempt by on premises conditional access. All users in
         * these groups will be exempt from the conditional access policy.”</i>
         * 
         * @param excludedGroups
         *            value of {@code excludedGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedGroups(String... excludedGroups) {
            return excludedGroups(Arrays.asList(excludedGroups));
        }

        /**
         * <i>“User groups that will be exempt by on premises conditional access. All users in
         * these groups will be exempt from the conditional access policy.”</i>
         * 
         * @param excludedGroupsNextLink
         *            value of {@code excludedGroups@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedGroupsNextLink(String excludedGroupsNextLink) {
            this.excludedGroupsNextLink = excludedGroupsNextLink;
            this.changedFields = changedFields.add("excludedGroups");
            return this;
        }

        /**
         * <i>“Override the default access rule when allowing a device to ensure access is
         * granted.”</i>
         * 
         * @param overrideDefaultRule
         *            value of {@code overrideDefaultRule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder overrideDefaultRule(Boolean overrideDefaultRule) {
            this.overrideDefaultRule = overrideDefaultRule;
            this.changedFields = changedFields.add("overrideDefaultRule");
            return this;
        }

        public OnPremisesConditionalAccessSettings build() {
            OnPremisesConditionalAccessSettings _x = new OnPremisesConditionalAccessSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onPremisesConditionalAccessSettings";
            _x.id = id;
            _x.enabled = enabled;
            _x.includedGroups = includedGroups;
            _x.includedGroupsNextLink = includedGroupsNextLink;
            _x.excludedGroups = excludedGroups;
            _x.excludedGroupsNextLink = excludedGroupsNextLink;
            _x.overrideDefaultRule = overrideDefaultRule;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates if on premises conditional access is enabled for this organization”</i>
     * 
     * @return property enabled
     */
    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if on premises conditional access is enabled for this organization”</i>
     * 
     * @param enabled
     *            new value of {@code enabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabled} field changed
     */
    public OnPremisesConditionalAccessSettings withEnabled(Boolean enabled) {
        OnPremisesConditionalAccessSettings _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesConditionalAccessSettings");
        _x.enabled = enabled;
        return _x;
    }

    /**
     * <i>“User groups that will be targeted by on premises conditional access. All users
     * in these groups will be required to have mobile device managed and compliant for
     * mail access.”</i>
     * 
     * @return property includedGroups
     */
    @Property(name="includedGroups")
    @JsonIgnore
    public CollectionPage<String> getIncludedGroups() {
        return new CollectionPage<String>(contextPath, String.class, includedGroups, Optional.ofNullable(includedGroupsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups that will be targeted by on premises conditional access. All users
     * in these groups will be required to have mobile device managed and compliant for
     * mail access.”</i>
     * 
     * @return property includedGroups
     */
    @Property(name="includedGroups")
    @JsonIgnore
    public CollectionPage<String> getIncludedGroups(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, includedGroups, Optional.ofNullable(includedGroupsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“User groups that will be exempt by on premises conditional access. All users in
     * these groups will be exempt from the conditional access policy.”</i>
     * 
     * @return property excludedGroups
     */
    @Property(name="excludedGroups")
    @JsonIgnore
    public CollectionPage<String> getExcludedGroups() {
        return new CollectionPage<String>(contextPath, String.class, excludedGroups, Optional.ofNullable(excludedGroupsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“User groups that will be exempt by on premises conditional access. All users in
     * these groups will be exempt from the conditional access policy.”</i>
     * 
     * @return property excludedGroups
     */
    @Property(name="excludedGroups")
    @JsonIgnore
    public CollectionPage<String> getExcludedGroups(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, excludedGroups, Optional.ofNullable(excludedGroupsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Override the default access rule when allowing a device to ensure access is
     * granted.”</i>
     * 
     * @return property overrideDefaultRule
     */
    @Property(name="overrideDefaultRule")
    @JsonIgnore
    public Optional<Boolean> getOverrideDefaultRule() {
        return Optional.ofNullable(overrideDefaultRule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * overrideDefaultRule} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Override the default access rule when allowing a device to ensure access is
     * granted.”</i>
     * 
     * @param overrideDefaultRule
     *            new value of {@code overrideDefaultRule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code overrideDefaultRule} field changed
     */
    public OnPremisesConditionalAccessSettings withOverrideDefaultRule(Boolean overrideDefaultRule) {
        OnPremisesConditionalAccessSettings _x = _copy();
        _x.changedFields = changedFields.add("overrideDefaultRule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesConditionalAccessSettings");
        _x.overrideDefaultRule = overrideDefaultRule;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesConditionalAccessSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnPremisesConditionalAccessSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesConditionalAccessSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnPremisesConditionalAccessSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnPremisesConditionalAccessSettings _copy() {
        OnPremisesConditionalAccessSettings _x = new OnPremisesConditionalAccessSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.enabled = enabled;
        _x.includedGroups = includedGroups;
        _x.excludedGroups = excludedGroups;
        _x.overrideDefaultRule = overrideDefaultRule;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesConditionalAccessSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("includedGroups=");
        b.append(this.includedGroups);
        b.append(", ");
        b.append("excludedGroups=");
        b.append(this.excludedGroups);
        b.append(", ");
        b.append("overrideDefaultRule=");
        b.append(this.overrideDefaultRule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
