package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;
import odata.msgraph.client.beta.enums.AgentStatus;
import odata.msgraph.client.beta.enums.OnPremisesPublishingType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "machineName", 
    "externalIp", 
    "status", 
    "supportedPublishingTypes"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesAgent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesAgent";
    }

    @JsonProperty("machineName")
    protected String machineName;

    @JsonProperty("externalIp")
    protected String externalIp;

    @JsonProperty("status")
    protected AgentStatus status;

    @JsonProperty("supportedPublishingTypes")
    protected List<OnPremisesPublishingType> supportedPublishingTypes;

    @JsonProperty("supportedPublishingTypes@nextLink")
    protected String supportedPublishingTypesNextLink;

    protected OnPremisesAgent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOnPremisesAgent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String machineName;
        private String externalIp;
        private AgentStatus status;
        private List<OnPremisesPublishingType> supportedPublishingTypes;
        private String supportedPublishingTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder machineName(String machineName) {
            this.machineName = machineName;
            this.changedFields = changedFields.add("machineName");
            return this;
        }

        public Builder externalIp(String externalIp) {
            this.externalIp = externalIp;
            this.changedFields = changedFields.add("externalIp");
            return this;
        }

        public Builder status(AgentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder supportedPublishingTypes(List<OnPremisesPublishingType> supportedPublishingTypes) {
            this.supportedPublishingTypes = supportedPublishingTypes;
            this.changedFields = changedFields.add("supportedPublishingTypes");
            return this;
        }

        public Builder supportedPublishingTypes(OnPremisesPublishingType... supportedPublishingTypes) {
            return supportedPublishingTypes(Arrays.asList(supportedPublishingTypes));
        }

        public Builder supportedPublishingTypesNextLink(String supportedPublishingTypesNextLink) {
            this.supportedPublishingTypesNextLink = supportedPublishingTypesNextLink;
            this.changedFields = changedFields.add("supportedPublishingTypes");
            return this;
        }

        public OnPremisesAgent build() {
            OnPremisesAgent _x = new OnPremisesAgent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onPremisesAgent";
            _x.id = id;
            _x.machineName = machineName;
            _x.externalIp = externalIp;
            _x.status = status;
            _x.supportedPublishingTypes = supportedPublishingTypes;
            _x.supportedPublishingTypesNextLink = supportedPublishingTypesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="machineName")
    @JsonIgnore
    public Optional<String> getMachineName() {
        return Optional.ofNullable(machineName);
    }

    public OnPremisesAgent withMachineName(String machineName) {
        OnPremisesAgent _x = _copy();
        _x.changedFields = changedFields.add("machineName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesAgent");
        _x.machineName = machineName;
        return _x;
    }

    @Property(name="externalIp")
    @JsonIgnore
    public Optional<String> getExternalIp() {
        return Optional.ofNullable(externalIp);
    }

    public OnPremisesAgent withExternalIp(String externalIp) {
        OnPremisesAgent _x = _copy();
        _x.changedFields = changedFields.add("externalIp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesAgent");
        _x.externalIp = externalIp;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AgentStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public OnPremisesAgent withStatus(AgentStatus status) {
        OnPremisesAgent _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesAgent");
        _x.status = status;
        return _x;
    }

    @Property(name="supportedPublishingTypes")
    @JsonIgnore
    public CollectionPage<OnPremisesPublishingType> getSupportedPublishingTypes() {
        return new CollectionPage<OnPremisesPublishingType>(contextPath, OnPremisesPublishingType.class, supportedPublishingTypes, Optional.ofNullable(supportedPublishingTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedPublishingTypes")
    @JsonIgnore
    public CollectionPage<OnPremisesPublishingType> getSupportedPublishingTypes(HttpRequestOptions options) {
        return new CollectionPage<OnPremisesPublishingType>(contextPath, OnPremisesPublishingType.class, supportedPublishingTypes, Optional.ofNullable(supportedPublishingTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="agentGroups")
    @JsonIgnore
    public OnPremisesAgentGroupCollectionRequest getAgentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesAgent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OnPremisesAgent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OnPremisesAgent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OnPremisesAgent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OnPremisesAgent _copy() {
        OnPremisesAgent _x = new OnPremisesAgent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.machineName = machineName;
        _x.externalIp = externalIp;
        _x.status = status;
        _x.supportedPublishingTypes = supportedPublishingTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesAgent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("machineName=");
        b.append(this.machineName);
        b.append(", ");
        b.append("externalIp=");
        b.append(this.externalIp);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("supportedPublishingTypes=");
        b.append(this.supportedPublishingTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
