package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ExcludedApps;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.OfficeProductId;
import odata.msgraph.client.beta.enums.OfficeSuiteInstallProgressDisplayLevel;
import odata.msgraph.client.beta.enums.OfficeUpdateChannel;
import odata.msgraph.client.beta.enums.WindowsArchitecture;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Contains properties and inherited properties for the Office365 Suite App.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "autoAcceptEula", 
    "productIds", 
    "excludedApps", 
    "useSharedComputerActivation", 
    "updateChannel", 
    "officePlatformArchitecture", 
    "localesToInstall", 
    "installProgressDisplayLevel", 
    "shouldUninstallOlderVersionsOfOffice", 
    "targetVersion", 
    "updateVersion", 
    "officeConfigurationXml"})
@JsonInclude(Include.NON_NULL)
public class OfficeSuiteApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeSuiteApp";
    }

    @JsonProperty("autoAcceptEula")
    protected Boolean autoAcceptEula;

    @JsonProperty("productIds")
    protected List<OfficeProductId> productIds;

    @JsonProperty("productIds@nextLink")
    protected String productIdsNextLink;

    @JsonProperty("excludedApps")
    protected ExcludedApps excludedApps;

    @JsonProperty("useSharedComputerActivation")
    protected Boolean useSharedComputerActivation;

    @JsonProperty("updateChannel")
    protected OfficeUpdateChannel updateChannel;

    @JsonProperty("officePlatformArchitecture")
    protected WindowsArchitecture officePlatformArchitecture;

    @JsonProperty("localesToInstall")
    protected List<String> localesToInstall;

    @JsonProperty("localesToInstall@nextLink")
    protected String localesToInstallNextLink;

    @JsonProperty("installProgressDisplayLevel")
    protected OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel;

    @JsonProperty("shouldUninstallOlderVersionsOfOffice")
    protected Boolean shouldUninstallOlderVersionsOfOffice;

    @JsonProperty("targetVersion")
    protected String targetVersion;

    @JsonProperty("updateVersion")
    protected String updateVersion;

    @JsonProperty("officeConfigurationXml")
    protected byte[] officeConfigurationXml;

    protected OfficeSuiteApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOfficeSuiteApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private Boolean autoAcceptEula;
        private List<OfficeProductId> productIds;
        private String productIdsNextLink;
        private ExcludedApps excludedApps;
        private Boolean useSharedComputerActivation;
        private OfficeUpdateChannel updateChannel;
        private WindowsArchitecture officePlatformArchitecture;
        private List<String> localesToInstall;
        private String localesToInstallNextLink;
        private OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel;
        private Boolean shouldUninstallOlderVersionsOfOffice;
        private String targetVersion;
        private String updateVersion;
        private byte[] officeConfigurationXml;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        /**
         * <i>“The value to accept the EULA automatically on the enduser's device.”</i>
         * 
         * @param autoAcceptEula
         *            value of {@code autoAcceptEula} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoAcceptEula(Boolean autoAcceptEula) {
            this.autoAcceptEula = autoAcceptEula;
            this.changedFields = changedFields.add("autoAcceptEula");
            return this;
        }

        /**
         * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
         * 
         * @param productIds
         *            value of {@code productIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productIds(List<OfficeProductId> productIds) {
            this.productIds = productIds;
            this.changedFields = changedFields.add("productIds");
            return this;
        }

        /**
         * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
         * 
         * @param productIds
         *            value of {@code productIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productIds(OfficeProductId... productIds) {
            return productIds(Arrays.asList(productIds));
        }

        /**
         * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
         * 
         * @param productIdsNextLink
         *            value of {@code productIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productIdsNextLink(String productIdsNextLink) {
            this.productIdsNextLink = productIdsNextLink;
            this.changedFields = changedFields.add("productIds");
            return this;
        }

        /**
         * <i>“The property to represent the apps which are excluded from the selected
         * Office365 Product Id.”</i>
         * 
         * @param excludedApps
         *            value of {@code excludedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedApps(ExcludedApps excludedApps) {
            this.excludedApps = excludedApps;
            this.changedFields = changedFields.add("excludedApps");
            return this;
        }

        /**
         * <i>“The property to represent that whether the shared computer activation is used
         * not for Office365 app suite.”</i>
         * 
         * @param useSharedComputerActivation
         *            value of {@code useSharedComputerActivation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useSharedComputerActivation(Boolean useSharedComputerActivation) {
            this.useSharedComputerActivation = useSharedComputerActivation;
            this.changedFields = changedFields.add("useSharedComputerActivation");
            return this;
        }

        /**
         * <i>“The property to represent the Office365 Update Channel.”</i>
         * 
         * @param updateChannel
         *            value of {@code updateChannel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateChannel(OfficeUpdateChannel updateChannel) {
            this.updateChannel = updateChannel;
            this.changedFields = changedFields.add("updateChannel");
            return this;
        }

        /**
         * <i>“The property to represent the Office365 app suite version.”</i>
         * 
         * @param officePlatformArchitecture
         *            value of {@code officePlatformArchitecture} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder officePlatformArchitecture(WindowsArchitecture officePlatformArchitecture) {
            this.officePlatformArchitecture = officePlatformArchitecture;
            this.changedFields = changedFields.add("officePlatformArchitecture");
            return this;
        }

        /**
         * <i>“The property to represent the locales which are installed when the apps from
         * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
         * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
         * 
         * @param localesToInstall
         *            value of {@code localesToInstall} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localesToInstall(List<String> localesToInstall) {
            this.localesToInstall = localesToInstall;
            this.changedFields = changedFields.add("localesToInstall");
            return this;
        }

        /**
         * <i>“The property to represent the locales which are installed when the apps from
         * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
         * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
         * 
         * @param localesToInstall
         *            value of {@code localesToInstall} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localesToInstall(String... localesToInstall) {
            return localesToInstall(Arrays.asList(localesToInstall));
        }

        /**
         * <i>“The property to represent the locales which are installed when the apps from
         * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
         * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
         * 
         * @param localesToInstallNextLink
         *            value of {@code localesToInstall@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localesToInstallNextLink(String localesToInstallNextLink) {
            this.localesToInstallNextLink = localesToInstallNextLink;
            this.changedFields = changedFields.add("localesToInstall");
            return this;
        }

        /**
         * <i>“To specify the level of display for the Installation Progress Setup UI on the
         * Device.”</i>
         * 
         * @param installProgressDisplayLevel
         *            value of {@code installProgressDisplayLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installProgressDisplayLevel(OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel) {
            this.installProgressDisplayLevel = installProgressDisplayLevel;
            this.changedFields = changedFields.add("installProgressDisplayLevel");
            return this;
        }

        /**
         * <i>“The property to determine whether to uninstall existing Office MSI if an
         * Office365 app suite is deployed to the device or not.”</i>
         * 
         * @param shouldUninstallOlderVersionsOfOffice
         *            value of {@code shouldUninstallOlderVersionsOfOffice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shouldUninstallOlderVersionsOfOffice(Boolean shouldUninstallOlderVersionsOfOffice) {
            this.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
            this.changedFields = changedFields.add("shouldUninstallOlderVersionsOfOffice");
            return this;
        }

        /**
         * <i>“The property to represent the specific target version for the Office365 app
         * suite that should be remained deployed on the devices.”</i>
         * 
         * @param targetVersion
         *            value of {@code targetVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            this.changedFields = changedFields.add("targetVersion");
            return this;
        }

        /**
         * <i>“The property to represent the update version in which the specific target
         * version is available for the Office365 app suite.”</i>
         * 
         * @param updateVersion
         *            value of {@code updateVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateVersion(String updateVersion) {
            this.updateVersion = updateVersion;
            this.changedFields = changedFields.add("updateVersion");
            return this;
        }

        /**
         * <i>“The property to represent the XML configuration file that can be specified for
         * Office ProPlus Apps. Takes precedence over all other properties. When present,
         * the XML configuration file will be used to create the app.”</i>
         * 
         * @param officeConfigurationXml
         *            value of {@code officeConfigurationXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder officeConfigurationXml(byte[] officeConfigurationXml) {
            this.officeConfigurationXml = officeConfigurationXml;
            this.changedFields = changedFields.add("officeConfigurationXml");
            return this;
        }

        public OfficeSuiteApp build() {
            OfficeSuiteApp _x = new OfficeSuiteApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.officeSuiteApp";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.autoAcceptEula = autoAcceptEula;
            _x.productIds = productIds;
            _x.productIdsNextLink = productIdsNextLink;
            _x.excludedApps = excludedApps;
            _x.useSharedComputerActivation = useSharedComputerActivation;
            _x.updateChannel = updateChannel;
            _x.officePlatformArchitecture = officePlatformArchitecture;
            _x.localesToInstall = localesToInstall;
            _x.localesToInstallNextLink = localesToInstallNextLink;
            _x.installProgressDisplayLevel = installProgressDisplayLevel;
            _x.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
            _x.targetVersion = targetVersion;
            _x.updateVersion = updateVersion;
            _x.officeConfigurationXml = officeConfigurationXml;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The value to accept the EULA automatically on the enduser's device.”</i>
     * 
     * @return property autoAcceptEula
     */
    @Property(name="autoAcceptEula")
    @JsonIgnore
    public Optional<Boolean> getAutoAcceptEula() {
        return Optional.ofNullable(autoAcceptEula);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autoAcceptEula}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value to accept the EULA automatically on the enduser's device.”</i>
     * 
     * @param autoAcceptEula
     *            new value of {@code autoAcceptEula} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoAcceptEula} field changed
     */
    public OfficeSuiteApp withAutoAcceptEula(Boolean autoAcceptEula) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("autoAcceptEula");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.autoAcceptEula = autoAcceptEula;
        return _x;
    }

    /**
     * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
     * 
     * @return property productIds
     */
    @Property(name="productIds")
    @JsonIgnore
    public CollectionPage<OfficeProductId> getProductIds() {
        return new CollectionPage<OfficeProductId>(contextPath, OfficeProductId.class, productIds, Optional.ofNullable(productIdsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
     * 
     * @return property productIds
     */
    @Property(name="productIds")
    @JsonIgnore
    public CollectionPage<OfficeProductId> getProductIds(HttpRequestOptions options) {
        return new CollectionPage<OfficeProductId>(contextPath, OfficeProductId.class, productIds, Optional.ofNullable(productIdsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The property to represent the apps which are excluded from the selected
     * Office365 Product Id.”</i>
     * 
     * @return property excludedApps
     */
    @Property(name="excludedApps")
    @JsonIgnore
    public Optional<ExcludedApps> getExcludedApps() {
        return Optional.ofNullable(excludedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code excludedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the apps which are excluded from the selected
     * Office365 Product Id.”</i>
     * 
     * @param excludedApps
     *            new value of {@code excludedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code excludedApps} field changed
     */
    public OfficeSuiteApp withExcludedApps(ExcludedApps excludedApps) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("excludedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.excludedApps = excludedApps;
        return _x;
    }

    /**
     * <i>“The property to represent that whether the shared computer activation is used
     * not for Office365 app suite.”</i>
     * 
     * @return property useSharedComputerActivation
     */
    @Property(name="useSharedComputerActivation")
    @JsonIgnore
    public Optional<Boolean> getUseSharedComputerActivation() {
        return Optional.ofNullable(useSharedComputerActivation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useSharedComputerActivation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to represent that whether the shared computer activation is used
     * not for Office365 app suite.”</i>
     * 
     * @param useSharedComputerActivation
     *            new value of {@code useSharedComputerActivation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useSharedComputerActivation} field changed
     */
    public OfficeSuiteApp withUseSharedComputerActivation(Boolean useSharedComputerActivation) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("useSharedComputerActivation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.useSharedComputerActivation = useSharedComputerActivation;
        return _x;
    }

    /**
     * <i>“The property to represent the Office365 Update Channel.”</i>
     * 
     * @return property updateChannel
     */
    @Property(name="updateChannel")
    @JsonIgnore
    public Optional<OfficeUpdateChannel> getUpdateChannel() {
        return Optional.ofNullable(updateChannel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateChannel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the Office365 Update Channel.”</i>
     * 
     * @param updateChannel
     *            new value of {@code updateChannel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateChannel} field changed
     */
    public OfficeSuiteApp withUpdateChannel(OfficeUpdateChannel updateChannel) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("updateChannel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.updateChannel = updateChannel;
        return _x;
    }

    /**
     * <i>“The property to represent the Office365 app suite version.”</i>
     * 
     * @return property officePlatformArchitecture
     */
    @Property(name="officePlatformArchitecture")
    @JsonIgnore
    public Optional<WindowsArchitecture> getOfficePlatformArchitecture() {
        return Optional.ofNullable(officePlatformArchitecture);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * officePlatformArchitecture} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to represent the Office365 app suite version.”</i>
     * 
     * @param officePlatformArchitecture
     *            new value of {@code officePlatformArchitecture} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code officePlatformArchitecture} field changed
     */
    public OfficeSuiteApp withOfficePlatformArchitecture(WindowsArchitecture officePlatformArchitecture) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("officePlatformArchitecture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.officePlatformArchitecture = officePlatformArchitecture;
        return _x;
    }

    /**
     * <i>“The property to represent the locales which are installed when the apps from
     * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
     * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
     * 
     * @return property localesToInstall
     */
    @Property(name="localesToInstall")
    @JsonIgnore
    public CollectionPage<String> getLocalesToInstall() {
        return new CollectionPage<String>(contextPath, String.class, localesToInstall, Optional.ofNullable(localesToInstallNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The property to represent the locales which are installed when the apps from
     * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
     * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
     * 
     * @return property localesToInstall
     */
    @Property(name="localesToInstall")
    @JsonIgnore
    public CollectionPage<String> getLocalesToInstall(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, localesToInstall, Optional.ofNullable(localesToInstallNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“To specify the level of display for the Installation Progress Setup UI on the
     * Device.”</i>
     * 
     * @return property installProgressDisplayLevel
     */
    @Property(name="installProgressDisplayLevel")
    @JsonIgnore
    public Optional<OfficeSuiteInstallProgressDisplayLevel> getInstallProgressDisplayLevel() {
        return Optional.ofNullable(installProgressDisplayLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installProgressDisplayLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“To specify the level of display for the Installation Progress Setup UI on the
     * Device.”</i>
     * 
     * @param installProgressDisplayLevel
     *            new value of {@code installProgressDisplayLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installProgressDisplayLevel} field changed
     */
    public OfficeSuiteApp withInstallProgressDisplayLevel(OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("installProgressDisplayLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.installProgressDisplayLevel = installProgressDisplayLevel;
        return _x;
    }

    /**
     * <i>“The property to determine whether to uninstall existing Office MSI if an
     * Office365 app suite is deployed to the device or not.”</i>
     * 
     * @return property shouldUninstallOlderVersionsOfOffice
     */
    @Property(name="shouldUninstallOlderVersionsOfOffice")
    @JsonIgnore
    public Optional<Boolean> getShouldUninstallOlderVersionsOfOffice() {
        return Optional.ofNullable(shouldUninstallOlderVersionsOfOffice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * shouldUninstallOlderVersionsOfOffice} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The property to determine whether to uninstall existing Office MSI if an
     * Office365 app suite is deployed to the device or not.”</i>
     * 
     * @param shouldUninstallOlderVersionsOfOffice
     *            new value of {@code shouldUninstallOlderVersionsOfOffice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shouldUninstallOlderVersionsOfOffice} field changed
     */
    public OfficeSuiteApp withShouldUninstallOlderVersionsOfOffice(Boolean shouldUninstallOlderVersionsOfOffice) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("shouldUninstallOlderVersionsOfOffice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
        return _x;
    }

    /**
     * <i>“The property to represent the specific target version for the Office365 app
     * suite that should be remained deployed on the devices.”</i>
     * 
     * @return property targetVersion
     */
    @Property(name="targetVersion")
    @JsonIgnore
    public Optional<String> getTargetVersion() {
        return Optional.ofNullable(targetVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the specific target version for the Office365 app
     * suite that should be remained deployed on the devices.”</i>
     * 
     * @param targetVersion
     *            new value of {@code targetVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetVersion} field changed
     */
    public OfficeSuiteApp withTargetVersion(String targetVersion) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("targetVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.targetVersion = targetVersion;
        return _x;
    }

    /**
     * <i>“The property to represent the update version in which the specific target
     * version is available for the Office365 app suite.”</i>
     * 
     * @return property updateVersion
     */
    @Property(name="updateVersion")
    @JsonIgnore
    public Optional<String> getUpdateVersion() {
        return Optional.ofNullable(updateVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the update version in which the specific target
     * version is available for the Office365 app suite.”</i>
     * 
     * @param updateVersion
     *            new value of {@code updateVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateVersion} field changed
     */
    public OfficeSuiteApp withUpdateVersion(String updateVersion) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("updateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.updateVersion = updateVersion;
        return _x;
    }

    /**
     * <i>“The property to represent the XML configuration file that can be specified for
     * Office ProPlus Apps. Takes precedence over all other properties. When present,
     * the XML configuration file will be used to create the app.”</i>
     * 
     * @return property officeConfigurationXml
     */
    @Property(name="officeConfigurationXml")
    @JsonIgnore
    public Optional<byte[]> getOfficeConfigurationXml() {
        return Optional.ofNullable(officeConfigurationXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * officeConfigurationXml} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to represent the XML configuration file that can be specified for
     * Office ProPlus Apps. Takes precedence over all other properties. When present,
     * the XML configuration file will be used to create the app.”</i>
     * 
     * @param officeConfigurationXml
     *            new value of {@code officeConfigurationXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code officeConfigurationXml} field changed
     */
    public OfficeSuiteApp withOfficeConfigurationXml(byte[] officeConfigurationXml) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("officeConfigurationXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.officeConfigurationXml = officeConfigurationXml;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeSuiteApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OfficeSuiteApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeSuiteApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OfficeSuiteApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OfficeSuiteApp _copy() {
        OfficeSuiteApp _x = new OfficeSuiteApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.autoAcceptEula = autoAcceptEula;
        _x.productIds = productIds;
        _x.excludedApps = excludedApps;
        _x.useSharedComputerActivation = useSharedComputerActivation;
        _x.updateChannel = updateChannel;
        _x.officePlatformArchitecture = officePlatformArchitecture;
        _x.localesToInstall = localesToInstall;
        _x.installProgressDisplayLevel = installProgressDisplayLevel;
        _x.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
        _x.targetVersion = targetVersion;
        _x.updateVersion = updateVersion;
        _x.officeConfigurationXml = officeConfigurationXml;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeSuiteApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("autoAcceptEula=");
        b.append(this.autoAcceptEula);
        b.append(", ");
        b.append("productIds=");
        b.append(this.productIds);
        b.append(", ");
        b.append("excludedApps=");
        b.append(this.excludedApps);
        b.append(", ");
        b.append("useSharedComputerActivation=");
        b.append(this.useSharedComputerActivation);
        b.append(", ");
        b.append("updateChannel=");
        b.append(this.updateChannel);
        b.append(", ");
        b.append("officePlatformArchitecture=");
        b.append(this.officePlatformArchitecture);
        b.append(", ");
        b.append("localesToInstall=");
        b.append(this.localesToInstall);
        b.append(", ");
        b.append("installProgressDisplayLevel=");
        b.append(this.installProgressDisplayLevel);
        b.append(", ");
        b.append("shouldUninstallOlderVersionsOfOffice=");
        b.append(this.shouldUninstallOlderVersionsOfOffice);
        b.append(", ");
        b.append("targetVersion=");
        b.append(this.targetVersion);
        b.append(", ");
        b.append("updateVersion=");
        b.append(this.updateVersion);
        b.append(", ");
        b.append("officeConfigurationXml=");
        b.append(this.officeConfigurationXml);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
