package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OfficeClientCheckinStatus;
import odata.msgraph.client.beta.complex.OfficeUserCheckinSummary;
import odata.msgraph.client.beta.entity.collection.request.OfficeClientConfigurationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "tenantCheckinStatuses", 
    "tenantUserCheckinSummary"})
@JsonInclude(Include.NON_NULL)
public class OfficeConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeConfiguration";
    }

    @JsonProperty("tenantCheckinStatuses")
    protected List<OfficeClientCheckinStatus> tenantCheckinStatuses;

    @JsonProperty("tenantCheckinStatuses@nextLink")
    protected String tenantCheckinStatusesNextLink;

    @JsonProperty("tenantUserCheckinSummary")
    protected OfficeUserCheckinSummary tenantUserCheckinSummary;

    protected OfficeConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOfficeConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<OfficeClientCheckinStatus> tenantCheckinStatuses;
        private String tenantCheckinStatusesNextLink;
        private OfficeUserCheckinSummary tenantUserCheckinSummary;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder tenantCheckinStatuses(List<OfficeClientCheckinStatus> tenantCheckinStatuses) {
            this.tenantCheckinStatuses = tenantCheckinStatuses;
            this.changedFields = changedFields.add("tenantCheckinStatuses");
            return this;
        }

        public Builder tenantCheckinStatuses(OfficeClientCheckinStatus... tenantCheckinStatuses) {
            return tenantCheckinStatuses(Arrays.asList(tenantCheckinStatuses));
        }

        public Builder tenantCheckinStatusesNextLink(String tenantCheckinStatusesNextLink) {
            this.tenantCheckinStatusesNextLink = tenantCheckinStatusesNextLink;
            this.changedFields = changedFields.add("tenantCheckinStatuses");
            return this;
        }

        public Builder tenantUserCheckinSummary(OfficeUserCheckinSummary tenantUserCheckinSummary) {
            this.tenantUserCheckinSummary = tenantUserCheckinSummary;
            this.changedFields = changedFields.add("tenantUserCheckinSummary");
            return this;
        }

        public OfficeConfiguration build() {
            OfficeConfiguration _x = new OfficeConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.officeConfiguration";
            _x.id = id;
            _x.tenantCheckinStatuses = tenantCheckinStatuses;
            _x.tenantCheckinStatusesNextLink = tenantCheckinStatusesNextLink;
            _x.tenantUserCheckinSummary = tenantUserCheckinSummary;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="tenantCheckinStatuses")
    @JsonIgnore
    public CollectionPage<OfficeClientCheckinStatus> getTenantCheckinStatuses() {
        return new CollectionPage<OfficeClientCheckinStatus>(contextPath, OfficeClientCheckinStatus.class, tenantCheckinStatuses, Optional.ofNullable(tenantCheckinStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tenantCheckinStatuses")
    @JsonIgnore
    public CollectionPage<OfficeClientCheckinStatus> getTenantCheckinStatuses(HttpRequestOptions options) {
        return new CollectionPage<OfficeClientCheckinStatus>(contextPath, OfficeClientCheckinStatus.class, tenantCheckinStatuses, Optional.ofNullable(tenantCheckinStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="tenantUserCheckinSummary")
    @JsonIgnore
    public Optional<OfficeUserCheckinSummary> getTenantUserCheckinSummary() {
        return Optional.ofNullable(tenantUserCheckinSummary);
    }

    public OfficeConfiguration withTenantUserCheckinSummary(OfficeUserCheckinSummary tenantUserCheckinSummary) {
        OfficeConfiguration _x = _copy();
        _x.changedFields = changedFields.add("tenantUserCheckinSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeConfiguration");
        _x.tenantUserCheckinSummary = tenantUserCheckinSummary;
        return _x;
    }

    @NavigationProperty(name="clientConfigurations")
    @JsonIgnore
    public OfficeClientConfigurationCollectionRequest getClientConfigurations() {
        return new OfficeClientConfigurationCollectionRequest(
                        contextPath.addSegment("clientConfigurations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OfficeConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OfficeConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OfficeConfiguration _copy() {
        OfficeConfiguration _x = new OfficeConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.tenantCheckinStatuses = tenantCheckinStatuses;
        _x.tenantUserCheckinSummary = tenantUserCheckinSummary;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("tenantCheckinStatuses=");
        b.append(this.tenantCheckinStatuses);
        b.append(", ");
        b.append("tenantUserCheckinSummary=");
        b.append(this.tenantUserCheckinSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
