package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OfficeClientCheckinStatus;
import odata.msgraph.client.beta.complex.OfficeUserCheckinSummary;
import odata.msgraph.client.beta.entity.collection.request.OfficeClientConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "userPreferencePayload", 
    "policyPayload", 
    "description", 
    "displayName", 
    "priority", 
    "userCheckinSummary", 
    "checkinStatuses"})
@JsonInclude(Include.NON_NULL)
public class OfficeClientConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeClientConfiguration";
    }

    @JsonProperty("userPreferencePayload")
    protected String userPreferencePayload;

    @JsonProperty("policyPayload")
    protected String policyPayload;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("userCheckinSummary")
    protected OfficeUserCheckinSummary userCheckinSummary;

    @JsonProperty("checkinStatuses")
    protected List<OfficeClientCheckinStatus> checkinStatuses;

    @JsonProperty("checkinStatuses@nextLink")
    protected String checkinStatusesNextLink;

    protected OfficeClientConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="userPreferencePayload")
    @JsonIgnore
    public Optional<StreamProvider> getUserPreferencePayload() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "userPreferencePayload", userPreferencePayload);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code userPreferencePayload} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="userPreferencePayload")
    public Optional<StreamUploaderSingleCall> putUserPreferencePayload() {
        return putUserPreferencePayload(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code userPreferencePayload} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="userPreferencePayload")
    public Optional<StreamUploaderChunked> putChunkedUserPreferencePayload() {
        return putUserPreferencePayload(UploadStrategy.chunked());
    }

    @Property(name="userPreferencePayload")
    public <T extends StreamUploader<T>> Optional<T> putUserPreferencePayload(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("userPreferencePayload"), this, "userPreferencePayload");
    }

    @Property(name="policyPayload")
    @JsonIgnore
    public Optional<StreamProvider> getPolicyPayload() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "policyPayload", policyPayload);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code policyPayload} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="policyPayload")
    public Optional<StreamUploaderSingleCall> putPolicyPayload() {
        return putPolicyPayload(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code policyPayload} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="policyPayload")
    public Optional<StreamUploaderChunked> putChunkedPolicyPayload() {
        return putPolicyPayload(UploadStrategy.chunked());
    }

    @Property(name="policyPayload")
    public <T extends StreamUploader<T>> Optional<T> putPolicyPayload(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("policyPayload"), this, "policyPayload");
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public OfficeClientConfiguration withDescription(String description) {
        OfficeClientConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientConfiguration");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public OfficeClientConfiguration withDisplayName(String displayName) {
        OfficeClientConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public OfficeClientConfiguration withPriority(Integer priority) {
        OfficeClientConfiguration _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientConfiguration");
        _x.priority = priority;
        return _x;
    }

    @Property(name="userCheckinSummary")
    @JsonIgnore
    public Optional<OfficeUserCheckinSummary> getUserCheckinSummary() {
        return Optional.ofNullable(userCheckinSummary);
    }

    public OfficeClientConfiguration withUserCheckinSummary(OfficeUserCheckinSummary userCheckinSummary) {
        OfficeClientConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userCheckinSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientConfiguration");
        _x.userCheckinSummary = userCheckinSummary;
        return _x;
    }

    @Property(name="checkinStatuses")
    @JsonIgnore
    public CollectionPage<OfficeClientCheckinStatus> getCheckinStatuses() {
        return new CollectionPage<OfficeClientCheckinStatus>(contextPath, OfficeClientCheckinStatus.class, checkinStatuses, Optional.ofNullable(checkinStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="checkinStatuses")
    @JsonIgnore
    public CollectionPage<OfficeClientCheckinStatus> getCheckinStatuses(HttpRequestOptions options) {
        return new CollectionPage<OfficeClientCheckinStatus>(contextPath, OfficeClientCheckinStatus.class, checkinStatuses, Optional.ofNullable(checkinStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="assignments")
    @JsonIgnore
    public OfficeClientConfigurationAssignmentCollectionRequest getAssignments() {
        return new OfficeClientConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeClientConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OfficeClientConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeClientConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OfficeClientConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OfficeClientConfiguration _copy() {
        OfficeClientConfiguration _x = new OfficeClientConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userPreferencePayload = userPreferencePayload;
        _x.policyPayload = policyPayload;
        _x.description = description;
        _x.displayName = displayName;
        _x.priority = priority;
        _x.userCheckinSummary = userCheckinSummary;
        _x.checkinStatuses = checkinStatuses;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OfficeClientConfigurationAssignment> assign(List<OfficeClientConfigurationAssignment> officeConfigurationAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("officeConfigurationAssignments", "Collection(microsoft.graph.officeClientConfigurationAssignment)", officeConfigurationAssignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), OfficeClientConfigurationAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeClientConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userPreferencePayload=");
        b.append(this.userPreferencePayload);
        b.append(", ");
        b.append("policyPayload=");
        b.append(this.policyPayload);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("userCheckinSummary=");
        b.append(this.userCheckinSummary);
        b.append(", ");
        b.append("checkinStatuses=");
        b.append(this.checkinStatuses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
