package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "exchangeActive", 
    "exchangeInactive", 
    "oneDriveActive", 
    "oneDriveInactive", 
    "sharePointActive", 
    "sharePointInactive", 
    "skypeForBusinessActive", 
    "skypeForBusinessInactive", 
    "yammerActive", 
    "yammerInactive", 
    "teamsActive", 
    "teamsInactive", 
    "office365Active", 
    "office365Inactive", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class Office365ServicesUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365ServicesUserCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("exchangeActive")
    protected Long exchangeActive;

    @JsonProperty("exchangeInactive")
    protected Long exchangeInactive;

    @JsonProperty("oneDriveActive")
    protected Long oneDriveActive;

    @JsonProperty("oneDriveInactive")
    protected Long oneDriveInactive;

    @JsonProperty("sharePointActive")
    protected Long sharePointActive;

    @JsonProperty("sharePointInactive")
    protected Long sharePointInactive;

    @JsonProperty("skypeForBusinessActive")
    protected Long skypeForBusinessActive;

    @JsonProperty("skypeForBusinessInactive")
    protected Long skypeForBusinessInactive;

    @JsonProperty("yammerActive")
    protected Long yammerActive;

    @JsonProperty("yammerInactive")
    protected Long yammerInactive;

    @JsonProperty("teamsActive")
    protected Long teamsActive;

    @JsonProperty("teamsInactive")
    protected Long teamsInactive;

    @JsonProperty("office365Active")
    protected Long office365Active;

    @JsonProperty("office365Inactive")
    protected Long office365Inactive;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected Office365ServicesUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365ServicesUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Long exchangeActive;
        private Long exchangeInactive;
        private Long oneDriveActive;
        private Long oneDriveInactive;
        private Long sharePointActive;
        private Long sharePointInactive;
        private Long skypeForBusinessActive;
        private Long skypeForBusinessInactive;
        private Long yammerActive;
        private Long yammerInactive;
        private Long teamsActive;
        private Long teamsInactive;
        private Long office365Active;
        private Long office365Inactive;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder exchangeActive(Long exchangeActive) {
            this.exchangeActive = exchangeActive;
            this.changedFields = changedFields.add("exchangeActive");
            return this;
        }

        public Builder exchangeInactive(Long exchangeInactive) {
            this.exchangeInactive = exchangeInactive;
            this.changedFields = changedFields.add("exchangeInactive");
            return this;
        }

        public Builder oneDriveActive(Long oneDriveActive) {
            this.oneDriveActive = oneDriveActive;
            this.changedFields = changedFields.add("oneDriveActive");
            return this;
        }

        public Builder oneDriveInactive(Long oneDriveInactive) {
            this.oneDriveInactive = oneDriveInactive;
            this.changedFields = changedFields.add("oneDriveInactive");
            return this;
        }

        public Builder sharePointActive(Long sharePointActive) {
            this.sharePointActive = sharePointActive;
            this.changedFields = changedFields.add("sharePointActive");
            return this;
        }

        public Builder sharePointInactive(Long sharePointInactive) {
            this.sharePointInactive = sharePointInactive;
            this.changedFields = changedFields.add("sharePointInactive");
            return this;
        }

        public Builder skypeForBusinessActive(Long skypeForBusinessActive) {
            this.skypeForBusinessActive = skypeForBusinessActive;
            this.changedFields = changedFields.add("skypeForBusinessActive");
            return this;
        }

        public Builder skypeForBusinessInactive(Long skypeForBusinessInactive) {
            this.skypeForBusinessInactive = skypeForBusinessInactive;
            this.changedFields = changedFields.add("skypeForBusinessInactive");
            return this;
        }

        public Builder yammerActive(Long yammerActive) {
            this.yammerActive = yammerActive;
            this.changedFields = changedFields.add("yammerActive");
            return this;
        }

        public Builder yammerInactive(Long yammerInactive) {
            this.yammerInactive = yammerInactive;
            this.changedFields = changedFields.add("yammerInactive");
            return this;
        }

        public Builder teamsActive(Long teamsActive) {
            this.teamsActive = teamsActive;
            this.changedFields = changedFields.add("teamsActive");
            return this;
        }

        public Builder teamsInactive(Long teamsInactive) {
            this.teamsInactive = teamsInactive;
            this.changedFields = changedFields.add("teamsInactive");
            return this;
        }

        public Builder office365Active(Long office365Active) {
            this.office365Active = office365Active;
            this.changedFields = changedFields.add("office365Active");
            return this;
        }

        public Builder office365Inactive(Long office365Inactive) {
            this.office365Inactive = office365Inactive;
            this.changedFields = changedFields.add("office365Inactive");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public Office365ServicesUserCounts build() {
            Office365ServicesUserCounts _x = new Office365ServicesUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.office365ServicesUserCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.exchangeActive = exchangeActive;
            _x.exchangeInactive = exchangeInactive;
            _x.oneDriveActive = oneDriveActive;
            _x.oneDriveInactive = oneDriveInactive;
            _x.sharePointActive = sharePointActive;
            _x.sharePointInactive = sharePointInactive;
            _x.skypeForBusinessActive = skypeForBusinessActive;
            _x.skypeForBusinessInactive = skypeForBusinessInactive;
            _x.yammerActive = yammerActive;
            _x.yammerInactive = yammerInactive;
            _x.teamsActive = teamsActive;
            _x.teamsInactive = teamsInactive;
            _x.office365Active = office365Active;
            _x.office365Inactive = office365Inactive;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365ServicesUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="exchangeActive")
    @JsonIgnore
    public Optional<Long> getExchangeActive() {
        return Optional.ofNullable(exchangeActive);
    }

    public Office365ServicesUserCounts withExchangeActive(Long exchangeActive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("exchangeActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.exchangeActive = exchangeActive;
        return _x;
    }

    @Property(name="exchangeInactive")
    @JsonIgnore
    public Optional<Long> getExchangeInactive() {
        return Optional.ofNullable(exchangeInactive);
    }

    public Office365ServicesUserCounts withExchangeInactive(Long exchangeInactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("exchangeInactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.exchangeInactive = exchangeInactive;
        return _x;
    }

    @Property(name="oneDriveActive")
    @JsonIgnore
    public Optional<Long> getOneDriveActive() {
        return Optional.ofNullable(oneDriveActive);
    }

    public Office365ServicesUserCounts withOneDriveActive(Long oneDriveActive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("oneDriveActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.oneDriveActive = oneDriveActive;
        return _x;
    }

    @Property(name="oneDriveInactive")
    @JsonIgnore
    public Optional<Long> getOneDriveInactive() {
        return Optional.ofNullable(oneDriveInactive);
    }

    public Office365ServicesUserCounts withOneDriveInactive(Long oneDriveInactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("oneDriveInactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.oneDriveInactive = oneDriveInactive;
        return _x;
    }

    @Property(name="sharePointActive")
    @JsonIgnore
    public Optional<Long> getSharePointActive() {
        return Optional.ofNullable(sharePointActive);
    }

    public Office365ServicesUserCounts withSharePointActive(Long sharePointActive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("sharePointActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.sharePointActive = sharePointActive;
        return _x;
    }

    @Property(name="sharePointInactive")
    @JsonIgnore
    public Optional<Long> getSharePointInactive() {
        return Optional.ofNullable(sharePointInactive);
    }

    public Office365ServicesUserCounts withSharePointInactive(Long sharePointInactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("sharePointInactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.sharePointInactive = sharePointInactive;
        return _x;
    }

    @Property(name="skypeForBusinessActive")
    @JsonIgnore
    public Optional<Long> getSkypeForBusinessActive() {
        return Optional.ofNullable(skypeForBusinessActive);
    }

    public Office365ServicesUserCounts withSkypeForBusinessActive(Long skypeForBusinessActive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("skypeForBusinessActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.skypeForBusinessActive = skypeForBusinessActive;
        return _x;
    }

    @Property(name="skypeForBusinessInactive")
    @JsonIgnore
    public Optional<Long> getSkypeForBusinessInactive() {
        return Optional.ofNullable(skypeForBusinessInactive);
    }

    public Office365ServicesUserCounts withSkypeForBusinessInactive(Long skypeForBusinessInactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("skypeForBusinessInactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.skypeForBusinessInactive = skypeForBusinessInactive;
        return _x;
    }

    @Property(name="yammerActive")
    @JsonIgnore
    public Optional<Long> getYammerActive() {
        return Optional.ofNullable(yammerActive);
    }

    public Office365ServicesUserCounts withYammerActive(Long yammerActive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("yammerActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.yammerActive = yammerActive;
        return _x;
    }

    @Property(name="yammerInactive")
    @JsonIgnore
    public Optional<Long> getYammerInactive() {
        return Optional.ofNullable(yammerInactive);
    }

    public Office365ServicesUserCounts withYammerInactive(Long yammerInactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("yammerInactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.yammerInactive = yammerInactive;
        return _x;
    }

    @Property(name="teamsActive")
    @JsonIgnore
    public Optional<Long> getTeamsActive() {
        return Optional.ofNullable(teamsActive);
    }

    public Office365ServicesUserCounts withTeamsActive(Long teamsActive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("teamsActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.teamsActive = teamsActive;
        return _x;
    }

    @Property(name="teamsInactive")
    @JsonIgnore
    public Optional<Long> getTeamsInactive() {
        return Optional.ofNullable(teamsInactive);
    }

    public Office365ServicesUserCounts withTeamsInactive(Long teamsInactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("teamsInactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.teamsInactive = teamsInactive;
        return _x;
    }

    @Property(name="office365Active")
    @JsonIgnore
    public Optional<Long> getOffice365Active() {
        return Optional.ofNullable(office365Active);
    }

    public Office365ServicesUserCounts withOffice365Active(Long office365Active) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("office365Active");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.office365Active = office365Active;
        return _x;
    }

    @Property(name="office365Inactive")
    @JsonIgnore
    public Optional<Long> getOffice365Inactive() {
        return Optional.ofNullable(office365Inactive);
    }

    public Office365ServicesUserCounts withOffice365Inactive(Long office365Inactive) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("office365Inactive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.office365Inactive = office365Inactive;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public Office365ServicesUserCounts withReportPeriod(String reportPeriod) {
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ServicesUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ServicesUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ServicesUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365ServicesUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365ServicesUserCounts _copy() {
        Office365ServicesUserCounts _x = new Office365ServicesUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.exchangeActive = exchangeActive;
        _x.exchangeInactive = exchangeInactive;
        _x.oneDriveActive = oneDriveActive;
        _x.oneDriveInactive = oneDriveInactive;
        _x.sharePointActive = sharePointActive;
        _x.sharePointInactive = sharePointInactive;
        _x.skypeForBusinessActive = skypeForBusinessActive;
        _x.skypeForBusinessInactive = skypeForBusinessInactive;
        _x.yammerActive = yammerActive;
        _x.yammerInactive = yammerInactive;
        _x.teamsActive = teamsActive;
        _x.teamsInactive = teamsInactive;
        _x.office365Active = office365Active;
        _x.office365Inactive = office365Inactive;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365ServicesUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("exchangeActive=");
        b.append(this.exchangeActive);
        b.append(", ");
        b.append("exchangeInactive=");
        b.append(this.exchangeInactive);
        b.append(", ");
        b.append("oneDriveActive=");
        b.append(this.oneDriveActive);
        b.append(", ");
        b.append("oneDriveInactive=");
        b.append(this.oneDriveInactive);
        b.append(", ");
        b.append("sharePointActive=");
        b.append(this.sharePointActive);
        b.append(", ");
        b.append("sharePointInactive=");
        b.append(this.sharePointInactive);
        b.append(", ");
        b.append("skypeForBusinessActive=");
        b.append(this.skypeForBusinessActive);
        b.append(", ");
        b.append("skypeForBusinessInactive=");
        b.append(this.skypeForBusinessInactive);
        b.append(", ");
        b.append("yammerActive=");
        b.append(this.yammerActive);
        b.append(", ");
        b.append("yammerInactive=");
        b.append(this.yammerInactive);
        b.append(", ");
        b.append("teamsActive=");
        b.append(this.teamsActive);
        b.append(", ");
        b.append("teamsInactive=");
        b.append(this.teamsInactive);
        b.append(", ");
        b.append("office365Active=");
        b.append(this.office365Active);
        b.append(", ");
        b.append("office365Inactive=");
        b.append(this.office365Inactive);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
