package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "mailboxStorageUsedInBytes", 
    "siteStorageUsedInBytes", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class Office365GroupsActivityStorage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365GroupsActivityStorage";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("mailboxStorageUsedInBytes")
    protected Long mailboxStorageUsedInBytes;

    @JsonProperty("siteStorageUsedInBytes")
    protected Long siteStorageUsedInBytes;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected Office365GroupsActivityStorage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365GroupsActivityStorage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Long mailboxStorageUsedInBytes;
        private Long siteStorageUsedInBytes;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder mailboxStorageUsedInBytes(Long mailboxStorageUsedInBytes) {
            this.mailboxStorageUsedInBytes = mailboxStorageUsedInBytes;
            this.changedFields = changedFields.add("mailboxStorageUsedInBytes");
            return this;
        }

        public Builder siteStorageUsedInBytes(Long siteStorageUsedInBytes) {
            this.siteStorageUsedInBytes = siteStorageUsedInBytes;
            this.changedFields = changedFields.add("siteStorageUsedInBytes");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public Office365GroupsActivityStorage build() {
            Office365GroupsActivityStorage _x = new Office365GroupsActivityStorage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.office365GroupsActivityStorage";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.mailboxStorageUsedInBytes = mailboxStorageUsedInBytes;
            _x.siteStorageUsedInBytes = siteStorageUsedInBytes;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365GroupsActivityStorage withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityStorage");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="mailboxStorageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getMailboxStorageUsedInBytes() {
        return Optional.ofNullable(mailboxStorageUsedInBytes);
    }

    public Office365GroupsActivityStorage withMailboxStorageUsedInBytes(Long mailboxStorageUsedInBytes) {
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = changedFields.add("mailboxStorageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityStorage");
        _x.mailboxStorageUsedInBytes = mailboxStorageUsedInBytes;
        return _x;
    }

    @Property(name="siteStorageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getSiteStorageUsedInBytes() {
        return Optional.ofNullable(siteStorageUsedInBytes);
    }

    public Office365GroupsActivityStorage withSiteStorageUsedInBytes(Long siteStorageUsedInBytes) {
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = changedFields.add("siteStorageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityStorage");
        _x.siteStorageUsedInBytes = siteStorageUsedInBytes;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public Office365GroupsActivityStorage withReportDate(LocalDate reportDate) {
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityStorage");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public Office365GroupsActivityStorage withReportPeriod(String reportPeriod) {
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityStorage");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365GroupsActivityStorage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365GroupsActivityStorage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365GroupsActivityStorage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365GroupsActivityStorage _copy() {
        Office365GroupsActivityStorage _x = new Office365GroupsActivityStorage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.mailboxStorageUsedInBytes = mailboxStorageUsedInBytes;
        _x.siteStorageUsedInBytes = siteStorageUsedInBytes;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365GroupsActivityStorage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("mailboxStorageUsedInBytes=");
        b.append(this.mailboxStorageUsedInBytes);
        b.append(", ");
        b.append("siteStorageUsedInBytes=");
        b.append(this.siteStorageUsedInBytes);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
