package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "groupId", 
    "groupDisplayName", 
    "isDeleted", 
    "ownerPrincipalName", 
    "lastActivityDate", 
    "groupType", 
    "memberCount", 
    "externalMemberCount", 
    "exchangeReceivedEmailCount", 
    "sharePointActiveFileCount", 
    "yammerPostedMessageCount", 
    "yammerReadMessageCount", 
    "yammerLikedMessageCount", 
    "exchangeMailboxTotalItemCount", 
    "exchangeMailboxStorageUsedInBytes", 
    "sharePointTotalFileCount", 
    "sharePointSiteStorageUsedInBytes", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class Office365GroupsActivityDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365GroupsActivityDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("groupId")
    protected String groupId;

    @JsonProperty("groupDisplayName")
    protected String groupDisplayName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("ownerPrincipalName")
    protected String ownerPrincipalName;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("groupType")
    protected String groupType;

    @JsonProperty("memberCount")
    protected Long memberCount;

    @JsonProperty("externalMemberCount")
    protected Long externalMemberCount;

    @JsonProperty("exchangeReceivedEmailCount")
    protected Long exchangeReceivedEmailCount;

    @JsonProperty("sharePointActiveFileCount")
    protected Long sharePointActiveFileCount;

    @JsonProperty("yammerPostedMessageCount")
    protected Long yammerPostedMessageCount;

    @JsonProperty("yammerReadMessageCount")
    protected Long yammerReadMessageCount;

    @JsonProperty("yammerLikedMessageCount")
    protected Long yammerLikedMessageCount;

    @JsonProperty("exchangeMailboxTotalItemCount")
    protected Long exchangeMailboxTotalItemCount;

    @JsonProperty("exchangeMailboxStorageUsedInBytes")
    protected Long exchangeMailboxStorageUsedInBytes;

    @JsonProperty("sharePointTotalFileCount")
    protected Long sharePointTotalFileCount;

    @JsonProperty("sharePointSiteStorageUsedInBytes")
    protected Long sharePointSiteStorageUsedInBytes;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected Office365GroupsActivityDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365GroupsActivityDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String groupId;
        private String groupDisplayName;
        private Boolean isDeleted;
        private String ownerPrincipalName;
        private LocalDate lastActivityDate;
        private String groupType;
        private Long memberCount;
        private Long externalMemberCount;
        private Long exchangeReceivedEmailCount;
        private Long sharePointActiveFileCount;
        private Long yammerPostedMessageCount;
        private Long yammerReadMessageCount;
        private Long yammerLikedMessageCount;
        private Long exchangeMailboxTotalItemCount;
        private Long exchangeMailboxStorageUsedInBytes;
        private Long sharePointTotalFileCount;
        private Long sharePointSiteStorageUsedInBytes;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.changedFields = changedFields.add("groupId");
            return this;
        }

        public Builder groupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            this.changedFields = changedFields.add("groupDisplayName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder ownerPrincipalName(String ownerPrincipalName) {
            this.ownerPrincipalName = ownerPrincipalName;
            this.changedFields = changedFields.add("ownerPrincipalName");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder groupType(String groupType) {
            this.groupType = groupType;
            this.changedFields = changedFields.add("groupType");
            return this;
        }

        public Builder memberCount(Long memberCount) {
            this.memberCount = memberCount;
            this.changedFields = changedFields.add("memberCount");
            return this;
        }

        public Builder externalMemberCount(Long externalMemberCount) {
            this.externalMemberCount = externalMemberCount;
            this.changedFields = changedFields.add("externalMemberCount");
            return this;
        }

        public Builder exchangeReceivedEmailCount(Long exchangeReceivedEmailCount) {
            this.exchangeReceivedEmailCount = exchangeReceivedEmailCount;
            this.changedFields = changedFields.add("exchangeReceivedEmailCount");
            return this;
        }

        public Builder sharePointActiveFileCount(Long sharePointActiveFileCount) {
            this.sharePointActiveFileCount = sharePointActiveFileCount;
            this.changedFields = changedFields.add("sharePointActiveFileCount");
            return this;
        }

        public Builder yammerPostedMessageCount(Long yammerPostedMessageCount) {
            this.yammerPostedMessageCount = yammerPostedMessageCount;
            this.changedFields = changedFields.add("yammerPostedMessageCount");
            return this;
        }

        public Builder yammerReadMessageCount(Long yammerReadMessageCount) {
            this.yammerReadMessageCount = yammerReadMessageCount;
            this.changedFields = changedFields.add("yammerReadMessageCount");
            return this;
        }

        public Builder yammerLikedMessageCount(Long yammerLikedMessageCount) {
            this.yammerLikedMessageCount = yammerLikedMessageCount;
            this.changedFields = changedFields.add("yammerLikedMessageCount");
            return this;
        }

        public Builder exchangeMailboxTotalItemCount(Long exchangeMailboxTotalItemCount) {
            this.exchangeMailboxTotalItemCount = exchangeMailboxTotalItemCount;
            this.changedFields = changedFields.add("exchangeMailboxTotalItemCount");
            return this;
        }

        public Builder exchangeMailboxStorageUsedInBytes(Long exchangeMailboxStorageUsedInBytes) {
            this.exchangeMailboxStorageUsedInBytes = exchangeMailboxStorageUsedInBytes;
            this.changedFields = changedFields.add("exchangeMailboxStorageUsedInBytes");
            return this;
        }

        public Builder sharePointTotalFileCount(Long sharePointTotalFileCount) {
            this.sharePointTotalFileCount = sharePointTotalFileCount;
            this.changedFields = changedFields.add("sharePointTotalFileCount");
            return this;
        }

        public Builder sharePointSiteStorageUsedInBytes(Long sharePointSiteStorageUsedInBytes) {
            this.sharePointSiteStorageUsedInBytes = sharePointSiteStorageUsedInBytes;
            this.changedFields = changedFields.add("sharePointSiteStorageUsedInBytes");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public Office365GroupsActivityDetail build() {
            Office365GroupsActivityDetail _x = new Office365GroupsActivityDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.office365GroupsActivityDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.groupId = groupId;
            _x.groupDisplayName = groupDisplayName;
            _x.isDeleted = isDeleted;
            _x.ownerPrincipalName = ownerPrincipalName;
            _x.lastActivityDate = lastActivityDate;
            _x.groupType = groupType;
            _x.memberCount = memberCount;
            _x.externalMemberCount = externalMemberCount;
            _x.exchangeReceivedEmailCount = exchangeReceivedEmailCount;
            _x.sharePointActiveFileCount = sharePointActiveFileCount;
            _x.yammerPostedMessageCount = yammerPostedMessageCount;
            _x.yammerReadMessageCount = yammerReadMessageCount;
            _x.yammerLikedMessageCount = yammerLikedMessageCount;
            _x.exchangeMailboxTotalItemCount = exchangeMailboxTotalItemCount;
            _x.exchangeMailboxStorageUsedInBytes = exchangeMailboxStorageUsedInBytes;
            _x.sharePointTotalFileCount = sharePointTotalFileCount;
            _x.sharePointSiteStorageUsedInBytes = sharePointSiteStorageUsedInBytes;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365GroupsActivityDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="groupId")
    @JsonIgnore
    public Optional<String> getGroupId() {
        return Optional.ofNullable(groupId);
    }

    public Office365GroupsActivityDetail withGroupId(String groupId) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("groupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.groupId = groupId;
        return _x;
    }

    @Property(name="groupDisplayName")
    @JsonIgnore
    public Optional<String> getGroupDisplayName() {
        return Optional.ofNullable(groupDisplayName);
    }

    public Office365GroupsActivityDetail withGroupDisplayName(String groupDisplayName) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("groupDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.groupDisplayName = groupDisplayName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public Office365GroupsActivityDetail withIsDeleted(Boolean isDeleted) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="ownerPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerPrincipalName() {
        return Optional.ofNullable(ownerPrincipalName);
    }

    public Office365GroupsActivityDetail withOwnerPrincipalName(String ownerPrincipalName) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("ownerPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.ownerPrincipalName = ownerPrincipalName;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public Office365GroupsActivityDetail withLastActivityDate(LocalDate lastActivityDate) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="groupType")
    @JsonIgnore
    public Optional<String> getGroupType() {
        return Optional.ofNullable(groupType);
    }

    public Office365GroupsActivityDetail withGroupType(String groupType) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("groupType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.groupType = groupType;
        return _x;
    }

    @Property(name="memberCount")
    @JsonIgnore
    public Optional<Long> getMemberCount() {
        return Optional.ofNullable(memberCount);
    }

    public Office365GroupsActivityDetail withMemberCount(Long memberCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("memberCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.memberCount = memberCount;
        return _x;
    }

    @Property(name="externalMemberCount")
    @JsonIgnore
    public Optional<Long> getExternalMemberCount() {
        return Optional.ofNullable(externalMemberCount);
    }

    public Office365GroupsActivityDetail withExternalMemberCount(Long externalMemberCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("externalMemberCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.externalMemberCount = externalMemberCount;
        return _x;
    }

    @Property(name="exchangeReceivedEmailCount")
    @JsonIgnore
    public Optional<Long> getExchangeReceivedEmailCount() {
        return Optional.ofNullable(exchangeReceivedEmailCount);
    }

    public Office365GroupsActivityDetail withExchangeReceivedEmailCount(Long exchangeReceivedEmailCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("exchangeReceivedEmailCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.exchangeReceivedEmailCount = exchangeReceivedEmailCount;
        return _x;
    }

    @Property(name="sharePointActiveFileCount")
    @JsonIgnore
    public Optional<Long> getSharePointActiveFileCount() {
        return Optional.ofNullable(sharePointActiveFileCount);
    }

    public Office365GroupsActivityDetail withSharePointActiveFileCount(Long sharePointActiveFileCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("sharePointActiveFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.sharePointActiveFileCount = sharePointActiveFileCount;
        return _x;
    }

    @Property(name="yammerPostedMessageCount")
    @JsonIgnore
    public Optional<Long> getYammerPostedMessageCount() {
        return Optional.ofNullable(yammerPostedMessageCount);
    }

    public Office365GroupsActivityDetail withYammerPostedMessageCount(Long yammerPostedMessageCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("yammerPostedMessageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.yammerPostedMessageCount = yammerPostedMessageCount;
        return _x;
    }

    @Property(name="yammerReadMessageCount")
    @JsonIgnore
    public Optional<Long> getYammerReadMessageCount() {
        return Optional.ofNullable(yammerReadMessageCount);
    }

    public Office365GroupsActivityDetail withYammerReadMessageCount(Long yammerReadMessageCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("yammerReadMessageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.yammerReadMessageCount = yammerReadMessageCount;
        return _x;
    }

    @Property(name="yammerLikedMessageCount")
    @JsonIgnore
    public Optional<Long> getYammerLikedMessageCount() {
        return Optional.ofNullable(yammerLikedMessageCount);
    }

    public Office365GroupsActivityDetail withYammerLikedMessageCount(Long yammerLikedMessageCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("yammerLikedMessageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.yammerLikedMessageCount = yammerLikedMessageCount;
        return _x;
    }

    @Property(name="exchangeMailboxTotalItemCount")
    @JsonIgnore
    public Optional<Long> getExchangeMailboxTotalItemCount() {
        return Optional.ofNullable(exchangeMailboxTotalItemCount);
    }

    public Office365GroupsActivityDetail withExchangeMailboxTotalItemCount(Long exchangeMailboxTotalItemCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("exchangeMailboxTotalItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.exchangeMailboxTotalItemCount = exchangeMailboxTotalItemCount;
        return _x;
    }

    @Property(name="exchangeMailboxStorageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getExchangeMailboxStorageUsedInBytes() {
        return Optional.ofNullable(exchangeMailboxStorageUsedInBytes);
    }

    public Office365GroupsActivityDetail withExchangeMailboxStorageUsedInBytes(Long exchangeMailboxStorageUsedInBytes) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("exchangeMailboxStorageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.exchangeMailboxStorageUsedInBytes = exchangeMailboxStorageUsedInBytes;
        return _x;
    }

    @Property(name="sharePointTotalFileCount")
    @JsonIgnore
    public Optional<Long> getSharePointTotalFileCount() {
        return Optional.ofNullable(sharePointTotalFileCount);
    }

    public Office365GroupsActivityDetail withSharePointTotalFileCount(Long sharePointTotalFileCount) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("sharePointTotalFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.sharePointTotalFileCount = sharePointTotalFileCount;
        return _x;
    }

    @Property(name="sharePointSiteStorageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getSharePointSiteStorageUsedInBytes() {
        return Optional.ofNullable(sharePointSiteStorageUsedInBytes);
    }

    public Office365GroupsActivityDetail withSharePointSiteStorageUsedInBytes(Long sharePointSiteStorageUsedInBytes) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("sharePointSiteStorageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.sharePointSiteStorageUsedInBytes = sharePointSiteStorageUsedInBytes;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public Office365GroupsActivityDetail withReportPeriod(String reportPeriod) {
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365GroupsActivityDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365GroupsActivityDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365GroupsActivityDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365GroupsActivityDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365GroupsActivityDetail _copy() {
        Office365GroupsActivityDetail _x = new Office365GroupsActivityDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.groupId = groupId;
        _x.groupDisplayName = groupDisplayName;
        _x.isDeleted = isDeleted;
        _x.ownerPrincipalName = ownerPrincipalName;
        _x.lastActivityDate = lastActivityDate;
        _x.groupType = groupType;
        _x.memberCount = memberCount;
        _x.externalMemberCount = externalMemberCount;
        _x.exchangeReceivedEmailCount = exchangeReceivedEmailCount;
        _x.sharePointActiveFileCount = sharePointActiveFileCount;
        _x.yammerPostedMessageCount = yammerPostedMessageCount;
        _x.yammerReadMessageCount = yammerReadMessageCount;
        _x.yammerLikedMessageCount = yammerLikedMessageCount;
        _x.exchangeMailboxTotalItemCount = exchangeMailboxTotalItemCount;
        _x.exchangeMailboxStorageUsedInBytes = exchangeMailboxStorageUsedInBytes;
        _x.sharePointTotalFileCount = sharePointTotalFileCount;
        _x.sharePointSiteStorageUsedInBytes = sharePointSiteStorageUsedInBytes;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365GroupsActivityDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("groupId=");
        b.append(this.groupId);
        b.append(", ");
        b.append("groupDisplayName=");
        b.append(this.groupDisplayName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("ownerPrincipalName=");
        b.append(this.ownerPrincipalName);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("groupType=");
        b.append(this.groupType);
        b.append(", ");
        b.append("memberCount=");
        b.append(this.memberCount);
        b.append(", ");
        b.append("externalMemberCount=");
        b.append(this.externalMemberCount);
        b.append(", ");
        b.append("exchangeReceivedEmailCount=");
        b.append(this.exchangeReceivedEmailCount);
        b.append(", ");
        b.append("sharePointActiveFileCount=");
        b.append(this.sharePointActiveFileCount);
        b.append(", ");
        b.append("yammerPostedMessageCount=");
        b.append(this.yammerPostedMessageCount);
        b.append(", ");
        b.append("yammerReadMessageCount=");
        b.append(this.yammerReadMessageCount);
        b.append(", ");
        b.append("yammerLikedMessageCount=");
        b.append(this.yammerLikedMessageCount);
        b.append(", ");
        b.append("exchangeMailboxTotalItemCount=");
        b.append(this.exchangeMailboxTotalItemCount);
        b.append(", ");
        b.append("exchangeMailboxStorageUsedInBytes=");
        b.append(this.exchangeMailboxStorageUsedInBytes);
        b.append(", ");
        b.append("sharePointTotalFileCount=");
        b.append(this.sharePointTotalFileCount);
        b.append(", ");
        b.append("sharePointSiteStorageUsedInBytes=");
        b.append(this.sharePointSiteStorageUsedInBytes);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
