package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserActivationCounts;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "displayName", 
    "userActivationCounts"})
@JsonInclude(Include.NON_NULL)
public class Office365ActivationsUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365ActivationsUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("userActivationCounts")
    protected List<UserActivationCounts> userActivationCounts;

    @JsonProperty("userActivationCounts@nextLink")
    protected String userActivationCountsNextLink;

    protected Office365ActivationsUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365ActivationsUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private String displayName;
        private List<UserActivationCounts> userActivationCounts;
        private String userActivationCountsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder userActivationCounts(List<UserActivationCounts> userActivationCounts) {
            this.userActivationCounts = userActivationCounts;
            this.changedFields = changedFields.add("userActivationCounts");
            return this;
        }

        public Builder userActivationCounts(UserActivationCounts... userActivationCounts) {
            return userActivationCounts(Arrays.asList(userActivationCounts));
        }

        public Builder userActivationCountsNextLink(String userActivationCountsNextLink) {
            this.userActivationCountsNextLink = userActivationCountsNextLink;
            this.changedFields = changedFields.add("userActivationCounts");
            return this;
        }

        public Office365ActivationsUserDetail build() {
            Office365ActivationsUserDetail _x = new Office365ActivationsUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.office365ActivationsUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.displayName = displayName;
            _x.userActivationCounts = userActivationCounts;
            _x.userActivationCountsNextLink = userActivationCountsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365ActivationsUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365ActivationsUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public Office365ActivationsUserDetail withUserPrincipalName(String userPrincipalName) {
        Office365ActivationsUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Office365ActivationsUserDetail withDisplayName(String displayName) {
        Office365ActivationsUserDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="userActivationCounts")
    @JsonIgnore
    public CollectionPage<UserActivationCounts> getUserActivationCounts() {
        return new CollectionPage<UserActivationCounts>(contextPath, UserActivationCounts.class, userActivationCounts, Optional.ofNullable(userActivationCountsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userActivationCounts")
    @JsonIgnore
    public CollectionPage<UserActivationCounts> getUserActivationCounts(HttpRequestOptions options) {
        return new CollectionPage<UserActivationCounts>(contextPath, UserActivationCounts.class, userActivationCounts, Optional.ofNullable(userActivationCountsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActivationsUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365ActivationsUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActivationsUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365ActivationsUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365ActivationsUserDetail _copy() {
        Office365ActivationsUserDetail _x = new Office365ActivationsUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.displayName = displayName;
        _x.userActivationCounts = userActivationCounts;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365ActivationsUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("userActivationCounts=");
        b.append(this.userActivationCounts);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
