package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "productType", 
    "assigned", 
    "activated", 
    "sharedComputerActivation"})
@JsonInclude(Include.NON_NULL)
public class Office365ActivationsUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365ActivationsUserCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("productType")
    protected String productType;

    @JsonProperty("assigned")
    protected Long assigned;

    @JsonProperty("activated")
    protected Long activated;

    @JsonProperty("sharedComputerActivation")
    protected Long sharedComputerActivation;

    protected Office365ActivationsUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365ActivationsUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String productType;
        private Long assigned;
        private Long activated;
        private Long sharedComputerActivation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            this.changedFields = changedFields.add("productType");
            return this;
        }

        public Builder assigned(Long assigned) {
            this.assigned = assigned;
            this.changedFields = changedFields.add("assigned");
            return this;
        }

        public Builder activated(Long activated) {
            this.activated = activated;
            this.changedFields = changedFields.add("activated");
            return this;
        }

        public Builder sharedComputerActivation(Long sharedComputerActivation) {
            this.sharedComputerActivation = sharedComputerActivation;
            this.changedFields = changedFields.add("sharedComputerActivation");
            return this;
        }

        public Office365ActivationsUserCounts build() {
            Office365ActivationsUserCounts _x = new Office365ActivationsUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.office365ActivationsUserCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.productType = productType;
            _x.assigned = assigned;
            _x.activated = activated;
            _x.sharedComputerActivation = sharedComputerActivation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365ActivationsUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="productType")
    @JsonIgnore
    public Optional<String> getProductType() {
        return Optional.ofNullable(productType);
    }

    public Office365ActivationsUserCounts withProductType(String productType) {
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("productType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserCounts");
        _x.productType = productType;
        return _x;
    }

    @Property(name="assigned")
    @JsonIgnore
    public Optional<Long> getAssigned() {
        return Optional.ofNullable(assigned);
    }

    public Office365ActivationsUserCounts withAssigned(Long assigned) {
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("assigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserCounts");
        _x.assigned = assigned;
        return _x;
    }

    @Property(name="activated")
    @JsonIgnore
    public Optional<Long> getActivated() {
        return Optional.ofNullable(activated);
    }

    public Office365ActivationsUserCounts withActivated(Long activated) {
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("activated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserCounts");
        _x.activated = activated;
        return _x;
    }

    @Property(name="sharedComputerActivation")
    @JsonIgnore
    public Optional<Long> getSharedComputerActivation() {
        return Optional.ofNullable(sharedComputerActivation);
    }

    public Office365ActivationsUserCounts withSharedComputerActivation(Long sharedComputerActivation) {
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("sharedComputerActivation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationsUserCounts");
        _x.sharedComputerActivation = sharedComputerActivation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActivationsUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActivationsUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365ActivationsUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365ActivationsUserCounts _copy() {
        Office365ActivationsUserCounts _x = new Office365ActivationsUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.productType = productType;
        _x.assigned = assigned;
        _x.activated = activated;
        _x.sharedComputerActivation = sharedComputerActivation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365ActivationsUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("productType=");
        b.append(this.productType);
        b.append(", ");
        b.append("assigned=");
        b.append(this.assigned);
        b.append(", ");
        b.append("activated=");
        b.append(this.activated);
        b.append(", ");
        b.append("sharedComputerActivation=");
        b.append(this.sharedComputerActivation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
