package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "productType", 
    "windows", 
    "mac", 
    "android", 
    "ios", 
    "windows10Mobile"})
@JsonInclude(Include.NON_NULL)
public class Office365ActivationCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365ActivationCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("productType")
    protected String productType;

    @JsonProperty("windows")
    protected Long windows;

    @JsonProperty("mac")
    protected Long mac;

    @JsonProperty("android")
    protected Long android;

    @JsonProperty("ios")
    protected Long ios;

    @JsonProperty("windows10Mobile")
    protected Long windows10Mobile;

    protected Office365ActivationCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365ActivationCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String productType;
        private Long windows;
        private Long mac;
        private Long android;
        private Long ios;
        private Long windows10Mobile;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            this.changedFields = changedFields.add("productType");
            return this;
        }

        public Builder windows(Long windows) {
            this.windows = windows;
            this.changedFields = changedFields.add("windows");
            return this;
        }

        public Builder mac(Long mac) {
            this.mac = mac;
            this.changedFields = changedFields.add("mac");
            return this;
        }

        public Builder android(Long android) {
            this.android = android;
            this.changedFields = changedFields.add("android");
            return this;
        }

        public Builder ios(Long ios) {
            this.ios = ios;
            this.changedFields = changedFields.add("ios");
            return this;
        }

        public Builder windows10Mobile(Long windows10Mobile) {
            this.windows10Mobile = windows10Mobile;
            this.changedFields = changedFields.add("windows10Mobile");
            return this;
        }

        public Office365ActivationCounts build() {
            Office365ActivationCounts _x = new Office365ActivationCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.office365ActivationCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.productType = productType;
            _x.windows = windows;
            _x.mac = mac;
            _x.android = android;
            _x.ios = ios;
            _x.windows10Mobile = windows10Mobile;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365ActivationCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="productType")
    @JsonIgnore
    public Optional<String> getProductType() {
        return Optional.ofNullable(productType);
    }

    public Office365ActivationCounts withProductType(String productType) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("productType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.productType = productType;
        return _x;
    }

    @Property(name="windows")
    @JsonIgnore
    public Optional<Long> getWindows() {
        return Optional.ofNullable(windows);
    }

    public Office365ActivationCounts withWindows(Long windows) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("windows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.windows = windows;
        return _x;
    }

    @Property(name="mac")
    @JsonIgnore
    public Optional<Long> getMac() {
        return Optional.ofNullable(mac);
    }

    public Office365ActivationCounts withMac(Long mac) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("mac");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.mac = mac;
        return _x;
    }

    @Property(name="android")
    @JsonIgnore
    public Optional<Long> getAndroid() {
        return Optional.ofNullable(android);
    }

    public Office365ActivationCounts withAndroid(Long android) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("android");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.android = android;
        return _x;
    }

    @Property(name="ios")
    @JsonIgnore
    public Optional<Long> getIos() {
        return Optional.ofNullable(ios);
    }

    public Office365ActivationCounts withIos(Long ios) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("ios");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.ios = ios;
        return _x;
    }

    @Property(name="windows10Mobile")
    @JsonIgnore
    public Optional<Long> getWindows10Mobile() {
        return Optional.ofNullable(windows10Mobile);
    }

    public Office365ActivationCounts withWindows10Mobile(Long windows10Mobile) {
        Office365ActivationCounts _x = _copy();
        _x.changedFields = changedFields.add("windows10Mobile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActivationCounts");
        _x.windows10Mobile = windows10Mobile;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActivationCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365ActivationCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActivationCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365ActivationCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365ActivationCounts _copy() {
        Office365ActivationCounts _x = new Office365ActivationCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.productType = productType;
        _x.windows = windows;
        _x.mac = mac;
        _x.android = android;
        _x.ios = ios;
        _x.windows10Mobile = windows10Mobile;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365ActivationCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("productType=");
        b.append(this.productType);
        b.append(", ");
        b.append("windows=");
        b.append(this.windows);
        b.append(", ");
        b.append("mac=");
        b.append(this.mac);
        b.append(", ");
        b.append("android=");
        b.append(this.android);
        b.append(", ");
        b.append("ios=");
        b.append(this.ios);
        b.append(", ");
        b.append("windows10Mobile=");
        b.append(this.windows10Mobile);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
