package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "clientId", 
    "consentType", 
    "expiryTime", 
    "principalId", 
    "resourceId", 
    "scope", 
    "startTime"})
@JsonInclude(Include.NON_NULL)
public class OAuth2PermissionGrant extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.oAuth2PermissionGrant";
    }

    @JsonProperty("clientId")
    protected String clientId;

    @JsonProperty("consentType")
    protected String consentType;

    @JsonProperty("expiryTime")
    protected OffsetDateTime expiryTime;

    @JsonProperty("principalId")
    protected String principalId;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("scope")
    protected String scope;

    @JsonProperty("startTime")
    protected OffsetDateTime startTime;

    protected OAuth2PermissionGrant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOAuth2PermissionGrant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String clientId;
        private String consentType;
        private OffsetDateTime expiryTime;
        private String principalId;
        private String resourceId;
        private String scope;
        private OffsetDateTime startTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder consentType(String consentType) {
            this.consentType = consentType;
            this.changedFields = changedFields.add("consentType");
            return this;
        }

        public Builder expiryTime(OffsetDateTime expiryTime) {
            this.expiryTime = expiryTime;
            this.changedFields = changedFields.add("expiryTime");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            this.changedFields = changedFields.add("startTime");
            return this;
        }

        public OAuth2PermissionGrant build() {
            OAuth2PermissionGrant _x = new OAuth2PermissionGrant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.oAuth2PermissionGrant";
            _x.id = id;
            _x.clientId = clientId;
            _x.consentType = consentType;
            _x.expiryTime = expiryTime;
            _x.principalId = principalId;
            _x.resourceId = resourceId;
            _x.scope = scope;
            _x.startTime = startTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="clientId")
    @JsonIgnore
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    public OAuth2PermissionGrant withClientId(String clientId) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("clientId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.clientId = clientId;
        return _x;
    }

    @Property(name="consentType")
    @JsonIgnore
    public Optional<String> getConsentType() {
        return Optional.ofNullable(consentType);
    }

    public OAuth2PermissionGrant withConsentType(String consentType) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("consentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.consentType = consentType;
        return _x;
    }

    @Property(name="expiryTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpiryTime() {
        return Optional.ofNullable(expiryTime);
    }

    public OAuth2PermissionGrant withExpiryTime(OffsetDateTime expiryTime) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("expiryTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.expiryTime = expiryTime;
        return _x;
    }

    @Property(name="principalId")
    @JsonIgnore
    public Optional<String> getPrincipalId() {
        return Optional.ofNullable(principalId);
    }

    public OAuth2PermissionGrant withPrincipalId(String principalId) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("principalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.principalId = principalId;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public OAuth2PermissionGrant withResourceId(String resourceId) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<String> getScope() {
        return Optional.ofNullable(scope);
    }

    public OAuth2PermissionGrant withScope(String scope) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.scope = scope;
        return _x;
    }

    @Property(name="startTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    public OAuth2PermissionGrant withStartTime(OffsetDateTime startTime) {
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("startTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oAuth2PermissionGrant");
        _x.startTime = startTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OAuth2PermissionGrant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OAuth2PermissionGrant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OAuth2PermissionGrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OAuth2PermissionGrant _copy() {
        OAuth2PermissionGrant _x = new OAuth2PermissionGrant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.clientId = clientId;
        _x.consentType = consentType;
        _x.expiryTime = expiryTime;
        _x.principalId = principalId;
        _x.resourceId = resourceId;
        _x.scope = scope;
        _x.startTime = startTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OAuth2PermissionGrant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("consentType=");
        b.append(this.consentType);
        b.append(", ");
        b.append("expiryTime=");
        b.append(this.expiryTime);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("startTime=");
        b.append(this.startTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
