package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.LocalizedNotificationMessageCollectionRequest;
import odata.msgraph.client.beta.enums.NotificationTemplateBrandingOptions;


/**
 * <i>“Notification messages are messages that are sent to end users who are determined
 * to be not-compliant with the compliance policies defined by the administrator.
 * Administrators choose notifications and configure them in the Intune Admin
 * Console using the compliance policy creation page under the “Actions for non-
 * compliance” section. Use the notificationMessageTemplate object to create your
 * own custom notifications for administrators to choose while configuring actions
 * for non-compliance.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastModifiedDateTime", 
    "displayName", 
    "defaultLocale", 
    "brandingOptions", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class NotificationMessageTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.notificationMessageTemplate";
    }

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("defaultLocale")
    protected String defaultLocale;

    @JsonProperty("brandingOptions")
    protected NotificationTemplateBrandingOptions brandingOptions;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected NotificationMessageTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNotificationMessageTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private String displayName;
        private String defaultLocale;
        private NotificationTemplateBrandingOptions brandingOptions;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“DateTime the object was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Display name for the Notification Message Template.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The default locale to fallback onto when the requested locale is not available.”</i>
         * 
         * @param defaultLocale
         *            value of {@code defaultLocale} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultLocale(String defaultLocale) {
            this.defaultLocale = defaultLocale;
            this.changedFields = changedFields.add("defaultLocale");
            return this;
        }

        /**
         * <i>“The Message Template Branding Options. Branding is defined in the Intune Admin
         * Console.”</i>
         * 
         * @param brandingOptions
         *            value of {@code brandingOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder brandingOptions(NotificationTemplateBrandingOptions brandingOptions) {
            this.brandingOptions = brandingOptions;
            this.changedFields = changedFields.add("brandingOptions");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public NotificationMessageTemplate build() {
            NotificationMessageTemplate _x = new NotificationMessageTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.notificationMessageTemplate";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.displayName = displayName;
            _x.defaultLocale = defaultLocale;
            _x.brandingOptions = brandingOptions;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public NotificationMessageTemplate withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        NotificationMessageTemplate _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notificationMessageTemplate");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Display name for the Notification Message Template.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name for the Notification Message Template.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public NotificationMessageTemplate withDisplayName(String displayName) {
        NotificationMessageTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notificationMessageTemplate");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The default locale to fallback onto when the requested locale is not available.”</i>
     * 
     * @return property defaultLocale
     */
    @Property(name="defaultLocale")
    @JsonIgnore
    public Optional<String> getDefaultLocale() {
        return Optional.ofNullable(defaultLocale);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultLocale}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The default locale to fallback onto when the requested locale is not available.”</i>
     * 
     * @param defaultLocale
     *            new value of {@code defaultLocale} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultLocale} field changed
     */
    public NotificationMessageTemplate withDefaultLocale(String defaultLocale) {
        NotificationMessageTemplate _x = _copy();
        _x.changedFields = changedFields.add("defaultLocale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notificationMessageTemplate");
        _x.defaultLocale = defaultLocale;
        return _x;
    }

    /**
     * <i>“The Message Template Branding Options. Branding is defined in the Intune Admin
     * Console.”</i>
     * 
     * @return property brandingOptions
     */
    @Property(name="brandingOptions")
    @JsonIgnore
    public Optional<NotificationTemplateBrandingOptions> getBrandingOptions() {
        return Optional.ofNullable(brandingOptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code brandingOptions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Message Template Branding Options. Branding is defined in the Intune Admin
     * Console.”</i>
     * 
     * @param brandingOptions
     *            new value of {@code brandingOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code brandingOptions} field changed
     */
    public NotificationMessageTemplate withBrandingOptions(NotificationTemplateBrandingOptions brandingOptions) {
        NotificationMessageTemplate _x = _copy();
        _x.changedFields = changedFields.add("brandingOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notificationMessageTemplate");
        _x.brandingOptions = brandingOptions;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The list of localized messages for this Notification Message Template.”</i>
     * 
     * @return navigational property localizedNotificationMessages
     */
    @NavigationProperty(name="localizedNotificationMessages")
    @JsonIgnore
    public LocalizedNotificationMessageCollectionRequest getLocalizedNotificationMessages() {
        return new LocalizedNotificationMessageCollectionRequest(
                        contextPath.addSegment("localizedNotificationMessages"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NotificationMessageTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        NotificationMessageTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NotificationMessageTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        NotificationMessageTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private NotificationMessageTemplate _copy() {
        NotificationMessageTemplate _x = new NotificationMessageTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.displayName = displayName;
        _x.defaultLocale = defaultLocale;
        _x.brandingOptions = brandingOptions;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Action(name = "sendTestMessage")
    @JsonIgnore
    public ActionRequestNoReturn sendTestMessage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendTestMessage"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NotificationMessageTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("defaultLocale=");
        b.append(this.defaultLocale);
        b.append(", ");
        b.append("brandingOptions=");
        b.append(this.brandingOptions);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
