package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PayloadTypes;
import odata.msgraph.client.beta.complex.TargetPolicyEndpoints;
import odata.msgraph.client.beta.enums.Priority;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "targetHostName", 
    "expirationDateTime", 
    "payload", 
    "displayTimeToLive", 
    "priority", 
    "groupName", 
    "targetPolicy"})
@JsonInclude(Include.NON_NULL)
public class Notification extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.notification";
    }

    @JsonProperty("targetHostName")
    protected String targetHostName;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("payload")
    protected PayloadTypes payload;

    @JsonProperty("displayTimeToLive")
    protected Integer displayTimeToLive;

    @JsonProperty("priority")
    protected Priority priority;

    @JsonProperty("groupName")
    protected String groupName;

    @JsonProperty("targetPolicy")
    protected TargetPolicyEndpoints targetPolicy;

    protected Notification() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNotification() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String targetHostName;
        private OffsetDateTime expirationDateTime;
        private PayloadTypes payload;
        private Integer displayTimeToLive;
        private Priority priority;
        private String groupName;
        private TargetPolicyEndpoints targetPolicy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder targetHostName(String targetHostName) {
            this.targetHostName = targetHostName;
            this.changedFields = changedFields.add("targetHostName");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder payload(PayloadTypes payload) {
            this.payload = payload;
            this.changedFields = changedFields.add("payload");
            return this;
        }

        public Builder displayTimeToLive(Integer displayTimeToLive) {
            this.displayTimeToLive = displayTimeToLive;
            this.changedFields = changedFields.add("displayTimeToLive");
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.changedFields = changedFields.add("groupName");
            return this;
        }

        public Builder targetPolicy(TargetPolicyEndpoints targetPolicy) {
            this.targetPolicy = targetPolicy;
            this.changedFields = changedFields.add("targetPolicy");
            return this;
        }

        public Notification build() {
            Notification _x = new Notification();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.notification";
            _x.id = id;
            _x.targetHostName = targetHostName;
            _x.expirationDateTime = expirationDateTime;
            _x.payload = payload;
            _x.displayTimeToLive = displayTimeToLive;
            _x.priority = priority;
            _x.groupName = groupName;
            _x.targetPolicy = targetPolicy;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="targetHostName")
    @JsonIgnore
    public Optional<String> getTargetHostName() {
        return Optional.ofNullable(targetHostName);
    }

    public Notification withTargetHostName(String targetHostName) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("targetHostName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.targetHostName = targetHostName;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public Notification withExpirationDateTime(OffsetDateTime expirationDateTime) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="payload")
    @JsonIgnore
    public Optional<PayloadTypes> getPayload() {
        return Optional.ofNullable(payload);
    }

    public Notification withPayload(PayloadTypes payload) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("payload");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.payload = payload;
        return _x;
    }

    @Property(name="displayTimeToLive")
    @JsonIgnore
    public Optional<Integer> getDisplayTimeToLive() {
        return Optional.ofNullable(displayTimeToLive);
    }

    public Notification withDisplayTimeToLive(Integer displayTimeToLive) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("displayTimeToLive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.displayTimeToLive = displayTimeToLive;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Priority> getPriority() {
        return Optional.ofNullable(priority);
    }

    public Notification withPriority(Priority priority) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.priority = priority;
        return _x;
    }

    @Property(name="groupName")
    @JsonIgnore
    public Optional<String> getGroupName() {
        return Optional.ofNullable(groupName);
    }

    public Notification withGroupName(String groupName) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("groupName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.groupName = groupName;
        return _x;
    }

    @Property(name="targetPolicy")
    @JsonIgnore
    public Optional<TargetPolicyEndpoints> getTargetPolicy() {
        return Optional.ofNullable(targetPolicy);
    }

    public Notification withTargetPolicy(TargetPolicyEndpoints targetPolicy) {
        Notification _x = _copy();
        _x.changedFields = changedFields.add("targetPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notification");
        _x.targetPolicy = targetPolicy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Notification patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Notification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Notification put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Notification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Notification _copy() {
        Notification _x = new Notification();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.targetHostName = targetHostName;
        _x.expirationDateTime = expirationDateTime;
        _x.payload = payload;
        _x.displayTimeToLive = displayTimeToLive;
        _x.priority = priority;
        _x.groupName = groupName;
        _x.targetPolicy = targetPolicy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Notification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetHostName=");
        b.append(this.targetHostName);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("payload=");
        b.append(this.payload);
        b.append(", ");
        b.append("displayTimeToLive=");
        b.append(this.displayTimeToLive);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("groupName=");
        b.append(this.groupName);
        b.append(", ");
        b.append("targetPolicy=");
        b.append(this.targetPolicy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
