package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.NotebookLinks;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;
import odata.msgraph.client.beta.enums.OnenoteUserRole;

@JsonPropertyOrder({
    "@odata.type", 
    "isDefault", 
    "userRole", 
    "isShared", 
    "sectionsUrl", 
    "sectionGroupsUrl", 
    "links"})
@JsonInclude(Include.NON_NULL)
public class Notebook extends OnenoteEntityHierarchyModel implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.notebook";
    }

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("userRole")
    protected OnenoteUserRole userRole;

    @JsonProperty("isShared")
    protected Boolean isShared;

    @JsonProperty("sectionsUrl")
    protected String sectionsUrl;

    @JsonProperty("sectionGroupsUrl")
    protected String sectionGroupsUrl;

    @JsonProperty("links")
    protected NotebookLinks links;

    protected Notebook() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNotebook() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String self;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private IdentitySet createdBy;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isDefault;
        private OnenoteUserRole userRole;
        private Boolean isShared;
        private String sectionsUrl;
        private String sectionGroupsUrl;
        private NotebookLinks links;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.changedFields = changedFields.add("self");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder userRole(OnenoteUserRole userRole) {
            this.userRole = userRole;
            this.changedFields = changedFields.add("userRole");
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            this.changedFields = changedFields.add("isShared");
            return this;
        }

        public Builder sectionsUrl(String sectionsUrl) {
            this.sectionsUrl = sectionsUrl;
            this.changedFields = changedFields.add("sectionsUrl");
            return this;
        }

        public Builder sectionGroupsUrl(String sectionGroupsUrl) {
            this.sectionGroupsUrl = sectionGroupsUrl;
            this.changedFields = changedFields.add("sectionGroupsUrl");
            return this;
        }

        public Builder links(NotebookLinks links) {
            this.links = links;
            this.changedFields = changedFields.add("links");
            return this;
        }

        public Notebook build() {
            Notebook _x = new Notebook();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.notebook";
            _x.id = id;
            _x.self = self;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.createdBy = createdBy;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isDefault = isDefault;
            _x.userRole = userRole;
            _x.isShared = isShared;
            _x.sectionsUrl = sectionsUrl;
            _x.sectionGroupsUrl = sectionGroupsUrl;
            _x.links = links;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public Notebook withIsDefault(Boolean isDefault) {
        Notebook _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebook");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="userRole")
    @JsonIgnore
    public Optional<OnenoteUserRole> getUserRole() {
        return Optional.ofNullable(userRole);
    }

    public Notebook withUserRole(OnenoteUserRole userRole) {
        Notebook _x = _copy();
        _x.changedFields = changedFields.add("userRole");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebook");
        _x.userRole = userRole;
        return _x;
    }

    @Property(name="isShared")
    @JsonIgnore
    public Optional<Boolean> getIsShared() {
        return Optional.ofNullable(isShared);
    }

    public Notebook withIsShared(Boolean isShared) {
        Notebook _x = _copy();
        _x.changedFields = changedFields.add("isShared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebook");
        _x.isShared = isShared;
        return _x;
    }

    @Property(name="sectionsUrl")
    @JsonIgnore
    public Optional<String> getSectionsUrl() {
        return Optional.ofNullable(sectionsUrl);
    }

    public Notebook withSectionsUrl(String sectionsUrl) {
        Notebook _x = _copy();
        _x.changedFields = changedFields.add("sectionsUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebook");
        _x.sectionsUrl = sectionsUrl;
        return _x;
    }

    @Property(name="sectionGroupsUrl")
    @JsonIgnore
    public Optional<String> getSectionGroupsUrl() {
        return Optional.ofNullable(sectionGroupsUrl);
    }

    public Notebook withSectionGroupsUrl(String sectionGroupsUrl) {
        Notebook _x = _copy();
        _x.changedFields = changedFields.add("sectionGroupsUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebook");
        _x.sectionGroupsUrl = sectionGroupsUrl;
        return _x;
    }

    @Property(name="links")
    @JsonIgnore
    public Optional<NotebookLinks> getLinks() {
        return Optional.ofNullable(links);
    }

    public Notebook withLinks(NotebookLinks links) {
        Notebook _x = _copy();
        _x.changedFields = changedFields.add("links");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebook");
        _x.links = links;
        return _x;
    }

    @NavigationProperty(name="sections")
    @JsonIgnore
    public OnenoteSectionCollectionRequest getSections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"));
    }

    @NavigationProperty(name="sectionGroups")
    @JsonIgnore
    public SectionGroupCollectionRequest getSectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Notebook patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Notebook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Notebook put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Notebook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Notebook _copy() {
        Notebook _x = new Notebook();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.self = self;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.createdBy = createdBy;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isDefault = isDefault;
        _x.userRole = userRole;
        _x.isShared = isShared;
        _x.sectionsUrl = sectionsUrl;
        _x.sectionGroupsUrl = sectionGroupsUrl;
        _x.links = links;
        return _x;
    }

    @Action(name = "copyNotebook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyNotebook(String groupId, String renameAs, String notebookFolder, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("notebookFolder", "Edm.String", Checks.checkIsAscii(notebookFolder))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyNotebook"), OnenoteOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Notebook[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("self=");
        b.append(this.self);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("userRole=");
        b.append(this.userRole);
        b.append(", ");
        b.append("isShared=");
        b.append(this.isShared);
        b.append(", ");
        b.append("sectionsUrl=");
        b.append(this.sectionsUrl);
        b.append(", ");
        b.append("sectionGroupsUrl=");
        b.append(this.sectionGroupsUrl);
        b.append(", ");
        b.append("links=");
        b.append(this.links);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
