package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“IPv4 configuration-based management conditions may be defined that will trigger
 * when a device detects certain IP network settings. An IP config management
 * conditions will only be considered TRUE when the network connection is active.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "ipV4Prefix", 
    "ipV4Gateway", 
    "ipV4DHCPServer", 
    "ipV4DNSServerList", 
    "dnsSuffixList"})
@JsonInclude(Include.NON_NULL)
public class NetworkIPv4ConfigurationManagementCondition extends NetworkManagementCondition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.networkIPv4ConfigurationManagementCondition";
    }

    @JsonProperty("ipV4Prefix")
    protected String ipV4Prefix;

    @JsonProperty("ipV4Gateway")
    protected String ipV4Gateway;

    @JsonProperty("ipV4DHCPServer")
    protected String ipV4DHCPServer;

    @JsonProperty("ipV4DNSServerList")
    protected List<String> ipV4DNSServerList;

    @JsonProperty("ipV4DNSServerList@nextLink")
    protected String ipV4DNSServerListNextLink;

    @JsonProperty("dnsSuffixList")
    protected List<String> dnsSuffixList;

    @JsonProperty("dnsSuffixList@nextLink")
    protected String dnsSuffixListNextLink;

    protected NetworkIPv4ConfigurationManagementCondition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNetworkIPv4ConfigurationManagementCondition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String uniqueName;
        private String displayName;
        private String description;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime modifiedDateTime;
        private String eTag;
        private List<DevicePlatformType> applicablePlatforms;
        private String applicablePlatformsNextLink;
        private String ipV4Prefix;
        private String ipV4Gateway;
        private String ipV4DHCPServer;
        private List<String> ipV4DNSServerList;
        private String ipV4DNSServerListNextLink;
        private List<String> dnsSuffixList;
        private String dnsSuffixListNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = changedFields.add("uniqueName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder applicablePlatforms(List<DevicePlatformType> applicablePlatforms) {
            this.applicablePlatforms = applicablePlatforms;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        public Builder applicablePlatforms(DevicePlatformType... applicablePlatforms) {
            return applicablePlatforms(Arrays.asList(applicablePlatforms));
        }

        public Builder applicablePlatformsNextLink(String applicablePlatformsNextLink) {
            this.applicablePlatformsNextLink = applicablePlatformsNextLink;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        /**
         * <i>“The IPv4 subnet to be connected to. e.g. 10.0.0.0/8”</i>
         * 
         * @param ipV4Prefix
         *            value of {@code ipV4Prefix} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV4Prefix(String ipV4Prefix) {
            this.ipV4Prefix = ipV4Prefix;
            this.changedFields = changedFields.add("ipV4Prefix");
            return this;
        }

        /**
         * <i>“The IPv4 gateway address. e.g. 10.0.0.0”</i>
         * 
         * @param ipV4Gateway
         *            value of {@code ipV4Gateway} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV4Gateway(String ipV4Gateway) {
            this.ipV4Gateway = ipV4Gateway;
            this.changedFields = changedFields.add("ipV4Gateway");
            return this;
        }

        /**
         * <i>“The IPv4 address of the DHCP server for the adapter.”</i>
         * 
         * @param ipV4DHCPServer
         *            value of {@code ipV4DHCPServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV4DHCPServer(String ipV4DHCPServer) {
            this.ipV4DHCPServer = ipV4DHCPServer;
            this.changedFields = changedFields.add("ipV4DHCPServer");
            return this;
        }

        /**
         * <i>“The IPv4 DNS servers configured for the adapter.”</i>
         * 
         * @param ipV4DNSServerList
         *            value of {@code ipV4DNSServerList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV4DNSServerList(List<String> ipV4DNSServerList) {
            this.ipV4DNSServerList = ipV4DNSServerList;
            this.changedFields = changedFields.add("ipV4DNSServerList");
            return this;
        }

        /**
         * <i>“The IPv4 DNS servers configured for the adapter.”</i>
         * 
         * @param ipV4DNSServerList
         *            value of {@code ipV4DNSServerList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV4DNSServerList(String... ipV4DNSServerList) {
            return ipV4DNSServerList(Arrays.asList(ipV4DNSServerList));
        }

        /**
         * <i>“The IPv4 DNS servers configured for the adapter.”</i>
         * 
         * @param ipV4DNSServerListNextLink
         *            value of {@code ipV4DNSServerList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV4DNSServerListNextLink(String ipV4DNSServerListNextLink) {
            this.ipV4DNSServerListNextLink = ipV4DNSServerListNextLink;
            this.changedFields = changedFields.add("ipV4DNSServerList");
            return this;
        }

        /**
         * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
         * 
         * @param dnsSuffixList
         *            value of {@code dnsSuffixList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixList(List<String> dnsSuffixList) {
            this.dnsSuffixList = dnsSuffixList;
            this.changedFields = changedFields.add("dnsSuffixList");
            return this;
        }

        /**
         * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
         * 
         * @param dnsSuffixList
         *            value of {@code dnsSuffixList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixList(String... dnsSuffixList) {
            return dnsSuffixList(Arrays.asList(dnsSuffixList));
        }

        /**
         * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
         * 
         * @param dnsSuffixListNextLink
         *            value of {@code dnsSuffixList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixListNextLink(String dnsSuffixListNextLink) {
            this.dnsSuffixListNextLink = dnsSuffixListNextLink;
            this.changedFields = changedFields.add("dnsSuffixList");
            return this;
        }

        public NetworkIPv4ConfigurationManagementCondition build() {
            NetworkIPv4ConfigurationManagementCondition _x = new NetworkIPv4ConfigurationManagementCondition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.networkIPv4ConfigurationManagementCondition";
            _x.id = id;
            _x.uniqueName = uniqueName;
            _x.displayName = displayName;
            _x.description = description;
            _x.createdDateTime = createdDateTime;
            _x.modifiedDateTime = modifiedDateTime;
            _x.eTag = eTag;
            _x.applicablePlatforms = applicablePlatforms;
            _x.applicablePlatformsNextLink = applicablePlatformsNextLink;
            _x.ipV4Prefix = ipV4Prefix;
            _x.ipV4Gateway = ipV4Gateway;
            _x.ipV4DHCPServer = ipV4DHCPServer;
            _x.ipV4DNSServerList = ipV4DNSServerList;
            _x.ipV4DNSServerListNextLink = ipV4DNSServerListNextLink;
            _x.dnsSuffixList = dnsSuffixList;
            _x.dnsSuffixListNextLink = dnsSuffixListNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The IPv4 subnet to be connected to. e.g. 10.0.0.0/8”</i>
     * 
     * @return property ipV4Prefix
     */
    @Property(name="ipV4Prefix")
    @JsonIgnore
    public Optional<String> getIpV4Prefix() {
        return Optional.ofNullable(ipV4Prefix);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipV4Prefix} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The IPv4 subnet to be connected to. e.g. 10.0.0.0/8”</i>
     * 
     * @param ipV4Prefix
     *            new value of {@code ipV4Prefix} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipV4Prefix} field changed
     */
    public NetworkIPv4ConfigurationManagementCondition withIpV4Prefix(String ipV4Prefix) {
        NetworkIPv4ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("ipV4Prefix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv4ConfigurationManagementCondition");
        _x.ipV4Prefix = ipV4Prefix;
        return _x;
    }

    /**
     * <i>“The IPv4 gateway address. e.g. 10.0.0.0”</i>
     * 
     * @return property ipV4Gateway
     */
    @Property(name="ipV4Gateway")
    @JsonIgnore
    public Optional<String> getIpV4Gateway() {
        return Optional.ofNullable(ipV4Gateway);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipV4Gateway}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The IPv4 gateway address. e.g. 10.0.0.0”</i>
     * 
     * @param ipV4Gateway
     *            new value of {@code ipV4Gateway} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipV4Gateway} field changed
     */
    public NetworkIPv4ConfigurationManagementCondition withIpV4Gateway(String ipV4Gateway) {
        NetworkIPv4ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("ipV4Gateway");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv4ConfigurationManagementCondition");
        _x.ipV4Gateway = ipV4Gateway;
        return _x;
    }

    /**
     * <i>“The IPv4 address of the DHCP server for the adapter.”</i>
     * 
     * @return property ipV4DHCPServer
     */
    @Property(name="ipV4DHCPServer")
    @JsonIgnore
    public Optional<String> getIpV4DHCPServer() {
        return Optional.ofNullable(ipV4DHCPServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipV4DHCPServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The IPv4 address of the DHCP server for the adapter.”</i>
     * 
     * @param ipV4DHCPServer
     *            new value of {@code ipV4DHCPServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipV4DHCPServer} field changed
     */
    public NetworkIPv4ConfigurationManagementCondition withIpV4DHCPServer(String ipV4DHCPServer) {
        NetworkIPv4ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("ipV4DHCPServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv4ConfigurationManagementCondition");
        _x.ipV4DHCPServer = ipV4DHCPServer;
        return _x;
    }

    /**
     * <i>“The IPv4 DNS servers configured for the adapter.”</i>
     * 
     * @return property ipV4DNSServerList
     */
    @Property(name="ipV4DNSServerList")
    @JsonIgnore
    public CollectionPage<String> getIpV4DNSServerList() {
        return new CollectionPage<String>(contextPath, String.class, ipV4DNSServerList, Optional.ofNullable(ipV4DNSServerListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The IPv4 DNS servers configured for the adapter.”</i>
     * 
     * @return property ipV4DNSServerList
     */
    @Property(name="ipV4DNSServerList")
    @JsonIgnore
    public CollectionPage<String> getIpV4DNSServerList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, ipV4DNSServerList, Optional.ofNullable(ipV4DNSServerListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
     * 
     * @return property dnsSuffixList
     */
    @Property(name="dnsSuffixList")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixList() {
        return new CollectionPage<String>(contextPath, String.class, dnsSuffixList, Optional.ofNullable(dnsSuffixListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
     * 
     * @return property dnsSuffixList
     */
    @Property(name="dnsSuffixList")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, dnsSuffixList, Optional.ofNullable(dnsSuffixListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NetworkIPv4ConfigurationManagementCondition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        NetworkIPv4ConfigurationManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NetworkIPv4ConfigurationManagementCondition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        NetworkIPv4ConfigurationManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private NetworkIPv4ConfigurationManagementCondition _copy() {
        NetworkIPv4ConfigurationManagementCondition _x = new NetworkIPv4ConfigurationManagementCondition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.uniqueName = uniqueName;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.modifiedDateTime = modifiedDateTime;
        _x.eTag = eTag;
        _x.applicablePlatforms = applicablePlatforms;
        _x.ipV4Prefix = ipV4Prefix;
        _x.ipV4Gateway = ipV4Gateway;
        _x.ipV4DHCPServer = ipV4DHCPServer;
        _x.ipV4DNSServerList = ipV4DNSServerList;
        _x.dnsSuffixList = dnsSuffixList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NetworkIPv4ConfigurationManagementCondition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("uniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("applicablePlatforms=");
        b.append(this.applicablePlatforms);
        b.append(", ");
        b.append("ipV4Prefix=");
        b.append(this.ipV4Prefix);
        b.append(", ");
        b.append("ipV4Gateway=");
        b.append(this.ipV4Gateway);
        b.append(", ");
        b.append("ipV4DHCPServer=");
        b.append(this.ipV4DHCPServer);
        b.append(", ");
        b.append("ipV4DNSServerList=");
        b.append(this.ipV4DNSServerList);
        b.append(", ");
        b.append("dnsSuffixList=");
        b.append(this.dnsSuffixList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
