package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.NdesConnectorState;


/**
 * <i>“Entity which represents an OnPrem Ndes connector.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastConnectionDateTime", 
    "state", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class NdesConnector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ndesConnector";
    }

    @JsonProperty("lastConnectionDateTime")
    protected OffsetDateTime lastConnectionDateTime;

    @JsonProperty("state")
    protected NdesConnectorState state;

    @JsonProperty("displayName")
    protected String displayName;

    protected NdesConnector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNdesConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastConnectionDateTime;
        private NdesConnectorState state;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Last connection time for the Ndes Connector”</i>
         * 
         * @param lastConnectionDateTime
         *            value of {@code lastConnectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
            this.lastConnectionDateTime = lastConnectionDateTime;
            this.changedFields = changedFields.add("lastConnectionDateTime");
            return this;
        }

        /**
         * <i>“Ndes Connector Status”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(NdesConnectorState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“The friendly name of the Ndes Connector.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public NdesConnector build() {
            NdesConnector _x = new NdesConnector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.ndesConnector";
            _x.id = id;
            _x.lastConnectionDateTime = lastConnectionDateTime;
            _x.state = state;
            _x.displayName = displayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Last connection time for the Ndes Connector”</i>
     * 
     * @return property lastConnectionDateTime
     */
    @Property(name="lastConnectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConnectionDateTime() {
        return Optional.ofNullable(lastConnectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastConnectionDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Last connection time for the Ndes Connector”</i>
     * 
     * @param lastConnectionDateTime
     *            new value of {@code lastConnectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastConnectionDateTime} field changed
     */
    public NdesConnector withLastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
        NdesConnector _x = _copy();
        _x.changedFields = changedFields.add("lastConnectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ndesConnector");
        _x.lastConnectionDateTime = lastConnectionDateTime;
        return _x;
    }

    /**
     * <i>“Ndes Connector Status”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<NdesConnectorState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Ndes Connector Status”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public NdesConnector withState(NdesConnectorState state) {
        NdesConnector _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ndesConnector");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“The friendly name of the Ndes Connector.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the Ndes Connector.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public NdesConnector withDisplayName(String displayName) {
        NdesConnector _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ndesConnector");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NdesConnector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        NdesConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NdesConnector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        NdesConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private NdesConnector _copy() {
        NdesConnector _x = new NdesConnector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastConnectionDateTime = lastConnectionDateTime;
        _x.state = state;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NdesConnector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastConnectionDateTime=");
        b.append(this.lastConnectionDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
