package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.enums.OperationStatus;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MuteParticipantOperation extends CommsOperation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.muteParticipantOperation";
    }

    protected MuteParticipantOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMuteParticipantOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OperationStatus status;
        private String clientContext;
        private ResultInfo resultInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            this.changedFields = changedFields.add("clientContext");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public MuteParticipantOperation build() {
            MuteParticipantOperation _x = new MuteParticipantOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.muteParticipantOperation";
            _x.id = id;
            _x.status = status;
            _x.clientContext = clientContext;
            _x.resultInfo = resultInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MuteParticipantOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MuteParticipantOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MuteParticipantOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MuteParticipantOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MuteParticipantOperation _copy() {
        MuteParticipantOperation _x = new MuteParticipantOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.status = status;
        _x.clientContext = clientContext;
        _x.resultInfo = resultInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MuteParticipantOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("clientContext=");
        b.append(this.clientContext);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
