package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Describes a relationship between two mobile apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "targetId", 
    "targetDisplayName"})
@JsonInclude(Include.NON_NULL)
public class MobileAppRelationship extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppRelationship";
    }

    @JsonProperty("targetId")
    protected String targetId;

    @JsonProperty("targetDisplayName")
    protected String targetDisplayName;

    protected MobileAppRelationship() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The target mobile app's app id.”</i>
     * 
     * @return property targetId
     */
    @Property(name="targetId")
    @JsonIgnore
    public Optional<String> getTargetId() {
        return Optional.ofNullable(targetId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The target mobile app's app id.”</i>
     * 
     * @param targetId
     *            new value of {@code targetId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetId} field changed
     */
    public MobileAppRelationship withTargetId(String targetId) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetId = targetId;
        return _x;
    }

    /**
     * <i>“The target mobile app's display name.”</i>
     * 
     * @return property targetDisplayName
     */
    @Property(name="targetDisplayName")
    @JsonIgnore
    public Optional<String> getTargetDisplayName() {
        return Optional.ofNullable(targetDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The target mobile app's display name.”</i>
     * 
     * @param targetDisplayName
     *            new value of {@code targetDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetDisplayName} field changed
     */
    public MobileAppRelationship withTargetDisplayName(String targetDisplayName) {
        MobileAppRelationship _x = _copy();
        _x.changedFields = changedFields.add("targetDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationship");
        _x.targetDisplayName = targetDisplayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppRelationship patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppRelationship put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppRelationship _copy() {
        MobileAppRelationship _x = new MobileAppRelationship();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.targetId = targetId;
        _x.targetDisplayName = targetDisplayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppRelationship[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("targetDisplayName=");
        b.append(this.targetDisplayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
