package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MobileAppIntentAndStateDetail;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“MobileApp Intent and Install State for a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "managedDeviceIdentifier", 
    "userId", 
    "mobileAppList"})
@JsonInclude(Include.NON_NULL)
public class MobileAppIntentAndState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppIntentAndState";
    }

    @JsonProperty("managedDeviceIdentifier")
    protected String managedDeviceIdentifier;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("mobileAppList")
    protected List<MobileAppIntentAndStateDetail> mobileAppList;

    @JsonProperty("mobileAppList@nextLink")
    protected String mobileAppListNextLink;

    protected MobileAppIntentAndState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppIntentAndState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String managedDeviceIdentifier;
        private String userId;
        private List<MobileAppIntentAndStateDetail> mobileAppList;
        private String mobileAppListNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device identifier created or collected by Intune.”</i>
         * 
         * @param managedDeviceIdentifier
         *            value of {@code managedDeviceIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceIdentifier(String managedDeviceIdentifier) {
            this.managedDeviceIdentifier = managedDeviceIdentifier;
            this.changedFields = changedFields.add("managedDeviceIdentifier");
            return this;
        }

        /**
         * <i>“Identifier for the user that tried to enroll the device.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The list of payload intents and states for the tenant.”</i>
         * 
         * @param mobileAppList
         *            value of {@code mobileAppList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppList(List<MobileAppIntentAndStateDetail> mobileAppList) {
            this.mobileAppList = mobileAppList;
            this.changedFields = changedFields.add("mobileAppList");
            return this;
        }

        /**
         * <i>“The list of payload intents and states for the tenant.”</i>
         * 
         * @param mobileAppList
         *            value of {@code mobileAppList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppList(MobileAppIntentAndStateDetail... mobileAppList) {
            return mobileAppList(Arrays.asList(mobileAppList));
        }

        /**
         * <i>“The list of payload intents and states for the tenant.”</i>
         * 
         * @param mobileAppListNextLink
         *            value of {@code mobileAppList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppListNextLink(String mobileAppListNextLink) {
            this.mobileAppListNextLink = mobileAppListNextLink;
            this.changedFields = changedFields.add("mobileAppList");
            return this;
        }

        public MobileAppIntentAndState build() {
            MobileAppIntentAndState _x = new MobileAppIntentAndState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mobileAppIntentAndState";
            _x.id = id;
            _x.managedDeviceIdentifier = managedDeviceIdentifier;
            _x.userId = userId;
            _x.mobileAppList = mobileAppList;
            _x.mobileAppListNextLink = mobileAppListNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Device identifier created or collected by Intune.”</i>
     * 
     * @return property managedDeviceIdentifier
     */
    @Property(name="managedDeviceIdentifier")
    @JsonIgnore
    public Optional<String> getManagedDeviceIdentifier() {
        return Optional.ofNullable(managedDeviceIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceIdentifier} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device identifier created or collected by Intune.”</i>
     * 
     * @param managedDeviceIdentifier
     *            new value of {@code managedDeviceIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceIdentifier} field changed
     */
    public MobileAppIntentAndState withManagedDeviceIdentifier(String managedDeviceIdentifier) {
        MobileAppIntentAndState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndState");
        _x.managedDeviceIdentifier = managedDeviceIdentifier;
        return _x;
    }

    /**
     * <i>“Identifier for the user that tried to enroll the device.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier for the user that tried to enroll the device.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public MobileAppIntentAndState withUserId(String userId) {
        MobileAppIntentAndState _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndState");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“The list of payload intents and states for the tenant.”</i>
     * 
     * @return property mobileAppList
     */
    @Property(name="mobileAppList")
    @JsonIgnore
    public CollectionPage<MobileAppIntentAndStateDetail> getMobileAppList() {
        return new CollectionPage<MobileAppIntentAndStateDetail>(contextPath, MobileAppIntentAndStateDetail.class, mobileAppList, Optional.ofNullable(mobileAppListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The list of payload intents and states for the tenant.”</i>
     * 
     * @return property mobileAppList
     */
    @Property(name="mobileAppList")
    @JsonIgnore
    public CollectionPage<MobileAppIntentAndStateDetail> getMobileAppList(HttpRequestOptions options) {
        return new CollectionPage<MobileAppIntentAndStateDetail>(contextPath, MobileAppIntentAndStateDetail.class, mobileAppList, Optional.ofNullable(mobileAppListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppIntentAndState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppIntentAndState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppIntentAndState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppIntentAndState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppIntentAndState _copy() {
        MobileAppIntentAndState _x = new MobileAppIntentAndState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.managedDeviceIdentifier = managedDeviceIdentifier;
        _x.userId = userId;
        _x.mobileAppList = mobileAppList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppIntentAndState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("managedDeviceIdentifier=");
        b.append(this.managedDeviceIdentifier);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("mobileAppList=");
        b.append(this.mobileAppList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
