package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.MobileAppRequest;
import odata.msgraph.client.beta.enums.ResultantAppState;
import odata.msgraph.client.beta.enums.ResultantAppStateDetail;


/**
 * <i>“Contains properties for the installation state of a mobile app for a device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceName", 
    "deviceId", 
    "lastSyncDateTime", 
    "mobileAppInstallStatusValue", 
    "installState", 
    "installStateDetail", 
    "errorCode", 
    "osVersion", 
    "osDescription", 
    "userName", 
    "userPrincipalName", 
    "displayVersion"})
@JsonInclude(Include.NON_NULL)
public class MobileAppInstallStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppInstallStatus";
    }

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("mobileAppInstallStatusValue")
    protected ResultantAppState mobileAppInstallStatusValue;

    @JsonProperty("installState")
    protected ResultantAppState installState;

    @JsonProperty("installStateDetail")
    protected ResultantAppStateDetail installStateDetail;

    @JsonProperty("errorCode")
    protected Integer errorCode;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("osDescription")
    protected String osDescription;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayVersion")
    protected String displayVersion;

    protected MobileAppInstallStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppInstallStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceName;
        private String deviceId;
        private OffsetDateTime lastSyncDateTime;
        private ResultantAppState mobileAppInstallStatusValue;
        private ResultantAppState installState;
        private ResultantAppStateDetail installStateDetail;
        private Integer errorCode;
        private String osVersion;
        private String osDescription;
        private String userName;
        private String userPrincipalName;
        private String displayVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device name”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Device ID”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“Last sync date time”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“The install state of the app.”</i>
         * 
         * @param mobileAppInstallStatusValue
         *            value of {@code mobileAppInstallStatusValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppInstallStatusValue(ResultantAppState mobileAppInstallStatusValue) {
            this.mobileAppInstallStatusValue = mobileAppInstallStatusValue;
            this.changedFields = changedFields.add("mobileAppInstallStatusValue");
            return this;
        }

        /**
         * <i>“The install state of the app.”</i>
         * 
         * @param installState
         *            value of {@code installState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installState(ResultantAppState installState) {
            this.installState = installState;
            this.changedFields = changedFields.add("installState");
            return this;
        }

        /**
         * <i>“The install state detail of the app.”</i>
         * 
         * @param installStateDetail
         *            value of {@code installStateDetail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installStateDetail(ResultantAppStateDetail installStateDetail) {
            this.installStateDetail = installStateDetail;
            this.changedFields = changedFields.add("installStateDetail");
            return this;
        }

        /**
         * <i>“The error code for install or uninstall failures.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“OS Version”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“OS Description”</i>
         * 
         * @param osDescription
         *            value of {@code osDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            this.changedFields = changedFields.add("osDescription");
            return this;
        }

        /**
         * <i>“Device User Name”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“User Principal Name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Human readable version of the application”</i>
         * 
         * @param displayVersion
         *            value of {@code displayVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayVersion(String displayVersion) {
            this.displayVersion = displayVersion;
            this.changedFields = changedFields.add("displayVersion");
            return this;
        }

        public MobileAppInstallStatus build() {
            MobileAppInstallStatus _x = new MobileAppInstallStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mobileAppInstallStatus";
            _x.id = id;
            _x.deviceName = deviceName;
            _x.deviceId = deviceId;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.mobileAppInstallStatusValue = mobileAppInstallStatusValue;
            _x.installState = installState;
            _x.installStateDetail = installStateDetail;
            _x.errorCode = errorCode;
            _x.osVersion = osVersion;
            _x.osDescription = osDescription;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            _x.displayVersion = displayVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Device name”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public MobileAppInstallStatus withDeviceName(String deviceName) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Device ID”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device ID”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public MobileAppInstallStatus withDeviceId(String deviceId) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“Last sync date time”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last sync date time”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public MobileAppInstallStatus withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“The install state of the app.”</i>
     * 
     * @return property mobileAppInstallStatusValue
     */
    @Property(name="mobileAppInstallStatusValue")
    @JsonIgnore
    public Optional<ResultantAppState> getMobileAppInstallStatusValue() {
        return Optional.ofNullable(mobileAppInstallStatusValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppInstallStatusValue} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The install state of the app.”</i>
     * 
     * @param mobileAppInstallStatusValue
     *            new value of {@code mobileAppInstallStatusValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppInstallStatusValue} field changed
     */
    public MobileAppInstallStatus withMobileAppInstallStatusValue(ResultantAppState mobileAppInstallStatusValue) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("mobileAppInstallStatusValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.mobileAppInstallStatusValue = mobileAppInstallStatusValue;
        return _x;
    }

    /**
     * <i>“The install state of the app.”</i>
     * 
     * @return property installState
     */
    @Property(name="installState")
    @JsonIgnore
    public Optional<ResultantAppState> getInstallState() {
        return Optional.ofNullable(installState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The install state of the app.”</i>
     * 
     * @param installState
     *            new value of {@code installState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installState} field changed
     */
    public MobileAppInstallStatus withInstallState(ResultantAppState installState) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("installState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.installState = installState;
        return _x;
    }

    /**
     * <i>“The install state detail of the app.”</i>
     * 
     * @return property installStateDetail
     */
    @Property(name="installStateDetail")
    @JsonIgnore
    public Optional<ResultantAppStateDetail> getInstallStateDetail() {
        return Optional.ofNullable(installStateDetail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installStateDetail} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The install state detail of the app.”</i>
     * 
     * @param installStateDetail
     *            new value of {@code installStateDetail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installStateDetail} field changed
     */
    public MobileAppInstallStatus withInstallStateDetail(ResultantAppStateDetail installStateDetail) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("installStateDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.installStateDetail = installStateDetail;
        return _x;
    }

    /**
     * <i>“The error code for install or uninstall failures.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The error code for install or uninstall failures.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public MobileAppInstallStatus withErrorCode(Integer errorCode) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“OS Version”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“OS Version”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public MobileAppInstallStatus withOsVersion(String osVersion) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“OS Description”</i>
     * 
     * @return property osDescription
     */
    @Property(name="osDescription")
    @JsonIgnore
    public Optional<String> getOsDescription() {
        return Optional.ofNullable(osDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“OS Description”</i>
     * 
     * @param osDescription
     *            new value of {@code osDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osDescription} field changed
     */
    public MobileAppInstallStatus withOsDescription(String osDescription) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("osDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.osDescription = osDescription;
        return _x;
    }

    /**
     * <i>“Device User Name”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device User Name”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public MobileAppInstallStatus withUserName(String userName) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“User Principal Name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public MobileAppInstallStatus withUserPrincipalName(String userPrincipalName) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Human readable version of the application”</i>
     * 
     * @return property displayVersion
     */
    @Property(name="displayVersion")
    @JsonIgnore
    public Optional<String> getDisplayVersion() {
        return Optional.ofNullable(displayVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Human readable version of the application”</i>
     * 
     * @param displayVersion
     *            new value of {@code displayVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayVersion} field changed
     */
    public MobileAppInstallStatus withDisplayVersion(String displayVersion) {
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("displayVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallStatus");
        _x.displayVersion = displayVersion;
        return _x;
    }

    /**
     * <i>“The navigation link to the mobile app.”</i>
     * 
     * @return navigational property app
     */
    @NavigationProperty(name="app")
    @JsonIgnore
    public MobileAppRequest getApp() {
        return new MobileAppRequest(contextPath.addSegment("app"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppInstallStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppInstallStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppInstallStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppInstallStatus _copy() {
        MobileAppInstallStatus _x = new MobileAppInstallStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceName = deviceName;
        _x.deviceId = deviceId;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.mobileAppInstallStatusValue = mobileAppInstallStatusValue;
        _x.installState = installState;
        _x.installStateDetail = installStateDetail;
        _x.errorCode = errorCode;
        _x.osVersion = osVersion;
        _x.osDescription = osDescription;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        _x.displayVersion = displayVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppInstallStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("mobileAppInstallStatusValue=");
        b.append(this.mobileAppInstallStatusValue);
        b.append(", ");
        b.append("installState=");
        b.append(this.installState);
        b.append(", ");
        b.append("installStateDetail=");
        b.append(this.installStateDetail);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("osDescription=");
        b.append(this.osDescription);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayVersion=");
        b.append(this.displayVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
