package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.MobileAppRelationshipState;
import odata.msgraph.client.beta.entity.collection.request.MobileAppAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppInstallStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppRelationshipCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserAppInstallStatusCollectionRequest;
import odata.msgraph.client.beta.entity.request.MobileAppInstallSummaryRequest;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“An abstract class containing the base properties for Intune mobile apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "publisher", 
    "largeIcon", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "isFeatured", 
    "privacyInformationUrl", 
    "informationUrl", 
    "owner", 
    "developer", 
    "notes", 
    "uploadState", 
    "publishingState", 
    "isAssigned", 
    "roleScopeTagIds", 
    "dependentAppCount"})
@JsonInclude(Include.NON_NULL)
public class MobileApp extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileApp";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("largeIcon")
    protected MimeContent largeIcon;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("isFeatured")
    protected Boolean isFeatured;

    @JsonProperty("privacyInformationUrl")
    protected String privacyInformationUrl;

    @JsonProperty("informationUrl")
    protected String informationUrl;

    @JsonProperty("owner")
    protected String owner;

    @JsonProperty("developer")
    protected String developer;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("uploadState")
    protected Integer uploadState;

    @JsonProperty("publishingState")
    protected MobileAppPublishingState publishingState;

    @JsonProperty("isAssigned")
    protected Boolean isAssigned;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("dependentAppCount")
    protected Integer dependentAppCount;

    protected MobileApp() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The admin provided or imported title of the app.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin provided or imported title of the app.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MobileApp withDisplayName(String displayName) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The description of the app.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the app.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public MobileApp withDescription(String description) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The publisher of the app.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The publisher of the app.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public MobileApp withPublisher(String publisher) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“The large icon, to be displayed in the app details and used for upload of the
     * icon.”</i>
     * 
     * @return property largeIcon
     */
    @Property(name="largeIcon")
    @JsonIgnore
    public Optional<MimeContent> getLargeIcon() {
        return Optional.ofNullable(largeIcon);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code largeIcon} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The large icon, to be displayed in the app details and used for upload of the
     * icon.”</i>
     * 
     * @param largeIcon
     *            new value of {@code largeIcon} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code largeIcon} field changed
     */
    public MobileApp withLargeIcon(MimeContent largeIcon) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("largeIcon");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.largeIcon = largeIcon;
        return _x;
    }

    /**
     * <i>“The date and time the app was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time the app was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public MobileApp withCreatedDateTime(OffsetDateTime createdDateTime) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The date and time the app was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the app was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public MobileApp withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The value indicating whether the app is marked as featured by the admin.”</i>
     * 
     * @return property isFeatured
     */
    @Property(name="isFeatured")
    @JsonIgnore
    public Optional<Boolean> getIsFeatured() {
        return Optional.ofNullable(isFeatured);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isFeatured} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value indicating whether the app is marked as featured by the admin.”</i>
     * 
     * @param isFeatured
     *            new value of {@code isFeatured} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isFeatured} field changed
     */
    public MobileApp withIsFeatured(Boolean isFeatured) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("isFeatured");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.isFeatured = isFeatured;
        return _x;
    }

    /**
     * <i>“The privacy statement Url.”</i>
     * 
     * @return property privacyInformationUrl
     */
    @Property(name="privacyInformationUrl")
    @JsonIgnore
    public Optional<String> getPrivacyInformationUrl() {
        return Optional.ofNullable(privacyInformationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyInformationUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The privacy statement Url.”</i>
     * 
     * @param privacyInformationUrl
     *            new value of {@code privacyInformationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyInformationUrl} field changed
     */
    public MobileApp withPrivacyInformationUrl(String privacyInformationUrl) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("privacyInformationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.privacyInformationUrl = privacyInformationUrl;
        return _x;
    }

    /**
     * <i>“The more information Url.”</i>
     * 
     * @return property informationUrl
     */
    @Property(name="informationUrl")
    @JsonIgnore
    public Optional<String> getInformationUrl() {
        return Optional.ofNullable(informationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code informationUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The more information Url.”</i>
     * 
     * @param informationUrl
     *            new value of {@code informationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code informationUrl} field changed
     */
    public MobileApp withInformationUrl(String informationUrl) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("informationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.informationUrl = informationUrl;
        return _x;
    }

    /**
     * <i>“The owner of the app.”</i>
     * 
     * @return property owner
     */
    @Property(name="owner")
    @JsonIgnore
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code owner} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The owner of the app.”</i>
     * 
     * @param owner
     *            new value of {@code owner} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code owner} field changed
     */
    public MobileApp withOwner(String owner) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.owner = owner;
        return _x;
    }

    /**
     * <i>“The developer of the app.”</i>
     * 
     * @return property developer
     */
    @Property(name="developer")
    @JsonIgnore
    public Optional<String> getDeveloper() {
        return Optional.ofNullable(developer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code developer} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The developer of the app.”</i>
     * 
     * @param developer
     *            new value of {@code developer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code developer} field changed
     */
    public MobileApp withDeveloper(String developer) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("developer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.developer = developer;
        return _x;
    }

    /**
     * <i>“Notes for the app.”</i>
     * 
     * @return property notes
     */
    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code notes} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Notes for the app.”</i>
     * 
     * @param notes
     *            new value of {@code notes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notes} field changed
     */
    public MobileApp withNotes(String notes) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.notes = notes;
        return _x;
    }

    /**
     * <i>“The upload state.”</i>
     * 
     * @return property uploadState
     */
    @Property(name="uploadState")
    @JsonIgnore
    public Optional<Integer> getUploadState() {
        return Optional.ofNullable(uploadState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uploadState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The upload state.”</i>
     * 
     * @param uploadState
     *            new value of {@code uploadState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uploadState} field changed
     */
    public MobileApp withUploadState(Integer uploadState) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("uploadState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.uploadState = uploadState;
        return _x;
    }

    /**
     * <i>“The publishing state for the app. The app cannot be assigned unless the app is
     * published.”</i>
     * 
     * @return property publishingState
     */
    @Property(name="publishingState")
    @JsonIgnore
    public Optional<MobileAppPublishingState> getPublishingState() {
        return Optional.ofNullable(publishingState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publishingState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publishing state for the app. The app cannot be assigned unless the app is
     * published.”</i>
     * 
     * @param publishingState
     *            new value of {@code publishingState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publishingState} field changed
     */
    public MobileApp withPublishingState(MobileAppPublishingState publishingState) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("publishingState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.publishingState = publishingState;
        return _x;
    }

    /**
     * <i>“The value indicating whether the app is assigned to at least one group.”</i>
     * 
     * @return property isAssigned
     */
    @Property(name="isAssigned")
    @JsonIgnore
    public Optional<Boolean> getIsAssigned() {
        return Optional.ofNullable(isAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isAssigned} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value indicating whether the app is assigned to at least one group.”</i>
     * 
     * @param isAssigned
     *            new value of {@code isAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isAssigned} field changed
     */
    public MobileApp withIsAssigned(Boolean isAssigned) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("isAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.isAssigned = isAssigned;
        return _x;
    }

    /**
     * <i>“List of scope tag ids for this mobile app.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of scope tag ids for this mobile app.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The total number of dependencies the child app has.”</i>
     * 
     * @return property dependentAppCount
     */
    @Property(name="dependentAppCount")
    @JsonIgnore
    public Optional<Integer> getDependentAppCount() {
        return Optional.ofNullable(dependentAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependentAppCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of dependencies the child app has.”</i>
     * 
     * @param dependentAppCount
     *            new value of {@code dependentAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependentAppCount} field changed
     */
    public MobileApp withDependentAppCount(Integer dependentAppCount) {
        MobileApp _x = _copy();
        _x.changedFields = changedFields.add("dependentAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileApp");
        _x.dependentAppCount = dependentAppCount;
        return _x;
    }

    /**
     * <i>“The list of categories for this app.”</i>
     * 
     * @return navigational property categories
     */
    @NavigationProperty(name="categories")
    @JsonIgnore
    public MobileAppCategoryCollectionRequest getCategories() {
        return new MobileAppCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    /**
     * <i>“The list of group assignments for this mobile app.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public MobileAppAssignmentCollectionRequest getAssignments() {
        return new MobileAppAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    /**
     * <i>“Mobile App Install Summary.”</i>
     * 
     * @return navigational property installSummary
     */
    @NavigationProperty(name="installSummary")
    @JsonIgnore
    public MobileAppInstallSummaryRequest getInstallSummary() {
        return new MobileAppInstallSummaryRequest(contextPath.addSegment("installSummary"));
    }

    /**
     * <i>“The list of installation states for this mobile app.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public MobileAppInstallStatusCollectionRequest getDeviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    /**
     * <i>“The list of installation states for this mobile app.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public UserAppInstallStatusCollectionRequest getUserStatuses() {
        return new UserAppInstallStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"));
    }

    /**
     * <i>“List of relationships for this mobile app.”</i>
     * 
     * @return navigational property relationships
     */
    @NavigationProperty(name="relationships")
    @JsonIgnore
    public MobileAppRelationshipCollectionRequest getRelationships() {
        return new MobileAppRelationshipCollectionRequest(
                        contextPath.addSegment("relationships"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileApp _copy() {
        MobileApp _x = new MobileApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<MobileAppAssignment> mobileAppAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("mobileAppAssignments", "Collection(microsoft.graph.mobileAppAssignment)", mobileAppAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "updateRelationships")
    @JsonIgnore
    public ActionRequestNoReturn updateRelationships(List<MobileAppRelationship> relationships) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("relationships", "Collection(microsoft.graph.mobileAppRelationship)", relationships)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateRelationships"), _parameters);
    }

    @Function(name = "getRelatedAppStates")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MobileAppRelationshipState> getRelatedAppStates(String userPrincipalName, String deviceId) {
        Preconditions.checkNotNull(userPrincipalName, "userPrincipalName cannot be null");
        Preconditions.checkNotNull(deviceId, "deviceId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("deviceId", "Edm.String", Checks.checkIsAscii(deviceId))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRelatedAppStates"), MobileAppRelationshipState.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
