package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.VppLicensingType;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;
import odata.msgraph.client.beta.enums.MicrosoftStoreForBusinessLicenseType;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Microsoft Store for Business Apps. This class does not support Create, Delete,
 * or Update.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "usedLicenseCount", 
    "totalLicenseCount", 
    "productKey", 
    "licenseType", 
    "packageIdentityName", 
    "licensingType"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftStoreForBusinessApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftStoreForBusinessApp";
    }

    @JsonProperty("usedLicenseCount")
    protected Integer usedLicenseCount;

    @JsonProperty("totalLicenseCount")
    protected Integer totalLicenseCount;

    @JsonProperty("productKey")
    protected String productKey;

    @JsonProperty("licenseType")
    protected MicrosoftStoreForBusinessLicenseType licenseType;

    @JsonProperty("packageIdentityName")
    protected String packageIdentityName;

    @JsonProperty("licensingType")
    protected VppLicensingType licensingType;

    protected MicrosoftStoreForBusinessApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftStoreForBusinessApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private Integer usedLicenseCount;
        private Integer totalLicenseCount;
        private String productKey;
        private MicrosoftStoreForBusinessLicenseType licenseType;
        private String packageIdentityName;
        private VppLicensingType licensingType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        /**
         * <i>“The number of Microsoft Store for Business licenses in use.”</i>
         * 
         * @param usedLicenseCount
         *            value of {@code usedLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        /**
         * <i>“The total number of Microsoft Store for Business licenses.”</i>
         * 
         * @param totalLicenseCount
         *            value of {@code totalLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        /**
         * <i>“The app product key”</i>
         * 
         * @param productKey
         *            value of {@code productKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productKey(String productKey) {
            this.productKey = productKey;
            this.changedFields = changedFields.add("productKey");
            return this;
        }

        /**
         * <i>“The app license type”</i>
         * 
         * @param licenseType
         *            value of {@code licenseType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder licenseType(MicrosoftStoreForBusinessLicenseType licenseType) {
            this.licenseType = licenseType;
            this.changedFields = changedFields.add("licenseType");
            return this;
        }

        /**
         * <i>“The app package identifier”</i>
         * 
         * @param packageIdentityName
         *            value of {@code packageIdentityName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageIdentityName(String packageIdentityName) {
            this.packageIdentityName = packageIdentityName;
            this.changedFields = changedFields.add("packageIdentityName");
            return this;
        }

        /**
         * <i>“The supported License Type.”</i>
         * 
         * @param licensingType
         *            value of {@code licensingType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder licensingType(VppLicensingType licensingType) {
            this.licensingType = licensingType;
            this.changedFields = changedFields.add("licensingType");
            return this;
        }

        public MicrosoftStoreForBusinessApp build() {
            MicrosoftStoreForBusinessApp _x = new MicrosoftStoreForBusinessApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.microsoftStoreForBusinessApp";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.usedLicenseCount = usedLicenseCount;
            _x.totalLicenseCount = totalLicenseCount;
            _x.productKey = productKey;
            _x.licenseType = licenseType;
            _x.packageIdentityName = packageIdentityName;
            _x.licensingType = licensingType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The number of Microsoft Store for Business licenses in use.”</i>
     * 
     * @return property usedLicenseCount
     */
    @Property(name="usedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getUsedLicenseCount() {
        return Optional.ofNullable(usedLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usedLicenseCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of Microsoft Store for Business licenses in use.”</i>
     * 
     * @param usedLicenseCount
     *            new value of {@code usedLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usedLicenseCount} field changed
     */
    public MicrosoftStoreForBusinessApp withUsedLicenseCount(Integer usedLicenseCount) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("usedLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    /**
     * <i>“The total number of Microsoft Store for Business licenses.”</i>
     * 
     * @return property totalLicenseCount
     */
    @Property(name="totalLicenseCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicenseCount() {
        return Optional.ofNullable(totalLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalLicenseCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of Microsoft Store for Business licenses.”</i>
     * 
     * @param totalLicenseCount
     *            new value of {@code totalLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicenseCount} field changed
     */
    public MicrosoftStoreForBusinessApp withTotalLicenseCount(Integer totalLicenseCount) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("totalLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.totalLicenseCount = totalLicenseCount;
        return _x;
    }

    /**
     * <i>“The app product key”</i>
     * 
     * @return property productKey
     */
    @Property(name="productKey")
    @JsonIgnore
    public Optional<String> getProductKey() {
        return Optional.ofNullable(productKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app product key”</i>
     * 
     * @param productKey
     *            new value of {@code productKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productKey} field changed
     */
    public MicrosoftStoreForBusinessApp withProductKey(String productKey) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("productKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.productKey = productKey;
        return _x;
    }

    /**
     * <i>“The app license type”</i>
     * 
     * @return property licenseType
     */
    @Property(name="licenseType")
    @JsonIgnore
    public Optional<MicrosoftStoreForBusinessLicenseType> getLicenseType() {
        return Optional.ofNullable(licenseType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code licenseType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app license type”</i>
     * 
     * @param licenseType
     *            new value of {@code licenseType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code licenseType} field changed
     */
    public MicrosoftStoreForBusinessApp withLicenseType(MicrosoftStoreForBusinessLicenseType licenseType) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("licenseType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.licenseType = licenseType;
        return _x;
    }

    /**
     * <i>“The app package identifier”</i>
     * 
     * @return property packageIdentityName
     */
    @Property(name="packageIdentityName")
    @JsonIgnore
    public Optional<String> getPackageIdentityName() {
        return Optional.ofNullable(packageIdentityName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * packageIdentityName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The app package identifier”</i>
     * 
     * @param packageIdentityName
     *            new value of {@code packageIdentityName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageIdentityName} field changed
     */
    public MicrosoftStoreForBusinessApp withPackageIdentityName(String packageIdentityName) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("packageIdentityName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.packageIdentityName = packageIdentityName;
        return _x;
    }

    /**
     * <i>“The supported License Type.”</i>
     * 
     * @return property licensingType
     */
    @Property(name="licensingType")
    @JsonIgnore
    public Optional<VppLicensingType> getLicensingType() {
        return Optional.ofNullable(licensingType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code licensingType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The supported License Type.”</i>
     * 
     * @param licensingType
     *            new value of {@code licensingType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code licensingType} field changed
     */
    public MicrosoftStoreForBusinessApp withLicensingType(VppLicensingType licensingType) {
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = changedFields.add("licensingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessApp");
        _x.licensingType = licensingType;
        return _x;
    }

    /**
     * <i>“The collection of contained apps in a mobileApp acting as a package.”</i>
     * 
     * @return navigational property containedApps
     */
    @NavigationProperty(name="containedApps")
    @JsonIgnore
    public MobileContainedAppCollectionRequest getContainedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("containedApps"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftStoreForBusinessApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftStoreForBusinessApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftStoreForBusinessApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftStoreForBusinessApp _copy() {
        MicrosoftStoreForBusinessApp _x = new MicrosoftStoreForBusinessApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.usedLicenseCount = usedLicenseCount;
        _x.totalLicenseCount = totalLicenseCount;
        _x.productKey = productKey;
        _x.licenseType = licenseType;
        _x.packageIdentityName = packageIdentityName;
        _x.licensingType = licensingType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftStoreForBusinessApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("productKey=");
        b.append(this.productKey);
        b.append(", ");
        b.append("licenseType=");
        b.append(this.licenseType);
        b.append(", ");
        b.append("packageIdentityName=");
        b.append(this.packageIdentityName);
        b.append(", ");
        b.append("licensingType=");
        b.append(this.licensingType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
