package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticatorAppContextType;

@JsonPropertyOrder({
    "@odata.type", 
    "shownContext", 
    "isNumberMatchingRequired"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftAuthenticatorAuthenticationMethodTarget extends AuthenticationMethodTarget implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget";
    }

    @JsonProperty("shownContext")
    protected AuthenticatorAppContextType shownContext;

    @JsonProperty("isNumberMatchingRequired")
    protected Boolean isNumberMatchingRequired;

    protected MicrosoftAuthenticatorAuthenticationMethodTarget() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftAuthenticatorAuthenticationMethodTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthenticatorAppContextType shownContext;
        private Boolean isNumberMatchingRequired;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder shownContext(AuthenticatorAppContextType shownContext) {
            this.shownContext = shownContext;
            this.changedFields = changedFields.add("shownContext");
            return this;
        }

        public Builder isNumberMatchingRequired(Boolean isNumberMatchingRequired) {
            this.isNumberMatchingRequired = isNumberMatchingRequired;
            this.changedFields = changedFields.add("isNumberMatchingRequired");
            return this;
        }

        public MicrosoftAuthenticatorAuthenticationMethodTarget build() {
            MicrosoftAuthenticatorAuthenticationMethodTarget _x = new MicrosoftAuthenticatorAuthenticationMethodTarget();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget";
            _x.id = id;
            _x.shownContext = shownContext;
            _x.isNumberMatchingRequired = isNumberMatchingRequired;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="shownContext")
    @JsonIgnore
    public Optional<AuthenticatorAppContextType> getShownContext() {
        return Optional.ofNullable(shownContext);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget withShownContext(AuthenticatorAppContextType shownContext) {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("shownContext");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget");
        _x.shownContext = shownContext;
        return _x;
    }

    @Property(name="isNumberMatchingRequired")
    @JsonIgnore
    public Optional<Boolean> getIsNumberMatchingRequired() {
        return Optional.ofNullable(isNumberMatchingRequired);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget withIsNumberMatchingRequired(Boolean isNumberMatchingRequired) {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("isNumberMatchingRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget");
        _x.isNumberMatchingRequired = isNumberMatchingRequired;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftAuthenticatorAuthenticationMethodTarget patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftAuthenticatorAuthenticationMethodTarget put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftAuthenticatorAuthenticationMethodTarget _copy() {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = new MicrosoftAuthenticatorAuthenticationMethodTarget();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.shownContext = shownContext;
        _x.isNumberMatchingRequired = isNumberMatchingRequired;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftAuthenticatorAuthenticationMethodTarget[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("shownContext=");
        b.append(this.shownContext);
        b.append(", ");
        b.append("isNumberMatchingRequired=");
        b.append(this.isNumberMatchingRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
