package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.MessageRuleActions;
import odata.msgraph.client.beta.complex.MessageRulePredicates;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "sequence", 
    "conditions", 
    "actions", 
    "exceptions", 
    "isEnabled", 
    "hasError", 
    "isReadOnly"})
@JsonInclude(Include.NON_NULL)
public class MessageRule extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.messageRule";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("sequence")
    protected Integer sequence;

    @JsonProperty("conditions")
    protected MessageRulePredicates conditions;

    @JsonProperty("actions")
    protected MessageRuleActions actions;

    @JsonProperty("exceptions")
    protected MessageRulePredicates exceptions;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("hasError")
    protected Boolean hasError;

    @JsonProperty("isReadOnly")
    protected Boolean isReadOnly;

    protected MessageRule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMessageRule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Integer sequence;
        private MessageRulePredicates conditions;
        private MessageRuleActions actions;
        private MessageRulePredicates exceptions;
        private Boolean isEnabled;
        private Boolean hasError;
        private Boolean isReadOnly;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder conditions(MessageRulePredicates conditions) {
            this.conditions = conditions;
            this.changedFields = changedFields.add("conditions");
            return this;
        }

        public Builder actions(MessageRuleActions actions) {
            this.actions = actions;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder exceptions(MessageRulePredicates exceptions) {
            this.exceptions = exceptions;
            this.changedFields = changedFields.add("exceptions");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder hasError(Boolean hasError) {
            this.hasError = hasError;
            this.changedFields = changedFields.add("hasError");
            return this;
        }

        public Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            this.changedFields = changedFields.add("isReadOnly");
            return this;
        }

        public MessageRule build() {
            MessageRule _x = new MessageRule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.messageRule";
            _x.id = id;
            _x.displayName = displayName;
            _x.sequence = sequence;
            _x.conditions = conditions;
            _x.actions = actions;
            _x.exceptions = exceptions;
            _x.isEnabled = isEnabled;
            _x.hasError = hasError;
            _x.isReadOnly = isReadOnly;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MessageRule withDisplayName(String displayName) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="sequence")
    @JsonIgnore
    public Optional<Integer> getSequence() {
        return Optional.ofNullable(sequence);
    }

    public MessageRule withSequence(Integer sequence) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("sequence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.sequence = sequence;
        return _x;
    }

    @Property(name="conditions")
    @JsonIgnore
    public Optional<MessageRulePredicates> getConditions() {
        return Optional.ofNullable(conditions);
    }

    public MessageRule withConditions(MessageRulePredicates conditions) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("conditions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.conditions = conditions;
        return _x;
    }

    @Property(name="actions")
    @JsonIgnore
    public Optional<MessageRuleActions> getActions() {
        return Optional.ofNullable(actions);
    }

    public MessageRule withActions(MessageRuleActions actions) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("actions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.actions = actions;
        return _x;
    }

    @Property(name="exceptions")
    @JsonIgnore
    public Optional<MessageRulePredicates> getExceptions() {
        return Optional.ofNullable(exceptions);
    }

    public MessageRule withExceptions(MessageRulePredicates exceptions) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("exceptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.exceptions = exceptions;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public MessageRule withIsEnabled(Boolean isEnabled) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="hasError")
    @JsonIgnore
    public Optional<Boolean> getHasError() {
        return Optional.ofNullable(hasError);
    }

    public MessageRule withHasError(Boolean hasError) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("hasError");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.hasError = hasError;
        return _x;
    }

    @Property(name="isReadOnly")
    @JsonIgnore
    public Optional<Boolean> getIsReadOnly() {
        return Optional.ofNullable(isReadOnly);
    }

    public MessageRule withIsReadOnly(Boolean isReadOnly) {
        MessageRule _x = _copy();
        _x.changedFields = changedFields.add("isReadOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRule");
        _x.isReadOnly = isReadOnly;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MessageRule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MessageRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MessageRule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MessageRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MessageRule _copy() {
        MessageRule _x = new MessageRule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.sequence = sequence;
        _x.conditions = conditions;
        _x.actions = actions;
        _x.exceptions = exceptions;
        _x.isEnabled = isEnabled;
        _x.hasError = hasError;
        _x.isReadOnly = isReadOnly;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MessageRule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("conditions=");
        b.append(this.conditions);
        b.append(", ");
        b.append("actions=");
        b.append(this.actions);
        b.append(", ");
        b.append("exceptions=");
        b.append(this.exceptions);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("hasError=");
        b.append(this.hasError);
        b.append(", ");
        b.append("isReadOnly=");
        b.append(this.isReadOnly);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
