package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.FollowupFlag;
import odata.msgraph.client.beta.complex.InternetMessageHeader;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.MentionsPreview;
import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MentionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.InferenceClassificationType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "receivedDateTime", 
    "sentDateTime", 
    "hasAttachments", 
    "internetMessageId", 
    "internetMessageHeaders", 
    "subject", 
    "body", 
    "bodyPreview", 
    "importance", 
    "parentFolderId", 
    "sender", 
    "from", 
    "toRecipients", 
    "ccRecipients", 
    "bccRecipients", 
    "replyTo", 
    "conversationId", 
    "conversationIndex", 
    "uniqueBody", 
    "isDeliveryReceiptRequested", 
    "isReadReceiptRequested", 
    "isRead", 
    "isDraft", 
    "webLink", 
    "mentionsPreview", 
    "inferenceClassification", 
    "unsubscribeData", 
    "unsubscribeEnabled", 
    "flag"})
@JsonInclude(Include.NON_NULL)
public class Message extends OutlookItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.message";
    }

    @JsonProperty("receivedDateTime")
    protected OffsetDateTime receivedDateTime;

    @JsonProperty("sentDateTime")
    protected OffsetDateTime sentDateTime;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("internetMessageId")
    protected String internetMessageId;

    @JsonProperty("internetMessageHeaders")
    protected List<InternetMessageHeader> internetMessageHeaders;

    @JsonProperty("internetMessageHeaders@nextLink")
    protected String internetMessageHeadersNextLink;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("bodyPreview")
    protected String bodyPreview;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("sender")
    protected Recipient sender;

    @JsonProperty("from")
    protected Recipient from;

    @JsonProperty("toRecipients")
    protected List<Recipient> toRecipients;

    @JsonProperty("toRecipients@nextLink")
    protected String toRecipientsNextLink;

    @JsonProperty("ccRecipients")
    protected List<Recipient> ccRecipients;

    @JsonProperty("ccRecipients@nextLink")
    protected String ccRecipientsNextLink;

    @JsonProperty("bccRecipients")
    protected List<Recipient> bccRecipients;

    @JsonProperty("bccRecipients@nextLink")
    protected String bccRecipientsNextLink;

    @JsonProperty("replyTo")
    protected List<Recipient> replyTo;

    @JsonProperty("replyTo@nextLink")
    protected String replyToNextLink;

    @JsonProperty("conversationId")
    protected String conversationId;

    @JsonProperty("conversationIndex")
    protected byte[] conversationIndex;

    @JsonProperty("uniqueBody")
    protected ItemBody uniqueBody;

    @JsonProperty("isDeliveryReceiptRequested")
    protected Boolean isDeliveryReceiptRequested;

    @JsonProperty("isReadReceiptRequested")
    protected Boolean isReadReceiptRequested;

    @JsonProperty("isRead")
    protected Boolean isRead;

    @JsonProperty("isDraft")
    protected Boolean isDraft;

    @JsonProperty("webLink")
    protected String webLink;

    @JsonProperty("mentionsPreview")
    protected MentionsPreview mentionsPreview;

    @JsonProperty("inferenceClassification")
    protected InferenceClassificationType inferenceClassification;

    @JsonProperty("unsubscribeData")
    protected List<String> unsubscribeData;

    @JsonProperty("unsubscribeData@nextLink")
    protected String unsubscribeDataNextLink;

    @JsonProperty("unsubscribeEnabled")
    protected Boolean unsubscribeEnabled;

    @JsonProperty("flag")
    protected FollowupFlag flag;

    protected Message() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMessage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String changeKey;
        private List<String> categories;
        private String categoriesNextLink;
        private OffsetDateTime receivedDateTime;
        private OffsetDateTime sentDateTime;
        private Boolean hasAttachments;
        private String internetMessageId;
        private List<InternetMessageHeader> internetMessageHeaders;
        private String internetMessageHeadersNextLink;
        private String subject;
        private ItemBody body;
        private String bodyPreview;
        private Importance importance;
        private String parentFolderId;
        private Recipient sender;
        private Recipient from;
        private List<Recipient> toRecipients;
        private String toRecipientsNextLink;
        private List<Recipient> ccRecipients;
        private String ccRecipientsNextLink;
        private List<Recipient> bccRecipients;
        private String bccRecipientsNextLink;
        private List<Recipient> replyTo;
        private String replyToNextLink;
        private String conversationId;
        private byte[] conversationIndex;
        private ItemBody uniqueBody;
        private Boolean isDeliveryReceiptRequested;
        private Boolean isReadReceiptRequested;
        private Boolean isRead;
        private Boolean isDraft;
        private String webLink;
        private MentionsPreview mentionsPreview;
        private InferenceClassificationType inferenceClassification;
        private List<String> unsubscribeData;
        private String unsubscribeDataNextLink;
        private Boolean unsubscribeEnabled;
        private FollowupFlag flag;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder receivedDateTime(OffsetDateTime receivedDateTime) {
            this.receivedDateTime = receivedDateTime;
            this.changedFields = changedFields.add("receivedDateTime");
            return this;
        }

        public Builder sentDateTime(OffsetDateTime sentDateTime) {
            this.sentDateTime = sentDateTime;
            this.changedFields = changedFields.add("sentDateTime");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder internetMessageId(String internetMessageId) {
            this.internetMessageId = internetMessageId;
            this.changedFields = changedFields.add("internetMessageId");
            return this;
        }

        public Builder internetMessageHeaders(List<InternetMessageHeader> internetMessageHeaders) {
            this.internetMessageHeaders = internetMessageHeaders;
            this.changedFields = changedFields.add("internetMessageHeaders");
            return this;
        }

        public Builder internetMessageHeaders(InternetMessageHeader... internetMessageHeaders) {
            return internetMessageHeaders(Arrays.asList(internetMessageHeaders));
        }

        public Builder internetMessageHeadersNextLink(String internetMessageHeadersNextLink) {
            this.internetMessageHeadersNextLink = internetMessageHeadersNextLink;
            this.changedFields = changedFields.add("internetMessageHeaders");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder bodyPreview(String bodyPreview) {
            this.bodyPreview = bodyPreview;
            this.changedFields = changedFields.add("bodyPreview");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder sender(Recipient sender) {
            this.sender = sender;
            this.changedFields = changedFields.add("sender");
            return this;
        }

        public Builder from(Recipient from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder toRecipients(List<Recipient> toRecipients) {
            this.toRecipients = toRecipients;
            this.changedFields = changedFields.add("toRecipients");
            return this;
        }

        public Builder toRecipients(Recipient... toRecipients) {
            return toRecipients(Arrays.asList(toRecipients));
        }

        public Builder toRecipientsNextLink(String toRecipientsNextLink) {
            this.toRecipientsNextLink = toRecipientsNextLink;
            this.changedFields = changedFields.add("toRecipients");
            return this;
        }

        public Builder ccRecipients(List<Recipient> ccRecipients) {
            this.ccRecipients = ccRecipients;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder ccRecipients(Recipient... ccRecipients) {
            return ccRecipients(Arrays.asList(ccRecipients));
        }

        public Builder ccRecipientsNextLink(String ccRecipientsNextLink) {
            this.ccRecipientsNextLink = ccRecipientsNextLink;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder bccRecipients(List<Recipient> bccRecipients) {
            this.bccRecipients = bccRecipients;
            this.changedFields = changedFields.add("bccRecipients");
            return this;
        }

        public Builder bccRecipients(Recipient... bccRecipients) {
            return bccRecipients(Arrays.asList(bccRecipients));
        }

        public Builder bccRecipientsNextLink(String bccRecipientsNextLink) {
            this.bccRecipientsNextLink = bccRecipientsNextLink;
            this.changedFields = changedFields.add("bccRecipients");
            return this;
        }

        public Builder replyTo(List<Recipient> replyTo) {
            this.replyTo = replyTo;
            this.changedFields = changedFields.add("replyTo");
            return this;
        }

        public Builder replyTo(Recipient... replyTo) {
            return replyTo(Arrays.asList(replyTo));
        }

        public Builder replyToNextLink(String replyToNextLink) {
            this.replyToNextLink = replyToNextLink;
            this.changedFields = changedFields.add("replyTo");
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            this.changedFields = changedFields.add("conversationId");
            return this;
        }

        public Builder conversationIndex(byte[] conversationIndex) {
            this.conversationIndex = conversationIndex;
            this.changedFields = changedFields.add("conversationIndex");
            return this;
        }

        public Builder uniqueBody(ItemBody uniqueBody) {
            this.uniqueBody = uniqueBody;
            this.changedFields = changedFields.add("uniqueBody");
            return this;
        }

        public Builder isDeliveryReceiptRequested(Boolean isDeliveryReceiptRequested) {
            this.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
            this.changedFields = changedFields.add("isDeliveryReceiptRequested");
            return this;
        }

        public Builder isReadReceiptRequested(Boolean isReadReceiptRequested) {
            this.isReadReceiptRequested = isReadReceiptRequested;
            this.changedFields = changedFields.add("isReadReceiptRequested");
            return this;
        }

        public Builder isRead(Boolean isRead) {
            this.isRead = isRead;
            this.changedFields = changedFields.add("isRead");
            return this;
        }

        public Builder isDraft(Boolean isDraft) {
            this.isDraft = isDraft;
            this.changedFields = changedFields.add("isDraft");
            return this;
        }

        public Builder webLink(String webLink) {
            this.webLink = webLink;
            this.changedFields = changedFields.add("webLink");
            return this;
        }

        public Builder mentionsPreview(MentionsPreview mentionsPreview) {
            this.mentionsPreview = mentionsPreview;
            this.changedFields = changedFields.add("mentionsPreview");
            return this;
        }

        public Builder inferenceClassification(InferenceClassificationType inferenceClassification) {
            this.inferenceClassification = inferenceClassification;
            this.changedFields = changedFields.add("inferenceClassification");
            return this;
        }

        public Builder unsubscribeData(List<String> unsubscribeData) {
            this.unsubscribeData = unsubscribeData;
            this.changedFields = changedFields.add("unsubscribeData");
            return this;
        }

        public Builder unsubscribeData(String... unsubscribeData) {
            return unsubscribeData(Arrays.asList(unsubscribeData));
        }

        public Builder unsubscribeDataNextLink(String unsubscribeDataNextLink) {
            this.unsubscribeDataNextLink = unsubscribeDataNextLink;
            this.changedFields = changedFields.add("unsubscribeData");
            return this;
        }

        public Builder unsubscribeEnabled(Boolean unsubscribeEnabled) {
            this.unsubscribeEnabled = unsubscribeEnabled;
            this.changedFields = changedFields.add("unsubscribeEnabled");
            return this;
        }

        public Builder flag(FollowupFlag flag) {
            this.flag = flag;
            this.changedFields = changedFields.add("flag");
            return this;
        }

        public Message build() {
            Message _x = new Message();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.message";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.changeKey = changeKey;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.receivedDateTime = receivedDateTime;
            _x.sentDateTime = sentDateTime;
            _x.hasAttachments = hasAttachments;
            _x.internetMessageId = internetMessageId;
            _x.internetMessageHeaders = internetMessageHeaders;
            _x.internetMessageHeadersNextLink = internetMessageHeadersNextLink;
            _x.subject = subject;
            _x.body = body;
            _x.bodyPreview = bodyPreview;
            _x.importance = importance;
            _x.parentFolderId = parentFolderId;
            _x.sender = sender;
            _x.from = from;
            _x.toRecipients = toRecipients;
            _x.toRecipientsNextLink = toRecipientsNextLink;
            _x.ccRecipients = ccRecipients;
            _x.ccRecipientsNextLink = ccRecipientsNextLink;
            _x.bccRecipients = bccRecipients;
            _x.bccRecipientsNextLink = bccRecipientsNextLink;
            _x.replyTo = replyTo;
            _x.replyToNextLink = replyToNextLink;
            _x.conversationId = conversationId;
            _x.conversationIndex = conversationIndex;
            _x.uniqueBody = uniqueBody;
            _x.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
            _x.isReadReceiptRequested = isReadReceiptRequested;
            _x.isRead = isRead;
            _x.isDraft = isDraft;
            _x.webLink = webLink;
            _x.mentionsPreview = mentionsPreview;
            _x.inferenceClassification = inferenceClassification;
            _x.unsubscribeData = unsubscribeData;
            _x.unsubscribeDataNextLink = unsubscribeDataNextLink;
            _x.unsubscribeEnabled = unsubscribeEnabled;
            _x.flag = flag;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="receivedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReceivedDateTime() {
        return Optional.ofNullable(receivedDateTime);
    }

    public Message withReceivedDateTime(OffsetDateTime receivedDateTime) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("receivedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.receivedDateTime = receivedDateTime;
        return _x;
    }

    @Property(name="sentDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSentDateTime() {
        return Optional.ofNullable(sentDateTime);
    }

    public Message withSentDateTime(OffsetDateTime sentDateTime) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("sentDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.sentDateTime = sentDateTime;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public Message withHasAttachments(Boolean hasAttachments) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="internetMessageId")
    @JsonIgnore
    public Optional<String> getInternetMessageId() {
        return Optional.ofNullable(internetMessageId);
    }

    public Message withInternetMessageId(String internetMessageId) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("internetMessageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.internetMessageId = internetMessageId;
        return _x;
    }

    @Property(name="internetMessageHeaders")
    @JsonIgnore
    public CollectionPage<InternetMessageHeader> getInternetMessageHeaders() {
        return new CollectionPage<InternetMessageHeader>(contextPath, InternetMessageHeader.class, internetMessageHeaders, Optional.ofNullable(internetMessageHeadersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="internetMessageHeaders")
    @JsonIgnore
    public CollectionPage<InternetMessageHeader> getInternetMessageHeaders(HttpRequestOptions options) {
        return new CollectionPage<InternetMessageHeader>(contextPath, InternetMessageHeader.class, internetMessageHeaders, Optional.ofNullable(internetMessageHeadersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Message withSubject(String subject) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.subject = subject;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public Message withBody(ItemBody body) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.body = body;
        return _x;
    }

    @Property(name="bodyPreview")
    @JsonIgnore
    public Optional<String> getBodyPreview() {
        return Optional.ofNullable(bodyPreview);
    }

    public Message withBodyPreview(String bodyPreview) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("bodyPreview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.bodyPreview = bodyPreview;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public Message withImportance(Importance importance) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.importance = importance;
        return _x;
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public Message withParentFolderId(String parentFolderId) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="sender")
    @JsonIgnore
    public Optional<Recipient> getSender() {
        return Optional.ofNullable(sender);
    }

    public Message withSender(Recipient sender) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("sender");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.sender = sender;
        return _x;
    }

    @Property(name="from")
    @JsonIgnore
    public Optional<Recipient> getFrom() {
        return Optional.ofNullable(from);
    }

    public Message withFrom(Recipient from) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("from");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.from = from;
        return _x;
    }

    @Property(name="toRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getToRecipients() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, toRecipients, Optional.ofNullable(toRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="toRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getToRecipients(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, toRecipients, Optional.ofNullable(toRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="ccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getCcRecipients() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, ccRecipients, Optional.ofNullable(ccRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getCcRecipients(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, ccRecipients, Optional.ofNullable(ccRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="bccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getBccRecipients() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, bccRecipients, Optional.ofNullable(bccRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="bccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getBccRecipients(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, bccRecipients, Optional.ofNullable(bccRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="replyTo")
    @JsonIgnore
    public CollectionPage<Recipient> getReplyTo() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, replyTo, Optional.ofNullable(replyToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="replyTo")
    @JsonIgnore
    public CollectionPage<Recipient> getReplyTo(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, replyTo, Optional.ofNullable(replyToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="conversationId")
    @JsonIgnore
    public Optional<String> getConversationId() {
        return Optional.ofNullable(conversationId);
    }

    public Message withConversationId(String conversationId) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("conversationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.conversationId = conversationId;
        return _x;
    }

    @Property(name="conversationIndex")
    @JsonIgnore
    public Optional<byte[]> getConversationIndex() {
        return Optional.ofNullable(conversationIndex);
    }

    public Message withConversationIndex(byte[] conversationIndex) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("conversationIndex");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.conversationIndex = conversationIndex;
        return _x;
    }

    @Property(name="uniqueBody")
    @JsonIgnore
    public Optional<ItemBody> getUniqueBody() {
        return Optional.ofNullable(uniqueBody);
    }

    public Message withUniqueBody(ItemBody uniqueBody) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("uniqueBody");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.uniqueBody = uniqueBody;
        return _x;
    }

    @Property(name="isDeliveryReceiptRequested")
    @JsonIgnore
    public Optional<Boolean> getIsDeliveryReceiptRequested() {
        return Optional.ofNullable(isDeliveryReceiptRequested);
    }

    public Message withIsDeliveryReceiptRequested(Boolean isDeliveryReceiptRequested) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("isDeliveryReceiptRequested");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
        return _x;
    }

    @Property(name="isReadReceiptRequested")
    @JsonIgnore
    public Optional<Boolean> getIsReadReceiptRequested() {
        return Optional.ofNullable(isReadReceiptRequested);
    }

    public Message withIsReadReceiptRequested(Boolean isReadReceiptRequested) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("isReadReceiptRequested");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.isReadReceiptRequested = isReadReceiptRequested;
        return _x;
    }

    @Property(name="isRead")
    @JsonIgnore
    public Optional<Boolean> getIsRead() {
        return Optional.ofNullable(isRead);
    }

    public Message withIsRead(Boolean isRead) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("isRead");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.isRead = isRead;
        return _x;
    }

    @Property(name="isDraft")
    @JsonIgnore
    public Optional<Boolean> getIsDraft() {
        return Optional.ofNullable(isDraft);
    }

    public Message withIsDraft(Boolean isDraft) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("isDraft");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.isDraft = isDraft;
        return _x;
    }

    @Property(name="webLink")
    @JsonIgnore
    public Optional<String> getWebLink() {
        return Optional.ofNullable(webLink);
    }

    public Message withWebLink(String webLink) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("webLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.webLink = webLink;
        return _x;
    }

    @Property(name="mentionsPreview")
    @JsonIgnore
    public Optional<MentionsPreview> getMentionsPreview() {
        return Optional.ofNullable(mentionsPreview);
    }

    public Message withMentionsPreview(MentionsPreview mentionsPreview) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("mentionsPreview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.mentionsPreview = mentionsPreview;
        return _x;
    }

    @Property(name="inferenceClassification")
    @JsonIgnore
    public Optional<InferenceClassificationType> getInferenceClassification() {
        return Optional.ofNullable(inferenceClassification);
    }

    public Message withInferenceClassification(InferenceClassificationType inferenceClassification) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("inferenceClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.inferenceClassification = inferenceClassification;
        return _x;
    }

    @Property(name="unsubscribeData")
    @JsonIgnore
    public CollectionPage<String> getUnsubscribeData() {
        return new CollectionPage<String>(contextPath, String.class, unsubscribeData, Optional.ofNullable(unsubscribeDataNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="unsubscribeData")
    @JsonIgnore
    public CollectionPage<String> getUnsubscribeData(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, unsubscribeData, Optional.ofNullable(unsubscribeDataNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="unsubscribeEnabled")
    @JsonIgnore
    public Optional<Boolean> getUnsubscribeEnabled() {
        return Optional.ofNullable(unsubscribeEnabled);
    }

    public Message withUnsubscribeEnabled(Boolean unsubscribeEnabled) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("unsubscribeEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.unsubscribeEnabled = unsubscribeEnabled;
        return _x;
    }

    @Property(name="flag")
    @JsonIgnore
    public Optional<FollowupFlag> getFlag() {
        return Optional.ofNullable(flag);
    }

    public Message withFlag(FollowupFlag flag) {
        Message _x = _copy();
        _x.changedFields = changedFields.add("flag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.message");
        _x.flag = flag;
        return _x;
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property attachments
     */
    @NavigationProperty(name="attachments")
    @JsonIgnore
    public AttachmentCollectionRequest getAttachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property extensions
     */
    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property mentions
     */
    @NavigationProperty(name="mentions")
    @JsonIgnore
    public MentionCollectionRequest getMentions() {
        return new MentionCollectionRequest(
                        contextPath.addSegment("mentions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Message patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Message _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Message put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Message _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Message _copy() {
        Message _x = new Message();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.changeKey = changeKey;
        _x.categories = categories;
        _x.receivedDateTime = receivedDateTime;
        _x.sentDateTime = sentDateTime;
        _x.hasAttachments = hasAttachments;
        _x.internetMessageId = internetMessageId;
        _x.internetMessageHeaders = internetMessageHeaders;
        _x.subject = subject;
        _x.body = body;
        _x.bodyPreview = bodyPreview;
        _x.importance = importance;
        _x.parentFolderId = parentFolderId;
        _x.sender = sender;
        _x.from = from;
        _x.toRecipients = toRecipients;
        _x.ccRecipients = ccRecipients;
        _x.bccRecipients = bccRecipients;
        _x.replyTo = replyTo;
        _x.conversationId = conversationId;
        _x.conversationIndex = conversationIndex;
        _x.uniqueBody = uniqueBody;
        _x.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
        _x.isReadReceiptRequested = isReadReceiptRequested;
        _x.isRead = isRead;
        _x.isDraft = isDraft;
        _x.webLink = webLink;
        _x.mentionsPreview = mentionsPreview;
        _x.inferenceClassification = inferenceClassification;
        _x.unsubscribeData = unsubscribeData;
        _x.unsubscribeEnabled = unsubscribeEnabled;
        _x.flag = flag;
        return _x;
    }

    @Action(name = "createReply")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> createReply(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createReply"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "createReplyAll")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> createReplyAll(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createReplyAll"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "createForward")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> createForward(List<Recipient> toRecipients, Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createForward"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> copy(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> move(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "reply")
    @JsonIgnore
    public ActionRequestNoReturn reply(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reply"), _parameters);
    }

    @Action(name = "replyAll")
    @JsonIgnore
    public ActionRequestNoReturn replyAll(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.replyAll"), _parameters);
    }

    @Action(name = "forward")
    @JsonIgnore
    public ActionRequestNoReturn forward(List<Recipient> toRecipients, Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forward"), _parameters);
    }

    @Action(name = "unsubscribe")
    @JsonIgnore
    public ActionRequestNoReturn unsubscribe() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubscribe"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Message[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("receivedDateTime=");
        b.append(this.receivedDateTime);
        b.append(", ");
        b.append("sentDateTime=");
        b.append(this.sentDateTime);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("internetMessageId=");
        b.append(this.internetMessageId);
        b.append(", ");
        b.append("internetMessageHeaders=");
        b.append(this.internetMessageHeaders);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("bodyPreview=");
        b.append(this.bodyPreview);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("sender=");
        b.append(this.sender);
        b.append(", ");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("toRecipients=");
        b.append(this.toRecipients);
        b.append(", ");
        b.append("ccRecipients=");
        b.append(this.ccRecipients);
        b.append(", ");
        b.append("bccRecipients=");
        b.append(this.bccRecipients);
        b.append(", ");
        b.append("replyTo=");
        b.append(this.replyTo);
        b.append(", ");
        b.append("conversationId=");
        b.append(this.conversationId);
        b.append(", ");
        b.append("conversationIndex=");
        b.append(this.conversationIndex);
        b.append(", ");
        b.append("uniqueBody=");
        b.append(this.uniqueBody);
        b.append(", ");
        b.append("isDeliveryReceiptRequested=");
        b.append(this.isDeliveryReceiptRequested);
        b.append(", ");
        b.append("isReadReceiptRequested=");
        b.append(this.isReadReceiptRequested);
        b.append(", ");
        b.append("isRead=");
        b.append(this.isRead);
        b.append(", ");
        b.append("isDraft=");
        b.append(this.isDraft);
        b.append(", ");
        b.append("webLink=");
        b.append(this.webLink);
        b.append(", ");
        b.append("mentionsPreview=");
        b.append(this.mentionsPreview);
        b.append(", ");
        b.append("inferenceClassification=");
        b.append(this.inferenceClassification);
        b.append(", ");
        b.append("unsubscribeData=");
        b.append(this.unsubscribeData);
        b.append(", ");
        b.append("unsubscribeEnabled=");
        b.append(this.unsubscribeEnabled);
        b.append(", ");
        b.append("flag=");
        b.append(this.flag);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
